#include "mbed.h"
#include "N5110.h"
#include "string"

N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18); 

//KOORDINATE
AnalogIn X(dp11), Y(dp10);
DigitalOut enable(dp14); 
 
 //INTERRUPTI
InterruptIn SW(dp9);
DigitalIn SW1(dp9);
DigitalOut T1(dp1);

// MODOVI
bool meni (false);
bool info (false);
bool izlaz (false);
bool P1vP2 (false);
bool P1vCPU (false);

// REZULTAT
int brojacP1=0; 
int brojacP2=0; 
int brojacCPU=0;
string zapamtiRezultat;

// KOORDINATE CENTARA X i O // REFERENTNE TACKE
int x1 = 21, y1 = 12;
int x2 = 38, y2 = 12;
int x3 = 56, y3 = 12;
int x4 = 21, y4 = 22;
int x5 = 38, y5 = 22;
int x6 = 56, y6 = 22;
int x7 = 21, y7 = 32;
int x8 = 38, y8 = 32;
int x9 = 56, y9 = 32;


//OCISTI EKRAN
void ocistiEkran(int x, int y)
{
    lcd.setXYAddress(0,0);
    for (int i = 18; i < 46; i++)
        for(int j = 2; j < 42; j++)
            lcd.clearPixel(i,j);
}

//SAMO MREZA
void crtajMrezu(){
    lcd.clear();
    lcd.setXYAddress(0,0);
   for (int i = 10; i<38;i++)
    {
        lcd.setPixel(29,i);
    }
    for (int i = 10; i<38;i++)
    {
        lcd.setPixel(47,i);
    }
    for (int i = 17; i<61;i++)
    {
        lcd.setPixel(i,18);
    }
    for (int i = 17; i<61;i++)
    {
        lcd.setPixel(i,28);
    }
    lcd.refresh();   
}





// POZICIJE KURSORA U MENIJU
class poz1{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz2{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz3{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz4{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz5{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz6{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz7{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz8{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};
class poz9{
public:
    bool aktiviran;
    int x, y;
    bool upisano;
};

// POZICIJE, INSTANCE 
poz1 pozicija1;
poz2 pozicija2;
poz3 pozicija3;
poz4 pozicija4;
poz5 pozicija5;
poz6 pozicija6;
poz7 pozicija7;
poz8 pozicija8;
poz9 pozicija9;
 
// TIMER-TICKER
Timer press;
Timer joystick;
Ticker ticker;
bool set = true;
 
// KOORDINATE KURSORA (STRELICE)
int point[2] = {0, 2};
// CRTANJE STRELICE
void strelica()
{
    lcd.printString("->",point[0],point[1]);
}
// ISPIS POCETNOG MENIJA
void pocetniMeni()
{
    lcd.clear();
    lcd.printString("** IKS-OKS **",0,0);
    lcd.printString("P1 v P2",12,2);
    lcd.printString("P1 v CPU",12,3);
    lcd.printString("Izadi",12,4);
    lcd.printString("Detalji",12,5);
}
// ISPIS DETALJA O IGRICI (ABOUT THE GAME)
void detalji()
{
    lcd.clear();
    lcd.printString("IKS-OKS v1.0",0,0);
    lcd.printString("autori:",0,1);
    lcd.printString("D. Emir",0,2);
    lcd.printString("K. Aldin",0,3);
    lcd.printString("mentor Emir S.,",0,4);
    lcd.printString("dipl.ing.el.",0,5);
    
    wait(3);
    pocetniMeni();
}
// IZLAZ IZ APLIKACIJE
void izadi ()
{
    lcd.clear();
}
// KRETANJE KROZ MENI
void scroll()
{
        strelica();   
        if(Y<1.0/3.0) {
            lcd.printString("  ",point[0], point[1]);
            if(point[1]==5) point[1]=2;
            else point[1]+=1;
        }
        wait(0.33);
}
//CRTANJE CROSSHAIR
void Kursor(int x, int y)//lcd.SetXYAddress(_,_);
{
    lcd.setXYAddress(0,0);
    lcd.setPixel(x+1, y);
    lcd.setPixel(x, y+1);
    lcd.setPixel(x-1, y);
    lcd.setPixel(x, y-1);
    lcd.refresh();
}

void clearKursor(int x, int y)
{
    lcd.setXYAddress(0,0);
    lcd.clearPixel(x+1, y);
    lcd.clearPixel(x, y+1);
    lcd.clearPixel(x-1, y);
    lcd.clearPixel(x, y-1);
    lcd.refresh();
}
// CRTANJE X
void IKS(int x, int y){ // lcd.SetXYAddress(_,_);
    lcd.setXYAddress(0,0);
    lcd.setPixel(x,y);
    lcd.setPixel(x+1,y+1);
    lcd.setPixel(x+2,y+2);
    lcd.setPixel(x+3,y+3);
    lcd.setPixel(x+1,y-1);
    lcd.setPixel(x+2,y-2);
    lcd.setPixel(x+3,y-3);
    lcd.setPixel(x-1,y+1);
    lcd.setPixel(x-2,y+2);
    lcd.setPixel(x-3,y+3);
    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x-2,y-2);
    lcd.setPixel(x-3,y-3);
    lcd.refresh();    
}
// CRTANJE O
void OKS(int x, int y){ // lcd.setXYAddress(_,_);
    lcd.setXYAddress(0,0);
    lcd.setPixel(x,y+3);
    lcd.setPixel(x+1,y+3);
    lcd.setPixel(x+2,y+2);
    lcd.setPixel(x+3,y+1);
    lcd.setPixel(x+3,y);
    lcd.setPixel(x+3,y-1);
    lcd.setPixel(x+2,y-2);
    lcd.setPixel(x+1,y-3);
    lcd.setPixel(x,y-3);
    lcd.setPixel(x-1,y-3);
    lcd.setPixel(x-2,y-2);
    lcd.setPixel(x-3,y-1);
    lcd.setPixel(x-3,y);
    lcd.setPixel(x-3,y+1);
    lcd.setPixel(x-2,y+2);
    lcd.setPixel(x-1,y+3);
    lcd.refresh();    
}

// BROJACI NIZANIH ZNAKOVA OKS "O"
int Ojedan(0), Odva(0), Otri(0), Ocetiri(0), Opet(0), Osest(0), Osedam(0), Oosam(0);

// BROJACI NIZANIH ZNAKOVA IKS "X"
int Xjedan(0), Xdva(0), Xtri(0), Xcetiri(0), Xpet(0), Xsest(0), Xsedam(0), Xosam(0);

// BROJAC POTEZA u P1vP2 (kontrolise X i O), ODNOSNO BROJAC IGRACEVIH POTEZA U P1vCPU 
int  brojac(0);

// VALIDACIJA AKTIVNOSTI NA POLJU ZA IGRU
void Validacija()
{
    if(Ojedan == 3 || Odva == 3 || Otri == 3 || Ocetiri == 3 || Opet == 3 || Osest == 3 || Osedam == 3|| Oosam == 3)
    {
        void ocistiEkran(int x, int y);
        if(P1vP2){
            brojacP2++; if(brojac>3) return;
            lcd.printString("Pobijedio P2", 0, 5); 
            wait(2);
            if(brojacP2==1) {
                if(brojacP1==0) { lcd.printString("  P1 0:1 P2", 0, 5); zapamtiRezultat="  P1 0:1 P2"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:1 P2", 0, 5); zapamtiRezultat="  P1 1:1 P2"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:1 P2", 0, 5); zapamtiRezultat="  P1 2:1 P2"; }
    pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;
            }
            else if(brojacP2==2) { 
                if(brojacP1==0) { lcd.printString("  P1 0:2 P2", 0, 5); zapamtiRezultat="  P1 0:2 P2"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:2 P2", 0, 5); zapamtiRezultat="  P1 1:2 P2"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:2 P2", 0, 5); zapamtiRezultat="  P1 2:2 P2"; }
                pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;
            }
            else if(brojacP2==3) { 
                if(brojacP1==0) { lcd.printString("  P1 0:3 P2", 0, 5); zapamtiRezultat="  P1 0:3 P2"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:3 P2", 0, 5); zapamtiRezultat="  P1 1:3 P2"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:3 P2", 0, 5); zapamtiRezultat="  P1 2:3 P2"; }
                lcd.printString("Konacni pobjednik P2!",0,5); wait(5); ocistiEkran(0,0);
                // POSTAVI NA FALSE 
                    pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;
            }
        }
        else if(P1vCPU)
        {
            void ocistiEkran(int x, int y);
            brojacCPU++; if(brojacCPU>3) return;
            lcd.printString("Pobijedio CPU", 0, 5); 
            wait(2);
            if(brojacCPU==1) {
                if(brojacP1==0) { lcd.printString("  P1 0:1 CPU", 0, 5); zapamtiRezultat="  P1 0:1 CPU"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:1 CPU", 0, 5); zapamtiRezultat="  P1 1:1 CPU"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:1 CPU", 0, 5); zapamtiRezultat="  P1 2:1 CPU"; }
    pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;            }
            else if(brojacCPU==2) { 
                if(brojacP1==0) { lcd.printString("  P1 0:2 CPU", 0, 5); zapamtiRezultat="  P1 0:2 CPU"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:2 CPU", 0, 5); zapamtiRezultat="  P1 1:2 CPU"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:2 CPU", 0, 5); zapamtiRezultat="  P1 2:2 CPU"; }
    pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;            }
            else if(brojacCPU==3) { 
                if(brojacP1==0) { lcd.printString("  P1 0:3 CPU", 0, 5); zapamtiRezultat="  P1 0:3 CPU"; }
                else if(brojacP1==1) { lcd.printString("  P1 1:3 CPU", 0, 5); zapamtiRezultat="  P1 1:3 CPU"; }
                else if(brojacP1==2) { lcd.printString("  P1 2:3 CPU", 0, 5); zapamtiRezultat="  P1 2:3 CPU"; }
                lcd.printString("Konacni pobjednik CPU!",0,5); wait(5); ocistiEkran(0,0); 
     pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;           }
        }
    }
    else if(Xjedan == 3 || Xdva == 3 || Xtri == 3 || Xcetiri == 3 || Xpet == 3 || Xsest == 3 || Xsedam == 3 || Xosam == 3)
    {
        if(P1vP2){
            void ocistiEkran(int x, int y);
            brojacP1++; if(brojacP1>3) return;
            lcd.printString("Pobijedio P1", 0, 5); 
            wait(2);
            if(brojacP1==1) {
                if(brojacP2==0) { lcd.printString("  P1 1:0 P2", 0, 5); zapamtiRezultat="  P1 1:0 P2"; }
                else if(brojacP2==1) { lcd.printString("  P1 1:3 P2", 0, 5); zapamtiRezultat="  P1 1:1 P2"; }
                else if(brojacP2==2) { lcd.printString("  P1 1:2 P2", 0, 5); zapamtiRezultat="  P1 1:2 P2"; }
     pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;           }
            else if(brojacP1==2) { 
                if(brojacP2==0) { lcd.printString("  P1 2:0 P2", 0, 5); zapamtiRezultat="  P1 2:0 P2"; }
                else if(brojacP2==1) { lcd.printString("  P1 2:1 P2", 0, 5); zapamtiRezultat="  P1 2:2 P2"; }
                else if(brojacP2==2) { lcd.printString("  P1 2:2 P2", 0, 5); zapamtiRezultat="  P1 2:2 P2"; }
       pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;         }
            else if(brojacP1==3) { 
                if(brojacP2==0) { lcd.printString("  P1 3:0 P2", 0, 5); zapamtiRezultat="  P1 3:0 P2"; }
                else if(brojacP2==1) { lcd.printString("  P1 3:1 P2", 0, 5); zapamtiRezultat="  P1 3:1 P2"; }
                else if(brojacP2==2) { lcd.printString("  P1 3:2 P2", 0, 5); zapamtiRezultat="  P1 3:2 P2"; }
                lcd.printString("Konacni pobjednik P1!",0,5); wait(5); ocistiEkran(0,0); 
       pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;         }
        }
        else if(P1vCPU)
        {
            void ocistiEkran(int x, int y);
            brojacP1++; if(brojacP1>3) return;
            lcd.printString("Pobijedio P1", 0, 5); 
            wait(2);
            if(brojacP1==1) {
                if(brojacCPU==0) { lcd.printString("  P1 1:0 CPU", 0, 5); zapamtiRezultat="  P1 1:0 CPU"; }
                else if(brojacCPU==1) { lcd.printString("  P1 1:3 CPU", 0, 5); zapamtiRezultat="  P1 1:1 CPU"; }
                else if(brojacCPU==2) { lcd.printString("  P1 1:2 CPU", 0, 5); zapamtiRezultat="  P1 1:2 CPU"; }
     pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;           }
            else if(brojacP1==2) { 
                if(brojacCPU==0) { lcd.printString("  P1 2:0 CPU", 0, 5); zapamtiRezultat="  P1 2:0 CPU"; }
                else if(brojacCPU==1) { lcd.printString("  P1 2:1 CPU", 0, 5); zapamtiRezultat="  P1 2:2 CPU"; }
                else if(brojacCPU==2) { lcd.printString("  P1 2:2 CPU", 0, 5); zapamtiRezultat="  P1 2:2 CPU"; }
       pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;         }
            else if(brojacP1==3) { 
                if(brojacCPU==0) { lcd.printString("  P1 3:0 CPU", 0, 5); zapamtiRezultat="  P1 3:0 CPU"; }
                else if(brojacCPU==1) { lcd.printString("  P1 3:1 CPU", 0, 5); zapamtiRezultat="  P1 3:1 CPU"; }
                else if(brojacCPU==2) { lcd.printString("  P1 3:2 CPU", 0, 5); zapamtiRezultat="  P1 3:2 CPU"; }
                lcd.printString("Konacni pobjednik P1!",0,5); wait(5); ocistiEkran(0,0); 
       pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;         }
        }
    }
    else if(P1vP2 && brojac == 9)
    { 
        
        wait(3); 
        ocistiEkran(0,0); crtajMrezu();
    }
    else if(P1vCPU && brojac == 10)
    {
        
        wait(3); 
        ocistiEkran(0,0); crtajMrezu();
    }
}

// KOMPJUTER NA POTEZU
void Kompjuter()
{
        //POKUSAJ NEKI ( NE DIRATI !!!!)
        if (brojac==2)
        {
            if(!pozicija5.upisano)
            {
                pozicija1.aktiviran=false;
                pozicija2.aktiviran=false;
                pozicija3.aktiviran=false;
                pozicija4.aktiviran=false;
                pozicija5.aktiviran=true;
                pozicija6.aktiviran=false;
                pozicija7.aktiviran=false;
                pozicija8.aktiviran=false;
                pozicija9.aktiviran=false;
            }
            else if(pozicija5.upisano)
            {
                pozicija1.aktiviran=false;
                pozicija2.aktiviran=false;
                pozicija3.aktiviran=true;
                pozicija4.aktiviran=false;
                pozicija5.aktiviran=false;
                pozicija6.aktiviran=false;
                pozicija7.aktiviran=false;
                pozicija8.aktiviran=false;
                pozicija9.aktiviran=false;
            }
        }
        else if (pozicija1.upisano && pozicija2.upisano && !pozicija3.upisano && (Ojedan ==2 || Xjedan==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=true;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija1.upisano && pozicija3.upisano && !pozicija2.upisano && (Ojedan ==2 || Xjedan==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=true;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija3.upisano && pozicija2.upisano && !pozicija1.upisano && (Ojedan ==2 || Xjedan==2))
        {
            pozicija1.aktiviran=true;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija4.upisano && pozicija5.upisano && !pozicija6.upisano && (Odva ==2 || Xdva==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=true;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija4.upisano && pozicija6.upisano && !pozicija5.upisano && (Odva ==2 || Xdva==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=true;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija5.upisano && pozicija6.upisano && !pozicija4.upisano && (Odva ==2 || Xdva==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=true;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija7.upisano && pozicija8.upisano && !pozicija9.upisano && (Otri ==2 || Xtri==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=true;
        }
        else if (pozicija7.upisano && pozicija9.upisano && !pozicija8.upisano && (Otri ==2 || Xtri==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=true;
            pozicija9.aktiviran=false;
        }
        else if (pozicija8.upisano && pozicija9.upisano && !pozicija7.upisano && (Otri ==2 || Xtri==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=true;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija1.upisano && pozicija4.upisano && !pozicija7.upisano && (Ocetiri ==2 || Xcetiri==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=true;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija1.upisano && pozicija7.upisano && !pozicija4.upisano && (Ocetiri ==2 || Xcetiri==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=true;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija4.upisano && pozicija7.upisano && !pozicija1.upisano && (Ocetiri ==2 || Xcetiri==2))
        {
            pozicija1.aktiviran=true;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija2.upisano && pozicija5.upisano && !pozicija8.upisano && (Opet ==2 || Xpet==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=true;
            pozicija9.aktiviran=false;
        }
        else if (pozicija2.upisano && pozicija8.upisano && !pozicija5.upisano && (Opet ==2 || Xpet==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=true;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija5.upisano && pozicija8.upisano && !pozicija2.upisano && (Opet ==2 || Xpet==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=true;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija3.upisano && pozicija6.upisano && !pozicija9.upisano && (Osest ==2 || Xsest==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=true;
        }
        else if (pozicija3.upisano && pozicija9.upisano && !pozicija6.upisano && (Osest ==2 || Xsest==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=true;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija6.upisano && pozicija9.upisano && !pozicija3.upisano && (Osest ==2 || Xsest==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=true;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija1.upisano && pozicija5.upisano && !pozicija9.upisano && (Osedam ==2 || Xsedam==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=true;
        }
        else if (pozicija1.upisano && pozicija9.upisano && !pozicija5.upisano && (Osedam ==2 || Xsedam==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=true;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija5.upisano && pozicija9.upisano && !pozicija1.upisano && (Osedam ==2 || Xsedam==2))
        {
            pozicija1.aktiviran=true;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija3.upisano && pozicija5.upisano && !pozicija7.upisano && (Oosam ==2 || Xosam==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=true;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija3.upisano && pozicija7.upisano && !pozicija5.upisano && (Oosam ==2 || Xosam==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=false;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=true;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        else if (pozicija5.upisano && pozicija7.upisano && !pozicija3.upisano && (Oosam ==2 || Xosam==2))
        {
            pozicija1.aktiviran=false;
            pozicija2.aktiviran=false;
            pozicija3.aktiviran=true;
            pozicija4.aktiviran=false;
            pozicija5.aktiviran=false;
            pozicija6.aktiviran=false;
            pozicija7.aktiviran=false;
            pozicija8.aktiviran=false;
            pozicija9.aktiviran=false;
        }
        // OVDJE IZNAD POKUSAVAM ODREDITI POZICIJU KOJA TREBA DA SE AKTIVIRA KAD JE PC PRED POBJEDOM/PORAZOM (NEPOSREDNO)

        if(pozicija1.aktiviran==true && pozicija1.upisano==false){
            OKS(x1,y1);
            pozicija1.upisano=true;
            Ojedan++;
            Ocetiri++;
            Osedam++;   
        }
        else if(pozicija2.aktiviran==true && pozicija2.upisano==false){
            OKS(x2,y2);
            pozicija2.upisano=true;
            Ojedan++;
            Opet++;   
        }
        else if(pozicija3.aktiviran==true && pozicija3.upisano==false){
            OKS(x3,y3);
            pozicija3.upisano=true;
            Ojedan++;
            Osest++;
            Oosam++;   
        }
        else if(pozicija4.aktiviran==true && pozicija4.upisano==false){
            OKS(x4,y4);
            pozicija4.upisano=true;
            Ocetiri++;
            Odva++;   
        }
        else if(pozicija5.aktiviran==true && pozicija5.upisano==false){
            OKS(x5,y5);
            pozicija5.upisano=true;
            Odva++;
            Opet++;
            Osedam++;
            Oosam++;   
        }
        else if(pozicija6.aktiviran==true && pozicija6.upisano==false){
            OKS(x6,y6);
            pozicija6.upisano=true;
            Odva++;
            Osest++;   
        }
        else if(pozicija7.aktiviran==true && pozicija7.upisano==false){
            OKS(x7,y7);
            pozicija7.upisano=true;
            Otri++;
            Ocetiri++;
            Oosam++;   
        }
        else if(pozicija8.aktiviran==true && pozicija8.upisano==false){
            OKS(x8,y8);
            pozicija8.upisano=true;
            Otri++;
            Opet++;   
        }
        else if(pozicija9.aktiviran==true && pozicija9.upisano==false){
            OKS(x9,y9);
            pozicija9.upisano=true;   
            Otri++;
            Osedam++;
            Osest++;
        }
}

// KLIK NA POLJE ZA IGRU moda P1vP2 // kao i moda P1vCPU (P1 NA POTEZU)
void Klik(){
    if(brojac%2==0)// CRTAJ IKS
    {
        if(pozicija1.aktiviran==true && pozicija1.upisano==false){
            IKS(x1,y1);
            pozicija1.upisano=true;
            Xjedan++;
            Xcetiri++;
            Xsedam++;   
        }
        else if(pozicija2.aktiviran==true && pozicija2.upisano==false){
            IKS(x2,y2);
            pozicija2.upisano=true;   
            Xjedan++;
            Xpet++;
        }
        else if(pozicija3.aktiviran==true && pozicija3.upisano==false){
            IKS(x3,y3);
            pozicija3.upisano=true;   
            Xjedan++;
            Xsest++;
            Xosam++;
        }
        else if(pozicija4.aktiviran==true && pozicija4.upisano==false){
            IKS(x4,y4);
            pozicija4.upisano=true;   
            Xdva++;
            Xcetiri++;
        }
        else if(pozicija5.aktiviran==true && pozicija5.upisano==false){
            IKS(x5,y5);
            pozicija5.upisano=true;   
            Xdva++;
            Xpet++;
            Xsedam++;
            Xosam++;
        }
        else if(pozicija6.aktiviran==true && pozicija6.upisano==false){
            IKS(x6,y6);
            pozicija6.upisano=true;   
            Xdva++;
            Xsest++;
        }
        else if(pozicija7.aktiviran==true && pozicija7.upisano==false){
            IKS(x7,y7);
            pozicija7.upisano=true;
            Xtri++;
            Xcetiri++;
            Xosam++;
        }
        else if(pozicija8.aktiviran==true && pozicija8.upisano==false){
            IKS(x8,y8);
            pozicija8.upisano=true;
            Xtri++;
            Xpet++;   
        }
        else if(pozicija9.aktiviran==true && pozicija9.upisano==false){
            IKS(x9,y9);
            pozicija9.upisano=true;   
            Xtri++;
            Xsest++;
            Xsedam++;
        }
        Validacija();
        if(P1vP2)
           brojac++;
        if(P1vCPU)
           brojac+=2; 
    }
    else{// CRTAJ OKS
        if(pozicija1.aktiviran==true && pozicija1.upisano==false){
            OKS(x1,y1);
            pozicija1.upisano=true;
            Ojedan++;
            Ocetiri++;
            Osedam++;   
        }
        else if(pozicija2.aktiviran==true && pozicija2.upisano==false){
            OKS(x2,y2);
            pozicija2.upisano=true;
            Ojedan++;
            Opet++;   
        }
        else if(pozicija3.aktiviran==true && pozicija3.upisano==false){
            OKS(x3,y3);
            pozicija3.upisano=true;
            Ojedan++;
            Osest++;
            Oosam++;   
        }
        else if(pozicija4.aktiviran==true && pozicija4.upisano==false){
            OKS(x4,y4);
            pozicija4.upisano=true;
            Ocetiri++;
            Odva++;   
        }
        else if(pozicija5.aktiviran==true && pozicija5.upisano==false){
            OKS(x5,y5);
            pozicija5.upisano=true;
            Odva++;
            Opet++;
            Osedam++;
            Oosam++;   
        }
        else if(pozicija6.aktiviran==true && pozicija6.upisano==false){
            OKS(x6,y6);
            pozicija6.upisano=true;
            Odva++;
            Osest++;   
        }
        else if(pozicija7.aktiviran==true && pozicija7.upisano==false){
            OKS(x7,y7);
            pozicija7.upisano=true;
            Otri++;
            Ocetiri++;
            Oosam++;   
        }
        else if(pozicija8.aktiviran==true && pozicija8.upisano==false){
            OKS(x8,y8);
            pozicija8.upisano=true;
            Otri++;
            Opet++;   
        }
        else if(pozicija9.aktiviran==true && pozicija9.upisano==false){
            OKS(x9,y9);
            pozicija9.upisano=true;   
            Otri++;
            Osedam++;
            Osest++;
        }
        Validacija();
        brojac++;
    }
    if (P1vCPU)
        Kompjuter();
        
    if (brojac%2 == 0 && P1vP2)
        ; // PRINTSTRING rezultat prvi strelica lijevo
    else if (brojac%2 == 0 && P1vCPU)
        ; // PRINTSTRING rezultat drugi strelica lijevo
    else if (brojac%2 != 0 && P1vP2)
        ; // PRINTSTRING prvi desno
    else if (brojac%2 != 0 && P1vCPU)
        ; // PRINTSTRING drugi desno
}



// POLJE ZA IGRU
void drawBoard(){
        lcd.clear();

        lcd.setXYAddress(0,0);
        crtajMrezu();
        lcd.refresh();
        lcd.setXYAddress(0,0);
        lcd.printString("   IKS-OKS   ",0,0);
        if(P1vP2){
        lcd.setXYAddress(0,0);
            lcd.printString("  P1 0:0 P2  ",0,5);
        }
        if (P1vCPU){
        lcd.setXYAddress(0,0);
            lcd.printString("  P1 0:0 CPU  ",0,5);
        }
}

// MENI CLICK
void biranjeOpcije(){
    if (meni){
    if(press.read_ms()>330){
        if(point[1]==2){
            meni= false;
            info = false;
            izlaz = false;
            P1vCPU = false;
            P1vP2 = true;
            drawBoard(); 
        }
        else if(point[1]==3){
            meni= false;
            info = false;
            izlaz = false;
            P1vP2 = false;
            P1vCPU = true;
            drawBoard(); 
            
        }
        else if(point[1]==4){
            meni= false;
            info = false;
            P1vP2 = false;
            P1vCPU = false;
            izlaz = true;
            izadi();            
        } 
        else if(point[1]==5){
            meni= false;
            P1vP2 = false;
            izlaz = false;
            P1vCPU = false;
            info = true;
            detalji();
        }
    }
        press.reset();
        }
        else
        {
            Klik();    
        }
        
        
}

int main() {
    // POCETNA INICIJALIZACIJA INSTANCI 
    pozicija1.aktiviran=true; pozicija1.upisano=false;
    pozicija2.aktiviran=false; pozicija2.upisano=false;
    pozicija3.aktiviran=false; pozicija3.upisano=false;
    pozicija4.aktiviran=false; pozicija4.upisano=false;
    pozicija5.aktiviran=false; pozicija5.upisano=false;
    pozicija6.aktiviran=false; pozicija6.upisano=false;
    pozicija7.aktiviran=false; pozicija7.upisano=false;
    pozicija8.aktiviran=false; pozicija8.upisano=false;
    pozicija9.aktiviran=false; pozicija9.upisano=false;
    
    // AKTIVIRANJE DISPLAYA
    lcd.init();
    lcd.setXYAddress(0,0);
    pocetniMeni();
    meni=true;
    press.start();
     
    SW1.mode(PullUp);
    SW.rise(&biranjeOpcije);
    
    
    // WHERE ANYTHING CAN HAPPEN
    while(1) {
        // MENI (KRETANJE/POKRETANJE)
        if(meni){ 
            scroll();
            T1 = 1;
        }
       // T1 = 0; // nisam siguran treba li ovo, al nek stoji za sad
        
        // IGRICA, OBA MODA (KRETANJE/CRTANJE)
        if(P1vP2 || P1vCPU)
        {
            
            if(X<1.0/3.0) // VRĆI SE LIJEVO
            {
       //         joystick.start();
      //          if(joystick.read_ms()>200){
                    if(pozicija1.aktiviran==true)
                    {
                        pozicija1.aktiviran=false;
                        pozicija3.aktiviran=true;
                        Kursor(x3, y3);
                        clearKursor(x1,y1);
                    }
                    else if(pozicija2.aktiviran==true)
                    {
                        pozicija2.aktiviran=false;
                        pozicija1.aktiviran=true;
                        Kursor(x1, y1);
                                                clearKursor(x2,y2);
                    }
                    else if(pozicija3.aktiviran==true)
                    {
                        pozicija3.aktiviran=false;
                        pozicija2.aktiviran=true;
                        Kursor(x2, y2);
                                                clearKursor(x3,y3);
                    }
                    else if(pozicija4.aktiviran==true)
                    {
                        pozicija4.aktiviran=false;
                        pozicija6.aktiviran=true;
                        Kursor(x6, y6);
                                                clearKursor(x4,y4);
                    }
                    else if(pozicija5.aktiviran==true)
                    {
                        pozicija5.aktiviran=false;
                        pozicija4.aktiviran=true;
                        Kursor(x4, y4);
                                                clearKursor(x5,y5);
                    }
                    else if(pozicija6.aktiviran==true)
                    {
                        pozicija6.aktiviran=false;
                        pozicija5.aktiviran=true;
                        Kursor(x5, y5);                        clearKursor(x6,y6);
                    }
                    else if(pozicija7.aktiviran==true)
                    {
                        pozicija7.aktiviran=false;
                        pozicija9.aktiviran=true;
                        Kursor(x9, y9);                        clearKursor(x7,y7);
                    }
                    else if(pozicija8.aktiviran==true)
                    {
                        pozicija8.aktiviran=false;
                        pozicija7.aktiviran=true;
                        Kursor(x7, y7);                        clearKursor(x8,y8);
                    }
                    else if(pozicija9.aktiviran==true)
                    {
                        pozicija9.aktiviran=false;
                        pozicija8.aktiviran=true;
                        Kursor(x8, y8);                        clearKursor(x9,y9);
                    }   
                }
        ///        joystick.stop();
         //       joystick.reset();                 
         //   }
            else if(X>2.0/3.0) // VRĆI SE DESNO
            {
       //         joystick.start();
       //         if(joystick.read_ms()>200){
                if(pozicija1.aktiviran==true)
                {
                    pozicija1.aktiviran=false;
                    pozicija2.aktiviran=true;
                    Kursor(x2, y2);                        clearKursor(x1,y1);
                }
                else if(pozicija2.aktiviran==true)
                {
                    pozicija2.aktiviran=false;
                    pozicija3.aktiviran=true;
                    Kursor(x3, y3);                        clearKursor(x2,y2);
                }
                else if(pozicija3.aktiviran==true)
                {
                    pozicija3.aktiviran=false;
                    pozicija1.aktiviran=true;
                    Kursor(x1, y1);                        clearKursor(x3,y3);
                }
                else if(pozicija4.aktiviran==true)
                {
                    pozicija4.aktiviran=false;
                    pozicija5.aktiviran=true;
                    Kursor(x5, y5);                        clearKursor(x4,y4);
                }
                else if(pozicija5.aktiviran==true)
                {
                    pozicija5.aktiviran=false;
                    pozicija6.aktiviran=true;
                    Kursor(x6, y6);                        clearKursor(x5,y5);
                }
                else if(pozicija6.aktiviran==true)
                {
                    pozicija6.aktiviran=false;
                    pozicija4.aktiviran=true;
                    Kursor(x4, y4);                        clearKursor(x6,y6);
                }
                else if(pozicija7.aktiviran==true)
                {
                    pozicija7.aktiviran=false;
                    pozicija8.aktiviran=true;
                    Kursor(x8, y8);                        clearKursor(x7,y7);
                }
                else if(pozicija8.aktiviran==true)
                {
                    pozicija8.aktiviran=false;
                    pozicija9.aktiviran=true;
                    Kursor(x9, y9);                        clearKursor(x8,y8);
                }
                else if(pozicija9.aktiviran==true)
                {
                    pozicija9.aktiviran=false;
                    pozicija7.aktiviran=true;
                    Kursor(x7, y7);                        clearKursor(x9,y9);
                }}
       //                         joystick.stop();
       //         joystick.reset();                    
         //   }
            if(Y<1.0/3.0) // VRĆI SE DOLJE
            {
       //         joystick.start();
       //         if(joystick.read_ms()>200){
                if(pozicija1.aktiviran == true)
                {
                    pozicija7.aktiviran = true;
                    pozicija1.aktiviran = false;
                    Kursor(x7, y7);                        clearKursor(x1,y1);
                }
                else if(pozicija2.aktiviran == true)
                {
                    pozicija8.aktiviran = true;
                    pozicija2.aktiviran = false;
                    Kursor(x8, y8);                        clearKursor(x2,y2);
                }
                else if(pozicija3.aktiviran == true)
                {
                    pozicija9.aktiviran = true;
                    pozicija3.aktiviran = false;
                    Kursor(x9, y9);                        clearKursor(x3,y3);
                }
                else if(pozicija4.aktiviran == true)
                {
                    pozicija1.aktiviran = true;
                    pozicija4.aktiviran = false;
                    Kursor(x1, y1);                        clearKursor(x4,y4);
                }
                else if(pozicija5.aktiviran == true)
                {
                    pozicija2.aktiviran = true;
                    pozicija5.aktiviran = false;
                    Kursor(x2, y2);                        clearKursor(x5,y5);
                }
                else if(pozicija6.aktiviran == true)
                {
                    pozicija3.aktiviran = true;
                    pozicija6.aktiviran = false;
                    Kursor(x3, y3);                        clearKursor(x6,y6);
                }
                else if(pozicija7.aktiviran == true)
                {
                    pozicija4.aktiviran = true;
                    pozicija7.aktiviran = false;
                    Kursor(x4, y4);                        clearKursor(x7,y7);
                }
                else if(pozicija8.aktiviran == true)
                {
                    pozicija5.aktiviran = true;
                    pozicija8.aktiviran = false;
                    Kursor(x5, y5);                        clearKursor(x8,y8);
                }
                else if(pozicija9.aktiviran == true)
                {
                    pozicija6.aktiviran = true;
                    pozicija9.aktiviran = false;
                    Kursor(x6, y6);                                       clearKursor(x9,y9); 
                }}
       //                         joystick.stop();
      //                          joystick.reset();
      //      }
            
            else if(Y>2.0/3.0)// VRĆI SE GORE
            {
               // joystick.start();
              //  if(joystick.read_ms()>200){
                    if(pozicija1.aktiviran == true)
                    {
                        pozicija4.aktiviran = true;
                        pozicija1.aktiviran = false;
                        Kursor(x4, y4);                                 clearKursor(x1,y1);
                    }
                    else if(pozicija2.aktiviran == true)
                    {
                        pozicija5.aktiviran = true;
                        pozicija2.aktiviran = false;
                        Kursor(x5, y5);                             clearKursor(x2,y2);
                    }
                   else  if(pozicija3.aktiviran == true)
                    {
                        pozicija6.aktiviran = true;
                        pozicija3.aktiviran = false;                            clearKursor(x3,y3);
                        Kursor(x6, y6);
                    }
                    else if(pozicija4.aktiviran == true)
                    {
                        pozicija7.aktiviran = true;
                        pozicija4.aktiviran = false;
                        Kursor(x7, y7);                         clearKursor(x4,y4);
                    }
                    else if(pozicija5.aktiviran == true)
                    {
                        pozicija8.aktiviran = true;
                        pozicija5.aktiviran = false;
                        Kursor(x8, y8);                         clearKursor(x5,y5);
                    }
                    else if(pozicija6.aktiviran == true)
                    {
                        pozicija9.aktiviran = true;
                        pozicija6.aktiviran = false;
                        Kursor(x9, y9);                        clearKursor(x6,y6);
                    }
                    else if(pozicija7.aktiviran == true)
                    {
                        pozicija1.aktiviran = true;
                        pozicija7.aktiviran = false;
                        Kursor(x1, y1);                         clearKursor(x7,y7);
                    }
                    else if(pozicija8.aktiviran == true)
                    {
                        pozicija2.aktiviran = true;
                        pozicija8.aktiviran = false;
                        Kursor(x2, y2);                         clearKursor(x8,y8);
                    }
                    else if(pozicija9.aktiviran == true)
                    {
                        pozicija3.aktiviran = true;
                        pozicija9.aktiviran = false;
                        Kursor(x3, y3);                         clearKursor(x9,y9);
                    }
                }
        //                      joystick.stop();
          //                      joystick.reset();
           // }
            T1 = 1;
            wait(0.23);
        }
    } 
}