#ifndef QUADRAPOD_DEFS_H
#define QUADRAPOD_DEFS_H

/* This header file defines pin names and similar stuff. */
#include "mbed.h"

/* Constant definitions. */
#define RAD2DEG 57.2957795

#ifndef PI
#define PI 3.14159265359
#endif



/* Management and control lines */

#define BATTSENSE PTC1
#define PWR_GOOD PTD6
#define BUZZER PTE31

#define RADIO_UART_TX PTE22
#define RADIO_UART_RX PTE23

/* UI (LCD and button) Lines */

#define LED_BL_RED PTE20
#define LED_BL_GRN PTE21
#define LED_BL_BLU PTE29

#define LCD_RS PTD7
#define LCD_RW PTE2
#define LCD_EN PTE3
#define LCD_D4 PTB9
#define LCD_D5 PTE4
#define LCD_D6 PTE5
#define LCD_D7 PTE30



#define SEL_BUTTON PTA16
#define ENTER_BUTON PTA17

/* External IO connection lines */

#define AUX_IN PTC3

#define EXT_SDA PTC11
#define EXT_SCL PTC10

#define EXT_CS PTD0
#define EXT_SCK PTD1
#define EXT_MOSI PTD2
#define EXT_MISO PTD3

#define EXT_UART_TX PTE0
#define EXT_UART_RX PTE1



/* Servo Block Lines */


#define SA1 PTC0
#define SA2 PTC2
#define SA3 PTC4

#define SB1 PTC5
#define SB2 PTC6
#define SB3 PTC7

#define SC1 PTC8
#define SC2 PTC9
#define SC3 PTC12

#define SD1 PTC13
#define SD2 PTC16
#define SD3 PTC17

/* Leg sensor lines, in case I ever get that working */

#define SNA PTB0
#define SNB PTB1
#define SNC PTB2
#define SCD PTB3



//#define PI 3.14159265359






#endif