#ifndef POLYSERVO_H
#define POLYSERVO_H

#include "mbed.h"
//#include "FPointer.h"
#include <vector>
//#include "SpecifiedTimeout.h"


#define SERVO_DISABLED -1       // This is going to take raw servo microsecond entries. 
#define PPM_PERIOD 20000  // In microseconds
#define NUM_SERVOS 12

//void servo_set(int id);


class Polyservo {
public:
    
    std::vector<DigitalOut *> servos;
    //DigitalOut * servos; 
    
    //bool global_enable; 
    int positions[NUM_SERVOS];
    int numservos; 
    void disable();
    void enable(); 
    
    Polyservo(DigitalOut servo_pins[]);
    void set_position(int s, int pos);
    
    typedef void (Polyservo::*PolyservoMbr)(void);

    
    
    
    
    
private: 
    
    Ticker period_tick; 
    std::vector<Timeout *> servo_timers;
    //Timeout * servo_times; 
    
    //void servo_set(int id);
    
    void servos_reset(void);
    
    bool global_enable; 

    void servo0_set(void);
    void servo1_set(void);
    void servo2_set(void);
    void servo3_set(void);
    void servo4_set(void);
    void servo5_set(void);
    void servo6_set(void);
    void servo7_set(void);
    void servo8_set(void);
    void servo9_set(void);
    void servo10_set(void);
    void servo11_set(void);
    //void servo12_set(void);    
    
    
    
    //void (Polyservo::*)(void) myPtr;
    PolyservoMbr servo_sets[12];
    

        

        
        
    
    
    
    
    
    


};




#endif