#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int header =0; //tiempo de cabecera pulso abajo
const int head_H = 11004; //+20% medida con osciloscopio en microsegundos
const int head_L = 7336;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1630;//ponga su tiempo de la prueba
const int T_bajo=433;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int sec[num_bits];//cadena para almacenar la cadena codificada en binario

int boton1[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,0};
int boton2[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,0,1,0,0,0,1,0,1,1,0,1,1,0};
int boton3[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,1,1,0,1,1,0};

int flag1,flag2,flag3; //Banderas de boton presionado
int dato; // tiempo de cada dato que se lee

int main()
{
    led3=1;
    led2=1;
    led=1;
    while(1)
    {
ini1:
        header=0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;

seguir:
        //leo los datos de la trama y se meten a un arreglo
        wait_us(2000);
        for(i=0; i<(num_bits-1); ++i) // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
        {
            num[i] = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            wait_us(667);
        }
        //wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla
        pc.printf(",%d",header);
        for(i=0; i<num_bits; ++i)
        {
            pc.printf(",%d",num[i]);
        }
        //wait(0.1);  //espero e imprimo en binario
        pc.printf("\n\n");
        
        for(i=0; i<num_bits; ++i)
        {
            if(num[i] > ((T_alto+T_bajo)/2))
            {
                pc.printf("1");
                sec[i]=1; // guardo la secuancia en binario
            }
            else
            {
                sec[i]=0; //guardo la secuencia en binario
                pc.printf("0");
            }
        }

        flag1=1;
        flag2=1;
        flag3=1;
        
        for(i=0; i<32; ++i)
        {
            if(sec[i]!=boton1[i]) //en caso de que un bit no coincida se descarta el boton 1
            {
                flag1=0;
            }            
            if(sec[i]!=boton2[i]) //en caso de que un bit no coincida se descarta el boton 2
            {
                flag2=0;
            }            
            if(sec[i]!=boton3[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                flag3=0;
            }
        }
        if(flag1==1)
        {
            led3=1;
            led2=1;
            led=!led;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Presionaste 1"); //si coincidieron todos los bits del boton 1
        }
        else if(flag2==1)
        {
            led3=1;            
            led=1;
            led2=!led2;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Presionaste 2"); //si coincidieron todos los bits del boton 1
        }
        else if(flag3==1)
        {
            led2=1;
            led=1;
            led3=!led3;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Presionaste 3"); //si coincidieron todos los bits del boton 1
        }
        else
        {
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Presionaste otro boton"); //si coincidieron todos los bits del boton 1
        }
    }
}
