#include "mbed.h"
#include "TextLCD.h"


AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalIn b1(PTC12);
DigitalIn b2(PTC13);
DigitalIn b3(PTC16);
int c1=0x0E,sp=0,kp=0,ki=0,kd=0,k=1;
int bandera;
Timer t;
float tiempo;

int main()
{
    lcd.cls();
    lcd.writeCommand(c1);
    //Se localiza las variables del PID
    lcd.locate(9,0); //posición 2
    lcd.printf("Kp=%d",kp); 
    lcd.locate(0,1);//posición 3
    lcd.printf("Ki=%d",ki);
    lcd.locate(9,1);//posición 4
    lcd.printf("Kd=%d",kd);
    lcd.locate(0,0);//posición 1
    lcd.printf("Sp=%d",sp);
    
    while(1)
    {
        while(k==1) //posición 1
        {
            if(b1 & sp<=1000)
            {
                l1 = !l1;
                if(bandera==0)
                {
                    t.start(); //inicia el conteo del tiempo que se mantiene pulsado el botón.
                    bandera=1;
                }
                wait(0.50);
                if(b1 & sp<=1000) //Incremento hasta un límite de 1000
                {
                    tiempo=t.read(); //lectura del tiempo
                    //si tiempo es menor a 5 segundos, incremente de 1 en 1.
                    if(tiempo<5)
                    {
                        sp++;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }
                    //si tiempo está entre 5 y 10 segundos, incremente de 10 en 10.
                    if(tiempo>=5 & tiempo<10)
                    {
                        sp+=10;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }

                    //si tiempo es mayor a 10 segundos, incremente de 100 en 100.
                    if(tiempo>=10)
                    {
                        sp+=100;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;//detener el conteo del tiempo
                }
            }


            if(b2 & sp>=1) //bótón decremento
            {
                l2 = !l2;

                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }

                wait(0.50);

                if(b2 & sp>=1)
                {
                    tiempo=t.read();

                    //si tiempo es menor de 5 segundos, decremento de 1 en 1.
                    if(tiempo<5)
                    {
                        sp--;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }

                    //si tiempo está entre 5 y 10 segundos, decremento de 10 en 10.
                    if(tiempo>=5 & tiempo<10)
                    {
                        sp-=10;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }

                    //si tiempo es mayor a 10 segundos, decremente de 100 en 100.
                    if(tiempo>=10)
                    {
                        sp-=100;
                        lcd.locate(3,0);
                        lcd.printf("%d",sp);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }
            if (b3) //al oprimir el botón 3, cambia a la siguiente posición.
            {
                k+=1;
                wait(0.25);
                lcd.locate(12,0);lcd.printf("%d",kp);               
            }

        }

        while(k==2)//posición 2
        {
            if(b1 & kp<=1000)
            {
                l1 = !l1;
                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }
                wait(0.50);

                if(b1 & kp<=1000)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        kp++;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        kp+=10;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }

                    if(tiempo>=10)
                    {
                        kp+=100;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }
            if(b2 & kp>=1)
            {
                l2 = !l2;

                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }
                wait(0.50);

                if(b2 & kp>=1)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        kp--;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        kp-=10;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }

                    if(tiempo>=10)
                    {
                        kp-=100;
                        lcd.locate(12,0);
                        lcd.printf("%d",kp);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }
            if (b3)
            {
                k+=1;
                wait(0.25);
                lcd.locate(3,1); lcd.printf("%d",ki);
            }
        }


        while(k==3) //posición 3
        {
            if(b1 & ki<=1000)
            {
                l1 = !l1;

                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }
                wait(0.50);

                if(b1 & ki<=1000)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        ki++;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        ki+=10;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }

                    if(tiempo>=10)
                    {
                        ki+=100;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }
                }

                else
                {
                    t.start();
                    bandera=0;
                }
            }

            if(b2 & ki>=1)
            {
                l2 = !l2;
                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }
                wait(0.50);

                if(b2 & ki>=1)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        ki--;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        ki-=10;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }

                    if(tiempo>=10)
                    {
                        ki-=100;
                        lcd.locate(3,1);
                        lcd.printf("%d",ki);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }
            if (b3)
            {
                k+=1;
                wait(0.25);
                lcd.locate(12,1); lcd.printf("%d",kd);
            }
        }

        while(k==4) //posición 4
        {
            if(b1 & kd<=1000)
            {
                l1 = !l1;
                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }

                wait(0.50);

                if(b1 & kd<=1000)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        kd++;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        kd+=10;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }

                    if(tiempo>=10)
                    {
                        kd+=100;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }


            if(b2 & kd>=1)
            {
                l2 = !l2;

                if(bandera==0)
                {
                    t.start();
                    bandera=1;
                }
                wait(0.50);

                if(b2 & kd>=1)
                {
                    tiempo=t.read();

                    if(tiempo<5)
                    {
                        kd--;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }

                    if(tiempo>=5 & tiempo<10)
                    {
                        kd-=10;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }

                    if(tiempo>=10)
                    {
                        kd-=100;
                        lcd.locate(12,1);
                        lcd.printf("%d",kd);
                    }
                }
                else
                {
                    t.start();
                    bandera=0;
                }
            }

            if (b3)
            {
                k=1;
                wait(0.25);
                lcd.locate(3,0);
                lcd.printf("%d",sp);
            }

        }
        continue;
    }

}
      