#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
int main(void) {
    TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); 
    PwmOut rled(LED_RED); // Declaración de los led's PWM, para poder variar la intensidad del led
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
 
    while (true) {
    rled = 1.0 - abs(acc.getAccX()); // Asignar la coordenada de la tarjeta
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        lcd.locate(0,0);// Asignación de las posiciones de la pantalla lcd
        lcd.printf("      "); 
        lcd.locate(0,0);
        lcd.printf("X=%g",acc.getAccX()); 
        lcd.locate(8,0);
        lcd.printf("    ");  // para una coordenada más pequeña no aparezca en la pantalla
        lcd.locate(8,0);
        lcd.printf("Y=%g",acc.getAccY());
        lcd.locate(0,1);
        lcd.printf("    "); 
        lcd.locate(0,1);
        lcd.printf("Z=%g",acc.getAccZ());
        
        wait(0.3);
    }
}