#include "main.h"

/*

ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Ikenna Adrian Ozoemena
Username: el17aio
Student ID Number: 201157039
Date: 20/02/2019
*/

//_______________functions______________________________________________________
int main()
{
    init();
    printf("Init function completed...\n");

    while(1) {
        welcome();
        printf("welcome()\n");
        rosen.reset();
        printf("reset()\n");
        //printf("ycursor = %d",rosen.get_ycursor());

        if(rosen.get_ycursor() == 16) {
            //  printf("get_ycursor() == 16()\n");
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false && rosen.dead() == false) {
                // printf("play...\n");
                rosen.read_input(pad);
                // printf("read_input\n");
                rosen.update(pad);
                // printf("update\n");
                render();
                // printf("render()\n");
                wait(1.0f/fps);
                rosen.timer(fps);
            }
        }
        if(rosen.get_ycursor() == 24) {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
                rosen.read_input(pad);
                rosen.update(pad);
                ship_select();
                wait(1.0f/fps);
                // printf("menu...\n");
            }
        }
    }
}

void init()
{
    // need to initialise LCD and Gamepad
    lcd.init();
    pad.init();
    rosen.init(9,6,3,42,41);
    printf("Initializing...\n");

}
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    rosen.draw(lcd, pad);
    rosen.get_pos();
    lcd.refresh();
    // printf("Rendering...\n");
}
void ship_select()
{
    lcd.clear();
    rosen.ship_select(lcd);
    rosen.get_pos();
    lcd.refresh();
    printf("Ship Select...\n");
}

// simple splash screen displayed on start-up
void welcome()
{
    while( pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.clear();
        rosen.title(lcd);
        rosen.read_input(pad);
        lcd.refresh();
    }
    printf("Welcome Function completed...\n");
}