#include "Weapons.h"
DigitalIn A_button(PTB9);

Weapons::Weapons()
{

}

Weapons::~Weapons()
{

}

// Obtain the player position and width in the initialisation stage.
void Weapons::init(int ship_xpos, int ship_ypos, int ship_width)
{
    //printf("ship x, ship y = %d , %d \n", playerx, playery);
    _ship_xpos = ship_xpos + (ship_width/2);
    _ship_ypos = ship_ypos;

}

void Weapons::draw(N5110 &lcd,Gamepad &pad,SHIP shipUsed,Vector2D closest_enemy )
{
    if(shipUsed == kestrel) {
        _velocity.x = 0; //Projectile doesn't move sideways.
        _velocity.y = -7; //Projectile moves upwards on screen.

        //resets once projectile reaches top of screen
        if(_y <= -1) {
            reset= 0;
        }

        if(reset == 0) {
            _x = _ship_xpos;
            _y = _ship_ypos;
            reset = reset+1;
        }
        lcd.drawRect(_x,_y,1,4,FILL_BLACK);
        // printf("Ship x and y pos, reset = %d , %d ,%d \n", _ship_xpos, _ship_ypos, reset);
    }
    if(shipUsed == imperion) {
        if((A_button) == true) {
            // while((A_button) == true) {
            pad.tone(2000,0.1);
            lcd.drawRect(_ship_xpos - 1, 0,3,_ship_ypos + 6,FILL_BLACK);
            wait(0.1);
            //}
        }
    }
    if(shipUsed == orion) {
        float rangex = (abs(_ship_xpos - closest_enemy.x));
        float rangey = (abs(_ship_ypos - closest_enemy.y));
        int distance = floor((rangex+rangey)/2);
        if((A_button) == true && distance < 15) {
            lcd.drawLine(_ship_xpos + 2,_ship_ypos + 2,closest_enemy.x + 2,closest_enemy.y + 2,FILL_BLACK);
        }
    }
}

void Weapons::update()
{
    _x = _x + _velocity.x;
    _y = _y + _velocity.y;
}



Vector2D Weapons::get_pos(SHIP shipUsed)
{
    if(shipUsed == kestrel) {
        Vector2D pos = {_x,_y};
        return pos;
    }
}

void Weapons::set_pos(int xpos, int ypos)
{
    _x = xpos;
    _y = ypos;
}