#include "Ship.h"
Ship::Ship()
{

}

Ship::~Ship()
{

}
// data needed for first ship: kestrel
const int kestrelSprite[6][9] =   {
    { 0,0,0,0,1,0,0,0,0 },
    { 0,0,0,1,1,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,0 },
    { 0,0,1,1,0,1,1,0,0 },
    { 1,0,1,1,0,1,1,0,1 },
    { 0,1,1,1,1,1,1,1,0 },
};
const int imperionSprite[10][7] = {
    {0,1,0,0,0,1,0},
    {0,1,0,0,0,1,0},
    {1,1,0,0,0,1,1},
    {0,1,0,0,0,1,0},
    {0,1,0,0,0,1,0},
    {0,1,0,0,0,1,0},
    {0,1,1,0,1,1,0},
    {1,0,0,1,0,0,1},
    {0,0,1,0,1,0,0},
    {0,0,0,1,0,0,0},
};
const int orionSprite[10][7] = {
    {0,0,0,1,0,0,0},
    {0,0,1,0,1,0,0},
    {0,1,0,0,0,1,0},
    {1,0,0,1,0,0,1},
    {0,1,0,0,0,1,0},
    {0,0,1,0,1,0,0},
    {1,0,0,1,0,0,1},
    {1,0,1,0,1,0,1},
    {1,1,0,0,0,1,1},
    {1,0,0,0,0,0,1},

};
/*
int kestrel_width = 9;
int kestrel_height = 6;
int kestrel_speed = 5;
*/

// Set kestrel ship to be default
void Ship::init(int ship_width,int ship_height,int ship_speed,int ship_xpos,int ship_ypos)
{
    _ship_width = ship_width;
    _ship_height = ship_height;
    _ship_speed = ship_speed;
    _ship_xpos = ship_xpos;
    _ship_xpos = ship_ypos;
//    _ship_shape[_ship_height][_ship_width] = ship_shape;
}
// Draw the ship ***Note: figure out how to change ship type e.g from kestrel to devotion
void Ship::draw_ship(N5110 &lcd, SHIP shipUsed)
{
        switch (shipUsed) {
        case kestrel:
            lcd.drawSprite(_ship_xpos,_ship_ypos,6,9,(int *)kestrelSprite);
            break;
        case imperion:
            lcd.drawSprite(_ship_xpos,_ship_ypos,10,7,(int *)imperionSprite);
            break;
        case orion:
            lcd.drawSprite(_ship_xpos,_ship_ypos,10,7,(int *)orionSprite);
            break;
       }
}

void Ship::update_ship(float x_joystick,float y_joystick)
{
    int border = 1;
    // Only change position if joystick is reasonably moved
    if(-0.25 > x_joystick || x_joystick > 0.25 || -0.25 > y_joystick || y_joystick > 0.25) {
        // Update positions using joystick and the intended ships speed
        _ship_xpos = _ship_xpos + (x_joystick*_ship_speed);
        _ship_ypos = _ship_ypos - (y_joystick*_ship_speed);

        // Dont let sprite move out of screen
        if(_ship_xpos < border) {
            _ship_xpos = border;
        }
        if(_ship_xpos > (84 - (_ship_width)- 7)) {
            _ship_xpos = 84 - _ship_width - 7;
        }
        if(_ship_ypos < border) {
            _ship_ypos = border;
        }
        if(_ship_ypos > (48 - (_ship_height) - border)) {
            _ship_ypos = 48 - _ship_height - border;
        }
    }
    // printf("y_joysticzk = %f\n",y_joystick);
    // printf("x_joystick = %f\n",x_joystick);
}
// returns the current ship position on screen as a vector
Vector2D Ship::get_pos()
{
    Vector2D ship_pos = {_ship_xpos,_ship_ypos};
    return ship_pos;
}

void Ship::set_parameters(int ship_width, int ship_height, int ship_speed)
{
    _ship_width = ship_width;
    _ship_height = ship_height;
    _ship_speed = ship_speed;
}

/****Note: if you make all the ships the same size, you could then creare a enum for them ship.[ enum class Ship {kestrel, devotion}; ]
then, you can declare a new variable belonging to the enum Ship, ship. then to set a ships sprite simply use the variable to test if
the ship is correct and create an if function to draw the appropriate ship
*/