#ifndef HEALTH_H
#define HEALTH_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ship.h"

/** Health Class
@brief Library for handling ship and enemy health
@author Ozoemena Adrian Ikenna
@date 8th May 2019
*/
class Health
{

public:
    /** constructor */
    Health();
    /** destructor */
    ~Health();
    /** A mutator method that initializes the slass by setting the ship being used
    *< as different ships have different amounts of health and shiekds 
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used
    */
    void init(SHIP shipUsed);
    /** draws the health bar based on ship selected
    *@param &lcd pointer to the N5110 library used for the lcd display
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used 
    */
    void draw_health(N5110 &lcd,SHIP shipUsed);
    /** draws the shield bar based on ship selected
    *@param &lcd pointer to the N5110 library used for the lcd display
    */
    void draw_shields(N5110 &lcd);
    /** A mutator method used to change the shield and health values when damahe is taken
    *@param bars a unit of health and damage. (e.g 3 bars of health)
    *@param &pad pointer to the gamepad library used to read inputs and send outputs to the gamepad
    */
    void update(int bars,Gamepad &pad);
    /** An accessor method used to get the current health and shield level of a ship
    *@returns 2D vector hp with hp.x being ship health and hp.y ship shields
    */
    Vector2D get_hp();
    /** A Mutator method used to update the enemy seekers health
    *@param seno: the seeker number used to reference the seeker of interest
    *Ranges from 0-3 as there can be a maximum of three seekers
    *@param dmg the amount of damage done to the enemy by player
    */
    void seekerh_update(int seno,int dmg);
    /** A Mutator method used to update the enemy shooters health
    *@param shno: the shooter number used to reference the shooter of interest
    *Ranges from 0-3 as there can be a maximum of three shooters
    *@param dmg the amount of damage done to the enemy by player
    */
    void shooterh_update(int shno, int dmg);
    /** An Accessor method used to get the seekers health 
    *@param seno the seeker number used to reference the seeker of interest
    *Ranges from 0-3 as there can be a maximum of three seekers
    */
    int get_seekerh(int seno);
    /** An Accessor method used to get the shooters health 
    *@param shno the shooter number used to reference the shooter of interest
    *Ranges from 0-3 as there can be a maximum of three shooters
    */
    int get_shooterh(int shno);
    /** A Mutator method used to reset the seekers health upon death or game restart
    *@param seno the seeker number used to reference the seeker of interest
    *Ranges from 0-3 as there can be a maximum of three seekers
    */
    void reset_seekerh(int seno);
    /** A Mutator method used to reset the shooters health upon death or game restart
    *@param shno the shooter number used to reference the shooter of interest
    *Ranges from 0-3 as there can be a maximum of three shooters
    */
    void reset_shooterh(int shno);    
    
    
private:
//_______________Private-Variables__________________________________________
    int _ship_health;
    int _ship_shields;
    int _shipno;
    int _health_unit;
    int _seekerH[3];
    int _shooterH[3];

};

#endif