#include "Enemy.h"

Enemy::Enemy()
{

}

Enemy::~Enemy()
{

}
const int seeker[7][9] = {
    {1,1,0,0,0,0,0,1,1},
    {1,0,1,0,0,0,1,0,1},
    {1,0,0,1,1,1,0,0,1},
    {0,1,0,0,0,0,0,1,0},
    {0,0,1,0,0,0,1,0,0},
    {0,0,1,1,0,1,1,0,0},
    {0,0,0,0,1,0,0,0,0},
};
const int shooter[10][11] = {
    {0,0,1,0,0,0,0,0,1,0,0},
    {0,1,0,1,0,0,0,1,0,1,0},
    {1,0,0,1,0,1,0,1,0,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {0,1,0,0,0,0,0,0,0,1,0},
    {0,1,0,0,1,1,1,0,0,1,0},
    {0,0,1,0,0,1,0,0,1,0,0},
    {0,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,0},
};
void Enemy::init(int noShooters, int noSeekers)
{
    // initialize seeker
     _seekerPos[0].x = rand_no(68);
     _seekerPos[0].y = 0;
     _seekerPos[1].x = rand_no(68);
     _seekerPos[1].y = 0;
     _seekerPos[2].x = rand_no(68);
     _seekerPos[2].y = 0;
    _noSeekers = noSeekers;
    _noShooters = noShooters;
    // initialize shooter
    _shooterSpeed[0].x = 1;
    _shooterSpeed[1].x = 1;
    _shooterSpeed[2].x = 1;
    _shooterSpeed[0].y = 1;
    _shooterSpeed[1].y = 1;
    _shooterSpeed[2].y = 1;
    // for now just starting them spaced apart add randomizer later

    _shooterPos[0].x = rand_no(68);
    _shooterPos[0].y = 1;
    _shooterPos[1].x = rand_no(68);
    _shooterPos[1].y = 1;
    _shooterPos[2].x = rand_no(68);
    _shooterPos[2].y = 1;

}
void Enemy::set_noshooters(int noShooters)
{
    _noShooters = noShooters;
}
void Enemy::set_noseekers(int noSeekers)
{
    _noSeekers = noSeekers;
}
// Draw the ship ***Note: figure out how to change ship type e.g from basic to devotion
void Enemy::draw_seeker(N5110 &lcd)    
{   
    switch (_noSeekers) {
        case 1:
            lcd.drawSprite( _seekerPos[0].x, _seekerPos[0].y,7,9,(int *)seeker);
            break;
        case 2:
            lcd.drawSprite( _seekerPos[0].x, _seekerPos[0].y,7,9,(int *)seeker);
            lcd.drawSprite( _seekerPos[1].x, _seekerPos[1].y,7,9,(int *)seeker);
            break;
        case 3:
            lcd.drawSprite( _seekerPos[0].x, _seekerPos[0].y,7,9,(int *)seeker);
            lcd.drawSprite( _seekerPos[1].x, _seekerPos[1].y,7,9,(int *)seeker);
            lcd.drawSprite( _seekerPos[2].x, _seekerPos[2].y,7,9,(int *)seeker);
            break;
    }
}
void Enemy::draw_shooter(N5110 &lcd)
{
    switch (_noShooters) {
        case 1:
            lcd.drawSprite(_shooterPos[0].x,_shooterPos[0].y,10,11,(int *)shooter);
            break;
        case 2:
            lcd.drawSprite(_shooterPos[0].x,_shooterPos[0].y,10,11,(int *)shooter);
            lcd.drawSprite(_shooterPos[1].x,_shooterPos[1].y,10,11,(int *)shooter);
            break;
        case 3:
            lcd.drawSprite(_shooterPos[0].x,_shooterPos[0].y,10,11,(int *)shooter);
            lcd.drawSprite(_shooterPos[1].x,_shooterPos[1].y,10,11,(int *)shooter);
            lcd.drawSprite(_shooterPos[2].x,_shooterPos[2].y,10,11,(int *)shooter);
            break;
    }
}
void Enemy::update_seeker(int ship_xpos, int ship_ypos)
{
    switch (_noSeekers) {
        case 1:
            update_seeker1(ship_xpos,ship_ypos);
            break;
        case 2:
            update_seeker1(ship_xpos,ship_ypos);
            update_seeker2(ship_xpos,ship_ypos);
            break;
        case 3:
            update_seeker1(ship_xpos,ship_ypos);
            update_seeker2(ship_xpos,ship_ypos);
            update_seeker3(ship_xpos,ship_ypos);
            break;
    }
}
void Enemy::update_seeker1(int ship_xpos, int ship_ypos)
{
    int rangex =  _seekerPos[0].x - ship_xpos;
    int rangey =  _seekerPos[0].y - ship_ypos;

    // make seeker move towards ship
    if(rangey < 0) {
        if(rangex < 0) {
             _seekerPos[0].x =  _seekerPos[0].x + 2;
        } else if(rangex == 0) {
             _seekerPos[0].x =  _seekerPos[0].x;
        } else {
             _seekerPos[0].x =  _seekerPos[0].x - 2;
        }
    }

    // reset seeker to top
    if( _seekerPos[0].y > 54) {
        reset_seeker(1);
    }
     _seekerPos[0].y =  _seekerPos[0].y + 2;
    // printf("seeker_xpos , seeker_ypos = %d, %d\n", _seeker_xpos, _seeker_ypos);
}
void Enemy::update_seeker2(int ship_xpos, int ship_ypos)
{
    int rangex =  _seekerPos[1].x - ship_xpos;
    int rangey =  _seekerPos[1].y - ship_ypos;

    // make seeker move towards ship
    if(rangey < 0) {
        if(rangex < 0) {
             _seekerPos[1].x =  _seekerPos[1].x + 2;
        } else if(rangex == 0) {
             _seekerPos[1].x =  _seekerPos[1].x;
        } else {
             _seekerPos[1].x =  _seekerPos[1].x - 2;
        }
    }

    // reset seeker to top
    if( _seekerPos[1].y > 54) {
        reset_seeker(2);
    }
     _seekerPos[1].y =  _seekerPos[1].y + 2;
    // printf("seeker_xpos , seeker_ypos = %d, %d\n", _seeker_xpos, _seeker_ypos);
}
void Enemy::update_seeker3(int ship_xpos, int ship_ypos)
{
    int rangex =  _seekerPos[2].x - ship_xpos;
    int rangey =  _seekerPos[2].y - ship_ypos;

    // make seeker move towards ship
    if(rangey < 0) {
        if(rangex < 0) {
             _seekerPos[2].x =  _seekerPos[2].x + 2;
        } else if(rangex == 0) {
             _seekerPos[2].x =  _seekerPos[2].x;
        } else {
             _seekerPos[2].x =  _seekerPos[2].x - 2;
        }
    }

    // reset seeker to top
    if( _seekerPos[2].y > 54) {
        reset_seeker(3);
    }
     _seekerPos[2].y =  _seekerPos[2].y + 2;
    // printf("seeker_xpos , seeker_ypos = %d, %d\n", _seeker_xpos, _seeker_ypos);
}
void Enemy::update_shooter(int ship_xpos, int ship_ypos)
{
    Vector2D shooter1pos = shooter_motion(_shooterPos[0].x,_shooterPos[0].y,ship_xpos,ship_ypos,_shooterWPos[0].x,_shooterWPos[0].y,_shooterSpeed[0].x,_shooterSpeed[0].y);
    Vector2D shooter2pos = shooter_motion(_shooterPos[1].x,_shooterPos[1].y,ship_xpos,ship_ypos,_shooterWPos[1].x,_shooterWPos[1].y,_shooterSpeed[1].x,_shooterSpeed[1].y);
    Vector2D shooter3pos = shooter_motion(_shooterPos[2].x,_shooterPos[2].y,ship_xpos,ship_ypos,_shooterWPos[2].x,_shooterWPos[2].y,_shooterSpeed[2].x,_shooterSpeed[2].y);
    
    _shooterPos[0].x = shooter1pos.x;
    _shooterPos[0].y = shooter1pos.y;
    _shooterPos[1].x = shooter2pos.x;
    _shooterPos[1].y = shooter2pos.y;
    _shooterPos[2].x = shooter3pos.x;
    _shooterPos[2].y = shooter3pos.y;
    //printf("_shooterPos[0].x = %d,_shooterPos[0].y = %d,projy = %d\n",_shooterPos[0].x ,_shooterPos[0].y,_shooterWPos[0]);
}
Vector2D Enemy::shooter_motion(int shooter_xpos,int shooter_ypos,int ship_xpos, int ship_ypos, int projx, int projy,int vx, int vy)
{
    int high_bar =10;
    int low_bar = 25;
    int rangex = shooter_xpos - ship_xpos;
    int rangey = shooter_ypos - ship_ypos;
    if(high_bar <= projy &&  projy <= low_bar){
        if(rangex > 0){
        // avoid ship
            shooter_xpos = shooter_xpos + vx;
        }
        if(rangex < 0){
            shooter_xpos = shooter_xpos - vx;
        } 
    }
    else{
        // track ship
        if(rangex > 0){
            shooter_xpos = shooter_xpos - vx;
        }
        if(rangex < 0){
            shooter_xpos = shooter_xpos + vx;
        }
    }
    if(shooter_xpos < 1) {
        shooter_xpos = 1;
    }
    if(shooter_xpos > 84 - 8 - 11) {
        shooter_xpos = 84 - 8 - 11;
    }
    //printf("_shooterPos[0].x = %d,_shooterPos[0].y = %d,projy = %d\n",_shooterPos[0].x ,_shooterPos[0].y,_shooterWPos[0]);
    // shooter_ypos = shooter_ypos + 1;
    return{shooter_xpos,shooter_ypos};
    
}

void Enemy::draw_shw1(N5110 &lcd,Gamepad &pad)
{
    _shooterWSpeed[0].x = 0; //Projectile doesn't move sideways.
    _shooterWSpeed[0].y = 2; //Projectile moves upwards on screen.

//resets once projectile reaches bottom of screen
    if(_shooterWPos[0].y >= 48) {
        _reset[0] = 0;
    }

    if(_reset[0] == 0) {
        _shooterWPos[0].x = _shooterPos[0].x + 5;
        _shooterWPos[0].y = _shooterPos[0].y + 11;
        _reset[0] = _reset[0] + 1;
    }
    lcd.drawRect(_shooterWPos[0].x,_shooterWPos[0].y,1,1,FILL_BLACK);
// printf("Ship x and y pos, reset = %d , %d ,%d \n", _ship_xpos, _ship_ypos, reset);
}
void Enemy::draw_shw2(N5110 &lcd,Gamepad &pad)
{
    _shooterWSpeed[1].x = 0; //Projectile doesn't move sideways.
    _shooterWSpeed[1].y = 5; //Projectile moves upwards on screen.

    //resets once projectile reaches bottom of screen
    if(_shooterWPos[1].y >= 48) {
        _reset[1]= 0;
    }

    if(_reset[1] == 0) {
        _shooterWPos[1].x = _shooterPos[1].x + 5;
        _shooterWPos[1].y = _shooterPos[1].y + 11;
        _reset[1] = _reset[1] + 1;
    }
    lcd.drawRect(_shooterWPos[1].x,_shooterWPos[1].y,1,1,FILL_BLACK);
    // printf("Ship x and y pos, reset = %d , %d ,%d \n", _ship_xpos, _ship_ypos, reset);
}
void Enemy::draw_shw3(N5110 &lcd,Gamepad &pad)
{
    _shooterWSpeed[2].x = 0; //Projectile doesn't move sideways.
    _shooterWSpeed[2].y = 3; //Projectile moves upwards on screen.

    //resets once projectile reaches bottom of screen
    if(_shooterWPos[2].y >= 48) {
        _reset[2] = 0;
    }

    if(_reset[2] == 0) {
        _shooterWPos[2].x = _shooterPos[2].x + 5;
        _shooterWPos[2].y = _shooterPos[2].y + 11;
        _reset[2] = _reset[2] + 1;
    }
    lcd.drawRect(_shooterWPos[2].x,_shooterWPos[2].y,1,1,FILL_BLACK);
}
void Enemy::draw_shw(N5110 &lcd,Gamepad &pad)
{
    switch (_noShooters) {
        case 1:
            draw_shw1(lcd,pad);
            break;
        case 2:
            draw_shw1(lcd,pad);
            draw_shw2(lcd,pad);
            break;
        case 3:
            draw_shw1(lcd,pad);
            draw_shw2(lcd,pad);
            draw_shw3(lcd,pad);
            break;
    }
}
void Enemy::update_shw()
{
    _shooterWPos[0].x =  _shooterWPos[0].x + _shooterWSpeed[0].x;
    _shooterWPos[0].y =  _shooterWPos[0].y + _shooterWSpeed[0].y;
    _shooterWPos[1].x =  _shooterWPos[1].x + _shooterWSpeed[1].x;
    _shooterWPos[1].y =  _shooterWPos[1].y + _shooterWSpeed[1].y;
    _shooterWPos[2].x =  _shooterWPos[2].x + _shooterWSpeed[2].x;
    _shooterWPos[2].y =  _shooterWPos[2].y + _shooterWSpeed[2].y;
}

Vector2D Enemy::get_shwpos(int shno)
{
    if(shno == 1) {
        Vector2D pos = {_shooterWPos[0].x,_shooterWPos[0].y};
        return pos;
    }
    if(shno == 2) {
        Vector2D pos = {_shooterWPos[1].x,_shooterWPos[1].y};
        return pos;
    }
    if(shno == 3) {
        Vector2D pos = {_shooterWPos[2].x,_shooterWPos[2].y};
        return pos;
    }
}

void Enemy::reset_seeker(int seno)
{
    switch (seno) {
        case 1:
            _seekerPos[0].x = rand_no(68);
            _seekerPos[0].y = 0;
            break;
        case 2:
            _seekerPos[1].x = rand_no(68);
            _seekerPos[1].y = 0;
            break;
        case 3:
            _seekerPos[2].x = rand_no(68);
            _seekerPos[2].y = 0;
            break;
    }

}
void Enemy::reset_shooter(int shno)
{
    switch (shno) {
        case 1:
            _shooterPos[0].x = rand_no(68);
            _shooterPos[0].y = 5;
            break;
        case 2:
            _shooterPos[1].x = rand_no(68);
            _shooterPos[1].y = 5;
            break;
        case 3:
            _shooterPos[2].x = rand_no(68);
            _shooterPos[2].y = 5;
            break;
    }
}
Vector2D Enemy::get_seekerpos(int seno)
{
    if(seno == 1) {
        Vector2D seeker_pos = { _seekerPos[0].x, _seekerPos[0].y};
        return seeker_pos;
    }
    if(seno == 2) {
        Vector2D seeker_pos = { _seekerPos[1].x, _seekerPos[1].y};
        return seeker_pos;
    }
    if(seno == 3) {
        Vector2D seeker_pos = { _seekerPos[2].x, _seekerPos[2].y};
        return seeker_pos;
    }
}
Vector2D Enemy::get_shooterpos(int shno)
{
    if(shno == 1) {
        Vector2D shooter_pos = {_shooterPos[0].x,_shooterPos[0].y};
        return shooter_pos;
    }
    if(shno == 2) {
        Vector2D shooter_pos = {_shooterPos[1].x,_shooterPos[1].y};
        return shooter_pos;
    }
    if(shno == 3) {
        Vector2D shooter_pos = {_shooterPos[2].x,_shooterPos[2].y};
        return shooter_pos;
    }
}
int Enemy::rand_no(int scale)
{
    srand(time(NULL));
    int rand_no = (rand() %scale) + 1;
    // printf("random no = %d\n",rand_no);
    return rand_no;
}
void Enemy::sh_scaling(float time_elapsed)
{
    // add if functions for shno
    // correct movement
    int vmax = 3;
    int time = floor(time_elapsed);
    if(time%10 == 0) {
        if(_shooterSpeed[0].x > -vmax && _shooterSpeed[0].x < vmax) {
            _shooterSpeed[0].x = _shooterSpeed[0].x * 1.1;
        }
        if(_shooterSpeed[1].x > - vmax && _shooterSpeed[1].x < vmax) {
            _shooterSpeed[1].x = _shooterSpeed[1].x * 1.1;
        }
        if(_shooterSpeed[2].x > -vmax && _shooterSpeed[2].x < vmax) {
            _shooterSpeed[2].x = _shooterSpeed[2].x * 1.1;
        }
        if(_shooterSpeed[0].y > -vmax && _shooterSpeed[0].y < vmax) {
            _shooterSpeed[0].y = _shooterSpeed[0].y * 1.1;
        }
        if(_shooterSpeed[1].y > -vmax && _shooterSpeed[1].y < vmax) {
            _shooterSpeed[1].y = _shooterSpeed[1].y * 1.1;
        }
        if(_shooterSpeed[2].y > -vmax && _shooterSpeed[2].y < vmax) {
            _shooterSpeed[2].y = _shooterSpeed[2].y * 1.1;
        }
    }
    // printf("time = %d, _shooterSpeed[0].x = %f\n",time,_shooterSpeed[0].x);
}
int Enemy::distance(int x1, int y1, int x2, int y2)
{
    int rangex = abs(x1 - x2);
    int rangey = abs(y1 - y2);
    int dis = (rangex+rangey)/2;
    return dis;
}

Vector2D Enemy::find_closest(int ship_xpos,int ship_ypos, int noSeekers, int noShooters)
{
    // get the distance for all enemies
    int sh1 = distance(ship_xpos,ship_ypos,_shooterPos[0].x,_shooterPos[0].y);
    int sh2 = distance(ship_xpos,ship_ypos,_shooterPos[1].x,_shooterPos[1].y);
    int sh3 = distance(ship_xpos,ship_ypos,_shooterPos[2].x,_shooterPos[2].y);
    int se1 = distance(ship_xpos,ship_ypos, _seekerPos[0].x, _seekerPos[0].y);
    int se2 = distance(ship_xpos,ship_ypos, _seekerPos[1].x, _seekerPos[1].y);
    int se3 = distance(ship_xpos,ship_ypos, _seekerPos[2].x, _seekerPos[2].y);
   
    int close[6] = {sh1,sh2,sh3,se1,se2,se3};
    // find index of the smallest element
    int index;
    int smallest = close[0];
    for(int i=0; i<6; i=i+1) {
      if(smallest>close[i]) {
         smallest=close[i];
         index = i;
      }
    }
    // return the position of the closest enemy
    if(index == 0 && noShooters >= 1){
       return {_shooterPos[0].x,_shooterPos[0].y};
    }
    if(index == 1 && noShooters >= 2){
       return {_shooterPos[1].x,_shooterPos[1].y}; 
    }
    if(index == 2 && noShooters >= 3){
       return {_shooterPos[2].x,_shooterPos[2].y}; 
    }
    if(index == 3 && noSeekers >= 1 ){
       return { _seekerPos[0].x, _seekerPos[0].y}; 
    }
    if(index == 4 && noSeekers >= 2){
       return { _seekerPos[1].x, _seekerPos[1].y}; 
    }
    if(index == 5 && noSeekers >= 3){
       return { _seekerPos[2].x, _seekerPos[2].y};  
    }
    
} 