/* mikrupravljači
 * projektni zadatak
 */

#include "mbed.h"
#include "TextLCD.h"
#include "pcinput.h"
#include "blinkalo.h"

PwmOut PWM1(PC_8);
Timer debounce;
InterruptIn gumb(PC_10);
DigitalOut ledica2(PC_9);
Serial bt(PA_9, PA_10); // TX, RX za bluetooth
void toggle(void);
void ventila(void);
void ledic(void);
TextLCD lcd(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0); //rs, e, d0, d1, d2, d3
Ticker flipper1;
DigitalOut ledica1(PB_8);
DigitalOut zarulja1(PC_2);
DigitalOut zarulja2(PC_3);
void zadatak1(void);
int prva(int k, int x); // inicijalizacija funkcije prva
int druga(int l, int x); // inicijalizacija funkcije druga

blinkalo cctv(PB_8);

void flip1()
{
    ledica1 = !ledica1;
}

int main()
{
    // inicijalizacija
    debounce.start();
    gumb.rise(&toggle);
    bt.baud(9600);
    inicijalizacija(); // ispis prvog reda na LCD
    float f;
    int i=1;
    int k=1;
    int l=1;
    

    gumb.mode(PullUp);
    PWM1.period(0.01);
    PWM1=0.25;
    f=0.5;
    lcd.locate(0,0);
    lcd.printf("Vrijednost pwm:");
    flipper1.attach(&flip1, 0.2);
    cctv.blink(2); 
    while (1) {
        char c;

        if (pc.readable()){
            c = KeyInput();  //vuče iz pcinput.cpp
            pc.printf("Vrijednost PWM-a: %f\n\r",1-f);
            i=c;
        }
        f=((i-48)/10.0);
        PWM1=f;
        
        
        lcd.locate(0,1);
        lcd.printf("%.2f ", f);
        if (bt.readable()) {
            char x = bt.getc();
            pc.printf("Bluetooth citljiv %i\n\r", bt.readable());
            k=prva(k,x);
            l=druga(l,x);
        }
       
    }
}

void toggle()  //za deboune i mijenjanje stanja bitnog trošila
{
if (debounce.read_ms()>= 150)
    ledica2=!ledica2;
    debounce.reset();
}

int prva(int k, int x)   // funkcija 'prva' za bt
{
    if ( x == 'a') {
        k +=1;
    }
    pc.printf("Prva zarulja %i\n\r",k);
    if (k % 2 == 0 && k != 0) {

        zarulja1 = 1;
        bt.printf("Upaljena zarulja\n");
        bt.printf("led1 ON\n");

    }
    if (k % 2 == 1 && k != 1) {
        zarulja1 = 0;
        bt.printf("Ugasena zarulja\n");
        bt.printf("led1 OFF\n");
        k=1;
    }
return k;
}

int druga(int l, int x)   // funkcija 'druga'
{
    if ( x == 'b') {
        l +=1;
    }
    pc.printf("Druga zarulja %i\n\r",l);
    if (l % 2 == 0 && l != 0) {

        zarulja2 = 1;
        bt.printf("Upaljena zarulja 2\n");
        bt.printf("led2 ON\n");
        pc.printf("led2 ON\n");

    }
    if (l % 2 == 1 && l !=1 ) {
        zarulja2 = 0;
        bt.printf("Ugasena zarulja 2\n");
        bt.printf("led2 OFF\n");
        l=1;
    }
return l;
}