#ifndef SWTP_CODEC
#define SWTP_CODEC

#include "types.h"

#define SWTP_VERSION (0)

typedef struct  {
    uint16 mimeType;
    uint32 payloadLengthBytes;
    uint16 startPayloadSequenceNumber;
} MessageHeader;

typedef struct {
    bool isMessageHeader;
    bool isControlPacket;
    uint8  flags;
    uint8  version;
    union {
        MessageHeader messageHeader;
    };
} PacketData;

extern "C" {
    void encodeHeaderPacket(uint8* packetToFill, int packetSize, PacketData* headerData);

    void decodePacket(uint8* packet, int packetSize, PacketData* headerDataToFill);

}

#endif /* SWTP_CODEC */