#pragma once

#include "mbed.h"
#include "rtos.h"
#include "MCP23017.h"
#include "WattBob_TextLCD.h"
#include <string>
#include <sstream>

//Compile Flags
#define DEBUG_MODE 0

//Inputs-------------------------
#define PORT_TURN_SIGNAL_SWITCH_RIGHT p17
#define PORT_TURN_SIGNAL_SWITCH_LEFT p18
#define PORT_ACCEL p19
#define PORT_BRAKE p20
#define PORT_IGNITION p21

//Outputs ----------------
#define PORT_REDBOX_LED1 p22
#define PORT_REDBOX_LED2 p30

#define PORT_SIDE_LIGHTS LED1
#define IGNITION_LED LED4
#define PORT_TURN_SIGNAL_LED_LEFT LED2
#define PORT_TURN_SIGNAL_LED_RIGHT LED2

//#define PORT_SIDE_LIGHTS LED1
//#define IGNITION_LED LED4
//#define PORT_TURN_SIGNAL_LED_LEFT LED2
//#define PORT_TURN_SIGNAL_LED_RIGHT LED3

namespace runTimeParams{
    extern Mutex liveAccess;
    extern float brakeForce;
    extern float accelForce;
    extern float avgSpeed;
    extern float odometer;
    extern float speed[3];
    #if DEBUG_MODE
    extern Mutex debugAccess;
    extern string debugLogBuffer1;
    extern string debugLogBuffer2 ;
    extern string * debugLog ;
    #endif
}



    
namespace task_group_1{
    //Display, 
    extern Thread thread;
    void runTask();
}
namespace task_group_2{
    //Read Accel/Brake, carSimulator
    extern Thread thread;
    void runTask(); 
}

namespace mailData{
    typedef struct{
        float   speed;
        float   accel;
        float   brake;
    } mail_t;
    extern Mail<mail_t, 100> mailBox;
}

namespace enqueueMail{
    //Send speed, accelerometer and brake values to a 100 element
        //MAIL queue
    extern Thread thread;
    void runTask();
}
namespace dequeueMail{
    //Send speed, accelerometer and brake values to a 100 element
        //MAIL queue
    extern Thread thread;
    extern const float freq;
    void runTask();
}


template <typename T>
static inline std::string to_string(T value)
{
    std::ostringstream os ;
    os << value ;
    return os.str() ;
}