/*
RTOS car interface model. See readme.md
Author: Gershom Agim | H00175564
2018
*/
#include "core.h"

Thread thread;


namespace runTimeParams{
    //Global variables contended by (almost) all tasks
    Mutex liveAccess;
    float brakeForce = 0.0f;
    float accelForce = 0.0f;
    float speed[3] = {0.0f};
    float avgSpeed = 0.0f;
    float odometer = 0.0f;
    
    #if DEBUG_MODE
    //Debug logs: double buffer so printing to pc doesn't hold up
    //tasks attempting to log
    Mutex debugAccess;
    string debugLogBuffer1 = "task,execution_time_ms,lastSleep,drift\n\r";
    string debugLogBuffer2 = "";
    string * debugLog = &debugLogBuffer1;
    #endif
}
 
int main() {
    //Launch threads
    task_group_1::thread.start(task_group_1::runTask);
    task_group_2::thread.start(task_group_2::runTask);
    enqueueMail::thread.start(enqueueMail::runTask);
    dequeueMail::thread.start(dequeueMail::runTask);
    
    while (true) {
        //indicate program still running
        //led1 = !led1;
        Thread::wait(500);
    }
}
