#ifndef MAP_PUBLIC_H
#define MAP_PUBLIC_H

/// The enum define the status of a grid on the map
typedef enum {
    GRID_BACK,
    GRID_SIDELINE,
    GRID_NODELINE,
} GRID_STATUS;

/// The structure to store the information of a grid
typedef struct {
    int x;               ///< The upper-left corner of the grid. It is the x coordinate on the screen.
    int y;               ///< The upper-left corner of the grid. It is the y coordinate on the screen.
    GRID_STATUS status;  ///< See enum GRID_STATUS
} GRID;

/** Call map_init() once at the begining of your code
    @brief It initialize the map structure and draw the map.
*/
void map_init(void);

/** Remove the candy/big-candy from map
    @brief It could be called by Pacman when it eat the cookie.
    @param grid_x The horizontal position in the grid.
    @param grid_y The vertical position in the grid.
    @return 1:There is a candy be eaten. 0:The is no candy at the grid.
*/
//double map_eat_candy(int grid_x, int grid_y);

/** Get the information about the grid
    @param grid_x The horizontal position in the grid.
    @param grid_y The vertical position in the grid.
    @return The data structure of the grid. You could access the contents by using the_grid.x , the_grid.status ... etc.
*/
GRID map_get_grid_status(int grid_x, int grid_y);

/** Draw the grid
    @param grid_x The horizontal position in the grid.
    @param grid_y The vertical position in the grid.
*/
void map_draw_grid(unsigned grid_x, unsigned grid_y);

/** Get the number of remaining candy.
    @brief The game should be ended when there is no candy.
    @return The number of remaining cookie.
*/
//int  map_remaining_candy(void);

#endif //MAP_H