
#include <mbed.h>
#include <string>
#include <list>
#include "uLCD_4DGL.h"
#include "DebounceIn.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "rtos.h"
#include "stdio.h"
#include "map_public.h"
#include "globals.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DebounceIn  push5(p21);
DebounceIn  push4(p22);
DebounceIn  push3(p23);

DebounceIn  push2(p24);
DebounceIn  push1(p25);

InterruptIn interrupt(p11);
I2C i2c(p9, p10);



SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);
uLCD_4DGL uLCD(p13,p14,p15);
wave_player waver(&DACout);

Mutex stdio_mutex; 
Mutex lcd_mutex;


volatile int check = 0;
volatile int status = 0;
volatile int global;
volatile int point_bar = 4;
volatile int songNum = 1;


int score = 0;
volatile int meter = 15;
int scrollSpeed = 6;

int node1Pressed = 0;
int node2Pressed = 0;
int node3Pressed = 0;
int node4Pressed = 0;


struct gameNode {
    int yPos;
    int alive;
    gameNode *next;
};

gameNode* node1Root = NULL;
gameNode* node2Root = NULL;
gameNode* node3Root = NULL;
gameNode* node4Root = NULL;

enum gameState{
    begin,
    playing,
    over
};


enum node{
    node1,
    node2,
    node3,
    node4,
    none,
};

int nodeToDelete(none);

void deleteRoot (gameNode* &gNode, int nodeNum) {
    gameNode* temp = gNode;
    
    switch(nodeNum) {
        case 1:
        //uLCD.line(4, gNode->yPos-scrollSpeed, 14, gNode->yPos+10-scrollSpeed, BACKGROUND_COLOR);
        //uLCD.line(4, gNode->yPos-scrollSpeed, 14, gNode->yPos-10-scrollSpeed, BACKGROUND_COLOR);
        if(gNode->yPos>100 && gNode->yPos<120)
        {
            uLCD.filled_rectangle(37, gNode->yPos-scrollSpeed, 59, gNode->yPos-scrollSpeed+5, YELLOW);
        }
        else
        {
            uLCD.filled_rectangle(37, gNode->yPos-scrollSpeed,59,gNode->yPos-scrollSpeed+5,0x1E01AF);
        }
        break;
        
        case 2:
        if(gNode->yPos>100 && gNode->yPos<120)
        {
            uLCD.filled_rectangle(60, gNode->yPos-scrollSpeed, 82, gNode->yPos-scrollSpeed+5, YELLOW);
        }
        else
        {
            uLCD.filled_rectangle(60, gNode->yPos-scrollSpeed,82,gNode->yPos-scrollSpeed+5,0x1E01AF);
        }
        //uLCD.filled_rectangle(37,gNode->yPos-scrollSpeed,57,gNode->yPos-scrollSpeed+5,BACKGROUND_COLOR); 
        //uLCD.line(47, gNode->yPos-scrollSpeed-10, 37, gNode->yPos-scrollSpeed, BACKGROUND_COLOR);
        //uLCD.line(47, gNode->yPos-scrollSpeed-10, 57, gNode->yPos-scrollSpeed, BACKGROUND_COLOR);
        break;
        
        case 3:
        if(gNode->yPos>100 && gNode->yPos<120)
        {
            uLCD.filled_rectangle(83, gNode->yPos-scrollSpeed, 105, gNode->yPos-scrollSpeed+5, YELLOW);
        }
        else
        {
            uLCD.filled_rectangle(83, gNode->yPos-scrollSpeed,105,gNode->yPos-scrollSpeed+5,0x1E01AF);
        }
        //uLCD.filled_rectangle(70,gNode->yPos-scrollSpeed,90,gNode->yPos-scrollSpeed+5,BACKGROUND_COLOR); 
        //uLCD.line(80, gNode->yPos-scrollSpeed+10, 70, gNode->yPos-scrollSpeed, BACKGROUND_COLOR);
        //uLCD.line(80, gNode->yPos-scrollSpeed+10, 90, gNode->yPos-scrollSpeed, BACKGROUND_COLOR);
        break;
        
        case 4:
        if(gNode->yPos>100 && gNode->yPos<120)
        {
            uLCD.filled_rectangle(106, gNode->yPos-scrollSpeed, 128, gNode->yPos-scrollSpeed+5, YELLOW);
        }
        else
        {
            uLCD.filled_rectangle(106, gNode->yPos-scrollSpeed,128,gNode->yPos-scrollSpeed+5,0x1E01AF);
        }
        //uLCD.filled_rectangle(104,gNode->yPos-scrollSpeed,124,gNode->yPos-scrollSpeed+5,BACKGROUND_COLOR); 
        //uLCD.line(124, gNode->yPos-scrollSpeed, 114, gNode->yPos-scrollSpeed+10, BACKGROUND_COLOR);
        //uLCD.line(124, gNode->yPos-scrollSpeed, 114, gNode->yPos-scrollSpeed-10, BACKGROUND_COLOR);
        break;    
    }
    
    gNode = gNode->next;
    delete temp;
}



void addToEnd (gameNode* &root) {
    gameNode * temp = root;
    if (root == NULL)
    {
        root = new gameNode;
        root->yPos = 10;
        root->alive = 1;
        root->next = 0;  
    }
    else {
        while (temp->next)
        {
            temp = temp->next;    
        }    
    
        temp->next = new gameNode;
        temp = temp->next;
        temp->yPos = 10;
        temp->alive = 1;
        temp->next = 0;  
    }
}


void drawnode1gameNode (int y) {
    if(y > 100 && y < 120)
    {
        uLCD.filled_rectangle(37,y-scrollSpeed, 59, y-scrollSpeed+5, YELLOW);
    }
    else {
        uLCD.filled_rectangle(37,y-scrollSpeed,59,y-scrollSpeed+5,0x1E01AF);
    }
    uLCD.filled_rectangle(37,y,59,y+5,WHITE); 
    
}

void drawnode2gameNode (int y) {
    if(y > 100 && y < 120)
    {
        uLCD.filled_rectangle(60,y-scrollSpeed, 82, y-scrollSpeed+5, YELLOW);
    }
    else {
        uLCD.filled_rectangle(60,y-scrollSpeed,82,y-scrollSpeed+5,0x1E01AF);
    }
    uLCD.filled_rectangle(60,y,82,y+5,WHITE); 

}

void drawnode3gameNode (int y) {
    if(y > 100 && y < 120)
    {
        uLCD.filled_rectangle(83,y-scrollSpeed, 105, y-scrollSpeed+5, YELLOW);
    }
    else {
        uLCD.filled_rectangle(83,y-scrollSpeed,105,y-scrollSpeed+5,0x1E01AF);
    }
    uLCD.filled_rectangle(83,y,105,y+5,WHITE); 
    
}

void drawnode4gameNode (int y) {
    if(y > 100 && y < 120)
    {
        uLCD.filled_rectangle(106,y-scrollSpeed, 128, y-scrollSpeed+5, YELLOW);
    }
    else {
        uLCD.filled_rectangle(106,y-scrollSpeed,128,y-scrollSpeed+5,0x1E01AF);
    } 
    uLCD.filled_rectangle(106,y,128,y+5,WHITE); 
}



void notify(const char* name, int state) {
    stdio_mutex.lock();
    printf("%s: %d\n\r", name, state);
    stdio_mutex.unlock();
}

void test_thread(void const *args) {
    while (true) {
        notify((const char*)args, 0); Thread::wait(1000);
        notify((const char*)args, 1); Thread::wait(1000);
    }
}

void thread1(void const *args)
{
    
    while(1)
    {
        if(status == 1)
        {
            
            
            //led1 = 1;
            status = 0;
            
            if(songNum == 1)
            {
                FILE *wave_file;
                wave_file=fopen("/sd/TWICE_TT_converted.wav","r");
                waver.play(wave_file);
                fclose(wave_file);
                meter = 0;
            }
            
            else if(songNum == 2)
            {
                FILE *wave_file;
                wave_file=fopen("/sd/Star_Wars_converted.wav","r");
                waver.play(wave_file);
                fclose(wave_file);
                meter = 0;
            }
                
            else
            {
                FILE *wave_file;
                wave_file=fopen("/sd/Terra_converted.wav","r");
                waver.play(wave_file);
                fclose(wave_file);
                meter = 0;
            }
            
            //led2 = 1;
        }
    }
    
}



int main()
{
    srand(time(NULL));
    push1.mode(PullUp);
    push2.mode(PullUp);
    push3.mode(PullUp);
    push4.mode(PullUp);
    push5.mode(PullUp);
    
    int setup = 1;
    
    Thread t1(thread1);
    
    uLCD.baudrate(3000000);
    
    int gameOn=1;
    int ready;
    int node1Counter;
    int node2Counter;
    int node3Counter;
    int node4Counter;
    int deleted=0;
    int drawgameNode=1;
    Timer t;
    float time = 0.0;
    gameNode* temp;
    node1Counter = rand()%150+50;
    node2Counter = rand()%150+50;
    node3Counter = rand()%150+50;
    node4Counter = rand()%150+50;
    scrollSpeed = 6;
    
    
    
    while(setup)
    {
        int GameStart = 0;
        int GameOver = 0;
        int old_pb = 0;
    
        int new_pb1;
        int new_pb2;
        int new_pb3;
        
        uLCD.locate(0,0);
        uLCD.printf("Rhythm Game");
        uLCD.locate(0,2);
        uLCD.printf("Song Select");
        uLCD.locate(3,4);
        uLCD.printf("TWICE_TT");
        uLCD.locate(3,5);
        uLCD.printf("Star_Wars");
        uLCD.locate(3,6);
        uLCD.printf("Terra");
        uLCD.locate(0,4);
        uLCD.printf("->");
    
        int p_bar = 4;
        
        
        while(!GameOver)
        {
            new_pb1 = push1;
            new_pb2 = push2;
            new_pb3 = push3;
            
            //Moving Down
            if((new_pb1 ==0)&&(old_pb==1)&&(p_bar!=4))
            {
                if(p_bar==5)
                {
                    p_bar = 4;
                    uLCD.locate(0,p_bar);
                    uLCD.printf("->");
                    uLCD.locate(0,5);
                    uLCD.printf("  ");
                    uLCD.locate(0,6);
                    uLCD.printf("  ");
                }
        
                else
                {
                    p_bar = 5;
                    uLCD.locate(0,p_bar);
                    uLCD.printf("->");
                    uLCD.locate(0,4);
                    uLCD.printf("  ");
                    uLCD.locate(0,6);
                    uLCD.printf("  ");
                }
                old_pb = new_pb1;
            }
            //Moving Up
            else if((new_pb3 ==0)&&(old_pb==1)&&(p_bar!=6))
            {
                if(p_bar==4)
                {
                    p_bar = 5;
                    uLCD.locate(0,p_bar);
                    uLCD.printf("->");
                    uLCD.locate(0,6);
                    uLCD.printf("  ");
                    uLCD.locate(0,4);
                    uLCD.printf("  ");
                }
        
                else
                {
                    p_bar = 6;
                    uLCD.locate(0,p_bar);
                    uLCD.printf("->");
                    uLCD.locate(0,4);
                    uLCD.printf("  ");
                    uLCD.locate(0,5);
                    uLCD.printf("  ");
                }
                old_pb = new_pb3;
            }
            
            
            else if((new_pb2 ==0)&&(old_pb==1))
            {
               
               
               
                uLCD.locate(0,8);
                uLCD.printf("song is selected");
                wait(1);
                
                uLCD.cls();
                
                if(p_bar == 4)
                {
                    songNum = 1;
                    status = 1;
                    
                    uLCD.cls();
                    uLCD.locate(0,3);
                    uLCD.printf("Start TT");
                    wait(.3);
                    GameOver = 1;
                    uLCD.cls();
                }           
                
                else if(p_bar == 5)
                {
                    songNum = 2;
                    status = 1;
                    
                    uLCD.cls();
                    uLCD.locate(0,3);
                    uLCD.printf("Start StarWars");
                    wait(.3);
                    GameOver = 1;
                    uLCD.cls();
                }   
                     
                else
                {
                    songNum = 3;
                    status = 1;
                    
                    uLCD.cls();
                    uLCD.locate(0,3);
                    uLCD.printf("Start Terra");
                    wait(.3);
                    GameOver = 1;
                    uLCD.cls();
                }     
                
            
                
                while(gameOn)
                {
                    t.reset();
                    t.start();
                    drawgameNode = 1;
        
                    //map_init();
                    uLCD.filled_rectangle(31,0,36,128,0xD9431C);
                    uLCD.filled_rectangle(37,0,128,120,0x1E01AF);
                    uLCD.filled_rectangle(37,98,128,120,YELLOW);
                    if(node1Counter <= 0)
                    {
                        addToEnd(node1Root);
                        node1Counter = rand()%150+50;
                        drawgameNode = 0;
                    }
                    node1Counter -= scrollSpeed;
                    temp = node1Root;//node1Root = NULL
                    while(temp!=NULL)
                    {
                        drawnode1gameNode(temp->yPos);
                        temp->yPos += scrollSpeed;
                        temp = temp->next;
                    }
                    if(node1Root != NULL)
                    {
                        if(node1Root->yPos >= 120 || nodeToDelete == node1)
                        {
                            //meter--;
                            deleteRoot(node1Root, 1);
                            deleted = 1;
                        }
                    }
        
                    if(node2Counter<=0&&drawgameNode)
                    {
                        addToEnd(node2Root);
                        node2Counter = rand()%150+50;
                        drawgameNode=0;
                    }
                    node2Counter -=scrollSpeed;//node2Counter = node2Counter - scrollSpeed
                    temp = node2Root;
                    while(temp != NULL)
                    {
                        drawnode2gameNode(temp->yPos);
                        temp->yPos += scrollSpeed;
                        temp = temp->next;
                    }
                    if(node2Root != NULL)
                    {
                        if(node2Root->yPos >= 120 || nodeToDelete == node2)
                        {
                            //meter--;
                            deleteRoot(node2Root, 2);
                            deleted = 1;
                        }
                    }
        
                    if(node3Counter<=0&&drawgameNode)
                    {
                        addToEnd(node3Root);
                        node3Counter = rand()%150+50;
                        drawgameNode=0;
                    }
                    node3Counter -=scrollSpeed;
                    temp = node3Root;
                    while(temp != NULL)
                    {
                        drawnode3gameNode(temp->yPos);
                        temp->yPos += scrollSpeed;
                        temp = temp->next;
                    }
                    
                    if(node3Root != NULL)
                    {
                        if(node3Root->yPos >= 120 || nodeToDelete == node3)
                        {
                            //meter--;
                            deleteRoot(node3Root, 3);
                            deleted = 1;
                        }
                    }
        
                    if(node4Counter<=0&&drawgameNode)
                    {
                        addToEnd(node4Root);
                        node4Counter = rand()%150+50;
                        drawgameNode=0;
                    }
                    node4Counter -=scrollSpeed;
                    temp = node4Root;
                    while(temp != NULL)
                    {
                        drawnode4gameNode(temp->yPos);
                        temp->yPos += scrollSpeed;
                        temp = temp->next;
                    }
                    if(node4Root != NULL)
                    {
                        if(node4Root->yPos >= 120 || nodeToDelete == node4)
                        {
                            //meter--;
                            deleteRoot(node4Root, 4);
                            deleted = 1;
                        }
                    }
        
                    //interrupt
                    if(!push2)
                    {//push button is a Pull-Up, so the initial condition is 1 flippled to 0
                        node1Pressed = 1;
                        if(node1Root)
                        {
                            if(node1Root->yPos > 90 && node1Root->yPos < 128)
                            {
                                score++;
                                //meter+=2;
                            }
                            if(node1Root->yPos > 95)
                            {
                                nodeToDelete = node1;
                            }
                        }
                    }
                    if(!push3)
                    {
                        node2Pressed = 1;
                        if(node2Root)
                        {
                            if(node2Root->yPos > 90 && node2Root->yPos < 128)
                            {
                                score++;
                                //meter+=2;
                            }
                            if(node2Root->yPos > 95)
                            {
                                nodeToDelete = node2;
                            }
                        }
                    }
                    if(!push4)
                    {
                        node3Pressed = 1;
                        if(node3Root)
                        {
                            if(node3Root->yPos > 90 && node3Root->yPos < 128)
                            {
                                score++;
                                //meter+=2;
                            }
                            if(node3Root->yPos > 95)
                            {
                                nodeToDelete = node3;
                            }
                        }
                    }
                    if(!push5)
                    {
                        node4Pressed = 1;
                        if(node4Root)
                        {
                            if(node4Root->yPos > 90 && node4Root->yPos < 128)
                            {
                                score++;
                                //meter+=2;
                            }
                            if(node4Root->yPos > 95)
                            {
                                nodeToDelete = node4;
                            }
                        }
                    }
                    if(!push1)
                    {
                        status = 0;
                        uLCD.cls();
                        break;
                    }
        
        
                    /////interrupt done
                    t.stop();
                    time = .1-t.read();
                    if (time < 0) time = 0;
                    uLCD.locate(0,0);
                    uLCD.text_width(1);
                    uLCD.printf("Score");
                    uLCD.locate(0,1);
                    uLCD.printf("%04d",score);
                    if(meter>15) meter=15;
                    
                    if(meter==0)
                    {
                        while(node1Root)
                        {
                            deleteRoot(node1Root,1);
                        }
                        while(node2Root)
                        {
                            deleteRoot(node2Root,2);
                        }
                        while(node3Root)
                        {
                            deleteRoot(node3Root,3);
                        }
                        while(node4Root)
                        {
                            deleteRoot(node4Root,4);
                        }
                        uLCD.cls();
                        uLCD.locate(5,8);
                        uLCD.text_mode(OPAQUE);
                        uLCD.printf("GAME OVER");
                        uLCD.locate(2,9);
                        uLCD.printf("your score: %d", score);
                        meter=15;
                        score=0;
                        wait(2);
                        break;
                    }
                    
                    
                    //uLCD.locate(0,2);
                    //uLCD.set_font_size(4,4);
                    //uLCD.printf("Life");
                    //uLCD.locate(0,3);
                    //uLCD.printf("%2d",meter);
                    
                    if (deleted)
                    {
                        nodeToDelete = none;
                        deleted = 0;
                    }
                    
                    //wait(time);
                    
                    //uLCD.cls();
                    old_pb = new_pb2; 
                    
                }//GameOn over      
            
                
            }
            else
            {
                uLCD.locate(0,9);
                //uLCD.printf("else else");
                old_pb = new_pb1;
            }
        }
        
    
    }
    
}