#ifndef MAP_PRIVATE_H
#define MAP_PRIVATE_H

#include "mbed.h"

#ifndef ULCD_4DGL_H_
#define ULCD_4DGL_H_
#include "uLCD_4DGL.h"
#endif

#include "globals.h"
#include "map_public.h"

// It defines the settings for drawing the map
#define BACK_COLOR 0x000000
#define SIDELINE_COLOR 0xFF7F7F
#define NODELINE_COLOR 0xE5E500
//#define SIDE_WALK_COLOR_2    0x999999
//#define SIDE_WALK_COLOR    0x198C19
//#define LINE_COLOR  0xE5E500
//#define CANDY_COLOR  0xFF7F7F
//#define CANDY_RADIUS 1
//#define BIG_CANDY_RADIUS 2
//#define WHITE 0xFFFFFF



// It defines the values used in the DEFAULT_MAP
#define MAP_ATTRIBUTE_BACK 0
#define MAP_ATTRIBUTE_SIDELINE 1
//#define MAP_ATTRIBUTE_SCORE 2
#define MAP_ATTRIBUTE_NODELINE 2
/*
#define MAP_ATTRIBUTE_SIDE_WALK   0 //side walk
#define MAP_ATTRIBUTE_CANDY       1 //candy
#define MAP_ATTRIBUTE_BIG_CANDY   2 //big candy
#define MAP_ATTRIBUTE_ROAD_L      3 //left side of the road    
#define MAP_ATTRIBUTE_ROAD        4 //middle of the road
#define MAP_ATTRIBUTE_ROAD_R      5 //right side of the road
#define MAP_ATTRIBUTE_V_LINE      6 //finish line
#define MAP_ATTRIBUTE_SIDE_WALK_2 7 
*/

#define DEFAULT_MAP {\
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
0,   0,   0,   0,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  \
0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  \
}

// Here defines some useful macros
#define IDX2X(idx)  (idx%NUM_GRID_X)
#define IDX2Y(idx)  (idx/NUM_GRID_X)
#define XY2IDX(x,y) (y*NUM_GRID_X+x)

void map_draw(void);


#endif //MAP_H