//******************************************************************************
//*
//*     FULLNAME:  Single-Chip Microcontroller Real-Time Operating System
//*
//*     NICKNAME:  scmRTOS
//*
//*     PROCESSOR: ARM Cortex-M3 
//*
//*     TOOLKIT:   RVCT (ARM)
//*
//*     PURPOSE:   Port Test File
//*
//*     Version: 3.10
//*
//*     $Revision: 196 $
//*     $Date:: 2010-09-09 #$
//*
//*     Copyright (c) 2003-2010, Harry E. Zhurov
//*
//*     Permission is hereby granted, free of charge, to any person 
//*     obtaining  a copy of this software and associated documentation 
//*     files (the "Software"), to deal in the Software without restriction, 
//*     including without limitation the rights to use, copy, modify, merge, 
//*     publish, distribute, sublicense, and/or sell copies of the Software, 
//*     and to permit persons to whom the Software is furnished to do so, 
//*     subject to the following conditions:
//*
//*     The above copyright notice and this permission notice shall be included 
//*     in all copies or substantial portions of the Software.
//*
//*     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//*     EXPRESS  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
//*     MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
//*     IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
//*     CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
//*     TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH 
//*     THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//*
//*     =================================================================
//*     See http://scmrtos.sourceforge.net for documentation, latest
//*     information, license and contact details.
//*     =================================================================
//*
//******************************************************************************
//*     mbed port by Igor Skochinsky

#include <mbed.h>
#include <scmRTOS.h>

//---------------------------------------------------------------------------
//
//      Process types
//
typedef OS::process<OS::pr0, 300> TProc1;
typedef OS::process<OS::pr1, 300> TProc2;
typedef OS::process<OS::pr2, 300> TProc3;
//---------------------------------------------------------------------------
//
//      Process objects
//
TProc1 Proc1;
TProc2 Proc2;
TProc3 Proc3;
//---------------------------------------------------------------------------
//
//      IO Pins
//
DigitalOut led1(LED1);
DigitalOut led2(LED2);

//---------------------------------------------------------------------------
//
//      Event Flags to test
//
OS::TEventFlag ef;
OS::TEventFlag timerEvent;

//---------------------------------------------------------------------------
//
int main()
{
    // configure IO pins
    led1.write(0);
    led2.write(0);

    // run
    OS::Run();
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec()
{
    for(;;)
    {
        ef.Wait();
        printf("e\n");
        led1.write(0);
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec()
{
    for(;;)
    {
        timerEvent.Wait();
        printf("t\n");
        Sleep(5000);
        led2.write(0);
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc3::Exec()
{
    for (;;)
    {
        led1.write(1);
        Sleep(5000);
        ef.Signal();
        Sleep(5000);
    }
}

//---------------------------------------------------------------------------
void OS::SystemTimerUserHook()
{
    static int cnt=0;
    if (++cnt == 2000)
    {
        cnt = 0;
        led2.write(1);
        timerEvent.SignalISR();
    }
}

//---------------------------------------------------------------------------
void OS::IdleProcessUserHook()
{
    __WFI();
}
//-----------------------------------------------------------------------------
