#include "mbed.h"

#include "FastIO.h"

#define LED_MASK 0x07800000

DigitalOut led1(LED1);
FastOut<LED2> led2;
PortOut ledport(Port0, LED_MASK);
FastPortOut<Port0, LED_MASK> ledport2;
MaskedPortOut<Port0, LED_MASK> ledport3;

Timer t;
#define LOOPS 100000000
int main() {
    int value = 0;
    int count = LOOPS;
    t.start();
    while ( count -- )
    {
        led1.write(value);
        value = 1-value;
    }
    t.stop();
    printf("DigitalOut: %f seconds (%d ns per iteration).\n", t.read(), t.read_us()/(LOOPS/1000));
    
    count = LOOPS;
    t.reset();
    t.start();
    while ( count -- )
    {
        led2 = value;
        value = 1-value;
    }
    t.stop();
    printf("FastOut: %f seconds (%d ns per iteration).\n", t.read(), t.read_us()/(LOOPS/1000));

    count = LOOPS;
    t.reset();
    t.start();
    value = LED_MASK;
    while ( count -- )
    {
        ledport.write(value);
        value ^= LED_MASK;
    }
    t.stop();
    printf("PortOut: %f seconds (%d ns per iteration).\n", t.read(), t.read_us()/(LOOPS/1000));

    count = LOOPS;
    t.reset();
    t.start();
    value = LED_MASK;
    while ( count -- )
    {
        ledport2 = value;
        value ^= LED_MASK;
    }
    t.stop();
    printf("FastPortOut: %f seconds (%d ns per iteration).\n", t.read(), t.read_us()/(LOOPS/1000));

    count = LOOPS;
    t.reset();
    t.start();
    value = LED_MASK;
    while ( count -- )
    {
        ledport3 = value;
        value ^= LED_MASK;
    }
    t.stop();
    printf("MaskedPortOut: %f seconds (%d ns per iteration).\n", t.read(), t.read_us()/(LOOPS/1000));
}
