#include "mbed.h"
#include <limits.h>

DigitalOut myled(LED1);
LocalFileSystem local("local");

// code from FFTCM3.s by Ivan Mellen
// http://www.luminarymicro.com/component/option,com_joomlaboard/Itemid,92/func,view/id,1636/catid,6/
extern "C" void fftR4(short *y, short *x, int N);
extern "C" void ifftR4(short *y, short *x, int N);

// code from STM32 DSP Library
/* 64 points*/
extern "C" void cr4_fft_64_stm32(void *pssOUT, void *pssIN, uint16_t Nbin);
/* 256 points */
extern "C" void cr4_fft_256_stm32(void *pssOUT, void *pssIN, uint16_t Nbin);
/* 1024 points */
extern "C" void cr4_fft_1024_stm32(void *pssOUT, void *pssIN, uint16_t Nbin);

void test_stm32()
{
#define N 64 /*Number of points*/
    uint32_t x[N], y[N]; /* input and output arrays */
    int16_t real[N], imag[N]; /* real and imaginary arrays */
    memset(real, 0, sizeof(real));
    memset(imag, 0, sizeof(imag));
    real[1]=SHRT_MAX;
    /* Fill the input array */
    for (int i=0; i<N; i++)
    {
        x[i] = (((uint16_t)(real[i])) | ((uint32_t)(imag[i]<<16)));
    }
    cr4_fft_64_stm32(y, x, N); /*computes the FFT of the x[N] samples*/
    FILE* log = fopen("/local/stm32.txt","w");
    for (int i=0; i<N; i++)
    {
        fprintf(log, "%d: %d, %d -> %d, %d\n", i, real[i], imag[i], int16_t(y[i] & 0xFFFF), int16_t(y[i] >> 16));
    }
    fclose(log);    
}

void test_mellen()
{
    short x[512]; // input data 16 bit, 4 byte aligned  x0r,x0i,x1r,x1i,....
    short y[512]; // output data 16 bit,4 byte aligned  y0r,y0i,y1r,y1i,....
    short z[512]; // same format...
    
    for (int i=0;i<512;i++) x[i]=0;
    for (int i=0;i<512;i=i+8)
      { x[i+0]=16384; x[i+2]=16384;    x[i+4]=-16384;  x[i+6]=-16384;}
    // x = [ 16384,16384,-16384,-16384,16384,...]  1/4 Fsampling
    
    //call functions
    fftR4(y, x, 256);   // y is in frequency domain y[128]=
    printf("fftR4 ok\n");
    ifftR4(z, y, 256);  // z should be x/N + noise introduced by 16 bit truncating 
    printf("ifftR4 ok\n");
    FILE* log = fopen("/local/mellen.txt","w");
    for (int i=0; i<256; i++)
    {
        fprintf(log, "%d: %d -> %d -> %d\n", i, x[i], y[i], z[i]);
    }
    fclose(log);    
}

int main()
{
    printf("Testing Mellen\n");
    test_mellen();
    printf("Testing STM32\n");
    test_stm32();
    printf("Done\n");
}
