#include "mbed.h"
#include "Graphics.h"
#include "Cuboid.h"
#include "TrimeshObject.h"
#include "TieFighter.h"
#include "DogLCD.h"
#include "hellombed.h"

SPI spi(p5, NC, p7);
DogLCD dog(spi, p17, p18, p20, p19); //  spi, power, cs, a0, reset
Graphics g(&dog);
TrimeshObject tf(tie_fighter_vertices, tie_fighter_faces, TIE_FIGHTER_NUM_FACES);
Cuboid cube;

int main()
{
    dog.init();
    // draw "hello mbed"
    dog.send_pic(pic_hellombed);
    wait(5);
    // draw rectangle around the screen
    g.line(0, 0, dog.width()-1, 0, 0xFFFFFF);
    wait(2);
    g.line(dog.width()-1, 0, dog.width()-1, dog.height()-1, 0xFFFFFF);
    wait(2);
    g.line(dog.width()-1, dog.height()-1, 0, dog.height()-1, 0xFFFFFF);
    wait(2);
    g.line(0, dog.height()-1, 0, 0, 0xFFFFFF);
    wait(5);
    
    dog.clear_screen();
    float rotx = 0, roty = 0, rotz = 0;
    
    Timer timer;
    timer.start();
    int frameno = 0;
    const int pollcount = 10;
    // shift 1/4th of screen to the left
    tf.position(-dog.width() / 4, 0, 0);
    tf.colour(0xffffff);
    // shift 1/4th of screen to the right
    cube.position(+dog.width() / 4, 0, 0);
    cube.colour(0xffffff);
    while (1)
    {
        rotx += 0.1;
        roty += 0.08;
        rotz += 0.05;
        
        // set rotation angles
        tf.rotate(rotx, roty, rotz);
        cube.rotate(rotx, roty, rotz);
        // lock update
        dog.beginupdate();
            dog.clear_screen();
            // render TieFighter
            tf.render(g);
            // and the cube
            cube.render(g);
        // unlock update (and draw framebuffer)    
        dog.endupdate();
        if ( ++frameno == pollcount )
        {
            // output fps to serial
            int end = timer.read_ms();
            float fps = pollcount*1000.0/end;
            printf("\r%d frames, %d ms, FPS: %f", pollcount, end, fps);
            frameno = 0;
            timer.reset();
        }
        //dog.fill(40, 40, 52, 52, 0x000000);
    }
}
