#include "mbed.h"
#include "MMCx12xM.h"

I2C i2c(p9, p10); // sda, scl
DigitalOut memsic_power(p8);

MMCx12xM memsic(i2c);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

int main()
{
    printf("MMC2120M demo\n");
    memsic_power = 1;
    bool ok = memsic.coil_set();
    printf("Set: %d\n", ok);
    
    /*int values[2];
    for (;;)
    {    
        ok = memsic.read_raw_values(values);
        printf("ok: %d, x: %d, y: %d\n", ok, values[0], values[1]);
        wait(2);
    }*/
    
    printf("Starting calibration. Turn the sensor in all possible directions for 10 seconds.\n");    
    memsic.calibrate_begin();
    int cal_count = 0;
    while (1)
    {
        memsic.calibrate_step();
        cal_count++;
        wait_ms(100);
        if ( cal_count > 100 )
            break;
    }    
    memsic.calibrate_end();
    //printf("%d samples were used for calibration\n", cal_count);
    float fvalues[2];
    for (;;)
    {    
        ok = memsic.read_values(fvalues);
        printf("ok: %d, x: %f, y: %f\n", ok, fvalues[0], fvalues[1]);
        led1 = fvalues[0] > 0 ?  fvalues[0] : 0;
        led2 = fvalues[1] > 0 ?  fvalues[1] : 0;
        led3 = fvalues[0] < 0 ? -fvalues[0] : 0;
        led4 = fvalues[1] < 0 ? -fvalues[1] : 0;
        wait_ms(100);
    }
}