#ifndef VIBRO_H
#define VIBRO_H

#define ClrV1  LPC_GPIO1->FIOSET=(1<<25);
#define SetV1  LPC_GPIO1->FIOCLR = (1<<25);

#define TXOn  LPC_GPIO2->FIOSET=(1<<7);
#define TXOff LPC_GPIO2->FIOCLR = (1<<7);

#define  ClrV2 LPC_GPIO1->FIOSET = (1<<28);
#define  SetV2 LPC_GPIO1->FIOCLR = (1<<28);

#define  LoopOn  LPC_GPIO1->FIOSET  = (1<<30);
#define  LoopOff LPC_GPIO1->FIOCLR  = (1<<30);
#define  StartV1  0
#define  StartV2 15
#define  TIME_INTERVAL	(7812)



extern int tempAMP;
typedef struct _Gyro {
   int	        qei;
   int          QEIznak1,QEIznak2;
   unsigned int	StrayHZ; //помеха
   unsigned int	StrayHZ_flag;
   unsigned int	LogHZ;

   int flag;
   unsigned int	StrayPLC_Pls; //помеха +
   int	        StrayPLC_Mns; //помеха -
   unsigned int StrayPLC_2Mode;
   unsigned int	StrayPLC_flag;
   unsigned int	LogPLC;
   unsigned int	PLC_Lern;
   unsigned int	ModJump;
   unsigned int	TimJump;
   unsigned int flagGph_W;
   unsigned int ModAmp;
   
// unsigned int Test_time;
// unsigned int Test_time1;
   
   unsigned int FlashMod; //0-ничего не делать, 1 - запись во Flash, 2 чтение из Flash.
   
   unsigned int ModeOut;
  // unsigned int Rate1_Flag;
   unsigned int Rate1_Event;
  // unsigned int Rate2_Flag;
   unsigned int Reper_Event;
   #define  Rate1       0x01    
   #define  Rate2       0x02  
   #define  PRate1      0x81
   #define  PRate2      0x82
   
   
   unsigned int DeltaEXT_Event;
   unsigned int Delta500_Event;
   unsigned int Delta_Bins_Event500;
   unsigned int B_Delta_EventEXT;
   unsigned int B_Delta_Event500;
   unsigned int Event_500Hz;
   #define   Delta_500   0x10
   #define  PDelta_500   0x90
   #define   Delta_EXT   0x0
   #define  PDelta_EXT   0x80
   #define   Delta_Bins  0x0
   #define  PDelta_Bins  0x1
   
   
   #define  PB_Delta_EXT 0x9
   #define   B_Delta_EXT 0x1
   #define  PB_Delta_INT 0x8
   #define   B_Delta_INT 0x0
   
   unsigned int RgConA;
   unsigned int RgConB;

   unsigned int Gain_Sin;
   unsigned int Gain_Cos;

    unsigned int Frq;       // Непосредственное значение частоты для таймера.
    unsigned int FrqHZ;     // Частота в Гц.
    unsigned int FrqHZmin;  //Мин значение частоты ВП
    unsigned int FrqHZmax;  //Мах  значение частоты ВП
    unsigned int FrqChengSpeed;//скорость регулировки  частоты ВП
    
    unsigned int VibroFrqRegulF;	//флаг регулировки частоты ВП
    unsigned int VibroAMPRegulF;	//флаг регулировки амплитуды ВП
    unsigned int VibroNoiseF;		//флаг ошумления амплитуды ВП
    unsigned int VibroOutF;
    
    
    unsigned int Amp;
    unsigned int AmpT;     // значение тиков после которых происходит смена амплитуды ошумления ( rand() % Gyro.AmpTD+Gyro.AmpMin)
    unsigned int AmpMin;   // минимальное  значение AmpT(частота ошумления);
    unsigned int AmpTD;    // максимальное значение AmpT(частота ошумления);
    unsigned int AmpPer;   // Амплитуда в процентах;
    unsigned int AmpPerMin;
 	unsigned int AmpPerMax;
 	unsigned int AmpSpeed;
 	unsigned int AmpTarget;
    unsigned int AmpPerDel;// значение для расчета амплитуды(дельта амплитуды), мин знач : AmpPer, мах знач : AmpPer+AmpPerDel; (в процентах)
    unsigned int AmpN1;    // левая граница импулься ВП
    unsigned int AmpN2;    // равая граница импулься ВП
    int	MaxAmp;            // амплитуда Пик-Пик расчтитанная по востановленному синусу. 
    int AmpSC;
//ЭНКОДЕР
    int CaunPlus;//
    int CaunMin;//    
// данные АЦП
    unsigned int Termo;	// значение АЦП
    unsigned int TermoNKU;
    float Ktermo;
    unsigned int DeltaT;
    unsigned int In1;
    unsigned int In2;
//пятый ацп, он же амплитудный детектор "AD". есть два фильтра быстрый "Fast" и медленный "Slow"
    unsigned int ADF_Accum;			//Значенее амплитудного детектора Временное
    unsigned int ADS_Accum;			//Значенее амплитудного детектора Временное
    unsigned int ADS_AccumTermLM;
    unsigned int TermLM;
    unsigned int ADF_Count;			//Значенее времени накопления данных
   	unsigned int ADS_Count;			//Значенее времени накопления данных
	
    unsigned int AD_Fast;			//Значенее амплитудного детектора		сдвинутое на 16 бит
    unsigned int AD_Slow;			//Значенее амплитудного детектора		сдвинутое на 16 бит
    unsigned int EventMOD;	
    
    unsigned int ADF_NewData;		// есть данные после фильтрации в быстром фильтре		
    unsigned int ADS_NewData;		//-----------/----------/----------/--------
    
//контур регулеровки Периметра    "PLC"
  	int PLC_Delta; 						// разница между старым и новым показаниями
  	int PLC_DeltaADD; 					// разница между старым и новым показаниями с учетом знака управляешего напряжения АЦП
  	int PLC_Old;
  	int PLC_ADC_DOld; 
	//int PLC_Regul;
  	int PLC_Error2Mode; 				// счетчик, не ноль когдав двух модовом
	int PlC_MaxD;                       // разница между максимальной и текущей амплитудами.

//Контур регулеровки накачки (если нужно, например ГВЧ)

 int tempdelta;
 int tempdelta2;
    
    
    unsigned int CMD_In;
    unsigned int SOC_Out;
    unsigned int My_Addres;
    unsigned int DropDelayGLD;//задержка для мультидропа (дискрета 100кГц)
    #define DropDelayGLD_0 50
    #define DropDelayGLD_1 50
    #define DropDelayGLD_2 65
    #define DropDelayGLD_3 80  
    unsigned int GLD_Serial;
    unsigned int CRC;
    unsigned int Firmware_Version;
    unsigned int RsErrLine;




    
    int 		CuruAngle ;
    int 		OldCuruAngle ;
    int         StopCuruAngle;
// int 		Num;
    int 		Cnt_Dif;

    unsigned int F_ras;

   // unsigned int ras;
  
  
#define FrqOFF  Gyro.RgConA &= ~AFRQ;   //установить контур регулировки частоты в "0"
#define FrqON   Gyro.RgConA |=  AFRQ;   //установить контур регулировки частоты в "1"

  
#define AVibOFF  Gyro.RgConA &= ~AVBT;   //установить контур регулировки частоты в "0"
#define AVibON   Gyro.RgConA |=  AVBT;   //установить контур регулировки частоты в "1"

#define HFOOFF  Gyro.RgConA &= ~AHFO;  //установить контур накачки в "0"
#define HFOON   Gyro.RgConA |= AHFO;   //установить контур накачки в "1"

#define PlcOFF  Gyro.RgConA &= ~APLC;  //установить контур регулировки периметра в "0"
#define PlcON   Gyro.RgConA |= APLC;   //установить контур регулировки периметра в "1"
  
#define  AFRQ 	(1<<6)
#define  AVBT   (1<<5)
#define  APLC  	(1<<3)  
#define  AHFO  	(1<<1)



    
    unsigned int PinReg;     //          bit4             bit3                  bit 2                 bit1                 bit0
    unsigned int PinRegOld;  //    || светодиод || состояние поджига  || состояние подсветки || состояние вибро 2 || состояние вибро 1 ||
#define LedOFF  Gyro.PinReg &= ~PinRegBitLED; //установить бит светодиода в "0"
#define LedON   Gyro.PinReg |= PinRegBitLED;   //установить бит светодиода в "1"


#define  PinRegBitTXE  	(1<<5)
#define  PinRegBitLED  	(1<<4)
#define  PinRegBitD  	(1<<3)
#define  PinRegBitL  	(1<<2)
#define  PinRegBit_2V  	(1<<1)
#define  PinRegBit_1V  	(1<<0)
	unsigned int Discharg;   //   последовательность бит харрактеризующая форму сигнала поджига.
#define  StartDischarg        0x00000222
    unsigned int BackLight;  //   последовательность бит харрактеризующая форму сигнала подсветки.
#define  StartBackLight       0x00000333

#define  ShiftStart0       0x1
#define  ShiftStart1       0x1
#define  ShiftStart2       0x2
#define  ShiftStart3       0x3

unsigned int EXT_Latch;






} GyroT, *Gyro_p;

extern GyroT Gyro;
typedef  union {
    int Array[171];
    struct {
        // Device_blk
        int     My_Addres;            //e. 0 - device own address //r.0 - собственный адрес устройства

        //e. =============== parameters of HFO regulator ===============    //r. =============== параметры контура ВЧ генератора накачки ===============
        int		HF_ref;    		      //e. 1 - value of the reference //r.  1 - значение опоры
        int     HF_scl;               //e. 2 - the gain factor (1.15)    //r. 2 - коэффициент передачи (1.15)
        int     HF_min;              //r.  3 - минимум выходного значения на ЦАПе регулятора (соответствует максим. напряжению на ГВЧ)
        int     HF_max;               //e. 4 - maximum of the output value on the regulator DAC (appropriate to minimal voltage on the HFO) //r.  4 - максимум выходного значения на ЦАПе регулятора (соответствует миним. напряжению на ГВЧ)

        //e. =============== parameters of the regulator of the DS power regulator ========== //r. =============== параметры контура регулирования мощности ДУП ==========
        int     RI_ref;               //e. 5 - value of the reference //r.  5 - значение опоры
        int     RI_scl;               //e. 6 - the gain factor (1.15) //r.  6 - коэффициент передачи (1.15)

        //e. =============== parameters of the CPLC regulator ===== //r. =============== параметры контура стабилизации рабочего периметра (СРП) =====
        int     WP_ref;         //e. 7 -  value of the reference //r.  7 - значение опоры
        int     WP_scl;         //e. 8 - the gain factor (1.15) //r. 8 - коэффициент передачи (1.15)
        int     WP_mdy;         //e. 9 - value of the reset delay //r. 9 - значение задержки сброса
        int     WP_rup;         //e. 10 - upper value of DAC adjustment (appropriate to minimal voltage on the heater) //r. 10 - верхнее значение регулировки ЦАП (соответствует миним. напряжению на нагревателе)
        int     WP_rdw;         //e. 11 - lower value of the DAC adjustment (appropriate to maximal voltage on the heater) //r. 11 - верхнее значение регулировки ЦАП (соответствует максим. напряжению на нагревателе)

        //e. =============== parameters of the dither drive regulator of the GLD ==================== //r. =============== параметры контура вибропривода ГЛД ====================
        int     VB_phs;         //e. 12 - the phase delay parameter of the dither drive PLL //r.  12 - параметр Phase_зад. СРЧ вибропривода
        int     VB_scl;         //e. 13 - the gain factor (1.15) of the dither drive PLL  //r. 13 - коэффициент передачи (1.15) СРЧ вибропривода
        unsigned int VB_N;          //e. 14 - divider for dither drive period (defines dither period) //r. 14 - коэфф.деления N вибропривода (период колебаний) ВП
        unsigned int VB_Nmin;        //e. 15 - minimum of the output value of the oscillation period regulator //r. 15 - минимум выходного значения регулятора периода
        unsigned int VB_Nmax;        //e. 16 - maximum of the output value of the oscillation period regulator //r. 16 - максимум выходного значения регулятора периода

        int     VB_Fdf_Hi;      //e. 17 - adjusted output frequency (H) //r. 17 - заданная частота расщепления (H)
        unsigned int VB_Fdf_Lo;      //e. 18 - (L) (double precision) //r. 18 - (L) (двойная точность)

        int     VB_Fsc;           	 //e. 19 - the gain factor of the frequency regulator //r. 19 - коэффициент передачи регулятора частоты расщепления
        unsigned int VB_Tmin;        //e. 20 - the gain factor of the frequency regulator //r. 19 - коэффициент передачи регулятора частоты расщепления
        unsigned int VB_Tmax;        //e. 21 - maximum of the output value of the regulator //r. 21 - максимум выходного значения регулятора Tau
        unsigned int VB_tau;         //e. 22 - pulse width of the dither drive (without noise)//r. 22 - длительность импульса вибропривода (до ошумления)
        int     VBN_Tzd;      		 //e. 23 - adjusted noise period //r. 23 - заданный период ошумления
        int     VBN_Ran;        	 //e. 24 - range of the random component of noise //r. 24 - диапазон случайной составляющей ошумления VBN_Tsl
        int     VBN_k;          	 //e. 25 - adjusted noise constant //r. 25 - заданная константа ошумления

        //e. =============== parameters of processing of accurate data ============= //r. =============== параметры обработки точностной информации =============
        int     PI_Fsc; //_         //e.  26 - the S_ds scale parameter //r.  26 - масштабный коэффициент Sдуп
        int     PI_Fb0; //_         //e.  27 - the B_ds zero shift of the DS //r.  27 - смещение нуля ДУПа Bдуп
        int     PI_scl; //_         //e.  28 - the Scale scale coefficient of the gyro //r.  28 - масштабный коэфф. гироскопа Scale
        int     PI_bia; //_         //e.  29 - the Bias zero shift of the gyro //r.  29 - смещение нуля гироскопа Bias

        //e. ===============  coefficients of the temperature correction ================= //r. ===============  коэффициенты температурной коррекции =================
        int     PI_a0; //_    	     //  30
        int     PI_a1; //_           //  31
        int     PI_a2; //_   	     //  32
        int     PI_a3; //_           //  33
        int     PI_a4; //_           //  34
        int     PI_a5; //_           //  35
        int     PI_a6; //_           //  36
        int     PI_b1; //_           //  37
        int     PI_b2; //_           //  38
        int     PI_b3; //_           //  39
        int     PI_b4; //_           //  40
        int     PI_b5; //_           //  41
        int     PI_b6; //_           //  42

        //e. =============== parameters of normalization of the temperature sensors  ============= //r. =============== параметры нормировки датчиков температуры =============

        int     Tmp_bias[6]; //_    //e. 43 - an array of shifts of the 0..5 temperature sensors //r. 43 - массив сдвигов температурных датчиков 0..5
        int     Tmp_scal[6]; //_    //e. 49 - an array of the scale coefficients of temperature sensors//r.  49 - массив масштабных к-тов температурных датчиков
        int     WP_reset;           //e. 55 - initial position of the CPLC regulator (after reset)  //r.  55 - исходное положение регулятора СРП (после сброса)

        //e. ================ gain factor of photodetector channels =========== //r. ================ к-т усиления каналов фотоприемника ===========
        unsigned int	Gain_Ph_A;	//e. 56 - initial gain factor of the A channel of photodetector //r.	56 - начальный к-т усиления канала А фотоприемника
        unsigned int	Gain_Ph_B;	//e. 57 - initial gain factor of the B channel of photodetector //r. 57 - начальный к-т усиления канала B фотоприемника

        //e. =============== switch of the source of loading GLD variables block === //r. =============== переключатель источника загрузки блока переменных ГЛД (галочка в настороечной программе)
        
        int		Header_Word;		//e. 58 - flash sector validity header  //r. 58 - заголовок-ключ к индикатору источника загрузки
        int		LoadFlash_enable;	//e. 59 - source loading flag: 1 - load from the flash //r. 59 - признак источника загрузки: 1 - грузиться из flesh

//e. 0 - load default parameters (factory)  //r. 0 - грузить параметры по умолчанию (заводские)
        unsigned int Device_SerialNumber;	//e. 60 - serial number of the device //r. 60 - серийный номер прибора
        int     Reserved0;                  //e. 61 - not used

        int     WP_reset2;                  //e. 91 - voltages of CPLC regulator reset at cooling //r.  xx - напряжения обнуления контура СРП при охлаждении
        //e. parameters setting termocompensation parameters in dynamics (at heating and cooling) //r. параметры, задающие параметры термокомпенсации в динамике (при нагреве и охлаждении)
        float	Reserved1;                  //e. 92 - not used
        float	Reserved2;                  //e. 93 - not used
        int		K_vb_tu; 			//e. 94 - slope of dependence of the VB_N division factor from temperature (as though Hz/degree, but in relative units ) //r. крутизна зависимости коэффициента деления VB_N от температуры (как бы Гц/градус, но в у.е.)
        int		TemperNormal; 		//e. 95 -temperature for which the VB_N division factor of the dither drive is set //r. температура, для которой задан коэффициент деления вибропривода VB_N
        int		K_WP_rst_heating; 	//r. 96 - крутизна зависимости напряжения обнуления при нагревании от температуры (как бы вольт/градус, но в у.е. ЦАП и термодатчиков )
        int		K_WP_rst_cooling; 	//e. 97 - slope of dependence of a reset voltage at cooling from temperature (as though Volt/degree, but in relative units of DAC and temperature sensors)  //r. крутизна зависимости напряжения обнуления при охлаждении от температуры (как бы вольт/градус, но в у.е. ЦАП и термодатчиков )
        int		WP_transition_step; //e. 98 - step of change of a heater voltage at resetting //r. шаг изменения напряжения нагревателя при выполнении обнуления
        int		Reserved3; // e. 99 -not used
        int     HF_scl_2;         //r. 100 -  коэффициент передачи (1.15) контура ГВЧ при обнулении
//    int 	TemperIntDyn[TERMO_FUNC_SIZE]; //e. 114 -
//    float   ThermoHeatDelta[TERMO_FUNC_SIZE]; //e. 128 -
        int     DeltaTempRecalc;   //r. 129 - температурный интервал пересчета динамич. компенсации (в у.е.) //e. temperature delta for dynamic thermocompensation recalculation(in relative units)
//   int 	TemperCoolIntDyn[TERMO_FUNC_SIZE]; // e. 143 -
//   float   ThermoCoolDelta[TERMO_FUNC_SIZE];  //e. 157 -
// TERMO_MODE	TermoMode;	//e  62 - device operation mode (with thermocompenstion, without it, debug )//r.  62 - режим работы прибора (с термокомпенсацией, без нее или отладка)
//e. addition for the piecewise-linear termocorrection //r. добавление для кусочно-линейной термокоррекции
//     int 	TemperInt[TERMO_FUNC_SIZE];	//e. 63
//   float 	TermoFunc[TERMO_FUNC_SIZE];	//e. 77
    } Str;
} GyroParam;

extern 	GyroParam GyroP;

extern void AllRegul (void);
extern unsigned int amp;
extern int  Rate2VibFlag;
extern void cheng(void);

extern void VibroOut(void);

extern void VibroAMPRegul(void);
extern void VibroFrqRegul(void);
extern unsigned int FrecTp;
extern int Pulse_midl;
extern struct VIBRO Vib;
extern int PulseHalf;
extern int CuruAngle;
extern unsigned int FrecTemp;
#endif

