/****************************************Copyright (c)****************************************************
**                                 http://www.PowerAVR.com
**								   http://www.PowerMCU.com
**--------------File Info---------------------------------------------------------------------------------
** File name:           uart.c
** Last modified Date:  2010-05-12
** Last Version:        V1.00
** Descriptions:        
**
**--------------------------------------------------------------------------------------------------------
** Created by:          PowerAVR
** Created date:        2010-05-10
** Version:             V1.00
** Descriptions:        
**
*--------------------------------------------------------------------------------------------------------      YJVTHF

*********************************************************************************************************/

                           /* LPC17xx definitions    */
#include "uart_m.h"
#include "Global.h" 
//555

//#define FPCLK                      (100000000)                        //� pll  
//#define FPCLK                      (12000000)                        	//� pll  
#define FOSC                        12000000                            /*  ������Ƶ��                  */
#define FCCLK                      (FOSC  * 8)                          /*  ��ʱ��Ƶ��<=100Mhz          */
                                                                	/*  FOSC��������                */
#define FCCO                       (FCCLK * 3)                          /*  PLLƵ��(275Mhz~550Mhz)      */

//#define FPCLK                      (FCCLK / 4)                        //� pll  


//#define FPCLK                   (100000000 / 4)                        //� pll  
//#define FPCLK                   (100000000)                        //� pll  
  #define FPCLK                   (103200000)        
//#define FPCLK                     (25000000)                        //� pll  




int UART0_BPS =		9600 ;                                           /* ����0ͨ�Ų�����             */
int UART1_BPS =    	4800;                                             	/* ����0ͨ�Ų�����             */
int UART2_BPS =    	9600 ;                                             	/* ����0ͨ�Ų�����             */
int UART3_BPS =    	19200 ;                                             /* ����0ͨ�Ų�����             */

#define   UART_LCR_ODD  0x0b
#define   UART_LCR_EVEN  0x1b


int UART_LCR   =  UART_LCR_EVEN   ;




char InCon[1024];
char OutCon[1024];

unsigned int  ConInPnt = 0;
unsigned int  ConInCur = 0;
unsigned int  ConOutPnt = 0;
unsigned int  ConOutCur = 0;


char InCon1[1024];
char OutCon1[1024];

unsigned int  ConInPnt1 = 0;
unsigned int  ConInCur1 = 0;
unsigned int  ConOutPnt1 = 0;
unsigned int  ConOutCur1 = 0;


char InCon2[1024];
char OutCon2[1024];

unsigned int  ConInPnt2 = 0;
unsigned int  ConInCur2 = 0;
unsigned int  ConOutPnt2 = 0;
unsigned int  ConOutCur2 = 0;

char InCon3[1024];
char OutCon3[1024];

unsigned int  ConInPnt3 = 0;
unsigned int  ConInCur3 = 0;
unsigned int  ConOutPnt3 = 0;
unsigned int  ConOutCur3 = 0;



unsigned int InCon2M[16];
unsigned int OutCon2M[16];

unsigned int  ConInPnt2M = 0;
unsigned int  ConInCur2M = 0;
unsigned int  ConOutPnt2M = 0;
unsigned int  ConOutCur2M = 0;

unsigned int InCon3M[16];
unsigned int OutCon3M[16];

unsigned int  ConInPnt3M = 0;
unsigned int  ConInCur3M = 0;
unsigned int  ConOutPnt3M = 0;
unsigned int  ConOutCur3M = 0;





unsigned int 	OutBufConCount = 0;
unsigned int 	OutBufCon1Count = 0;
unsigned int 	OutBufCon2Count = 0;
unsigned int 	OutBufCon3Count = 0;



/*********************************************************************************************************
** Function name:       UART0_Init
** Descriptions:        ��Ĭ��ֵ��ʼ������0�����ź�ͨѶ����������Ϊ8λ����λ��1λֹͣλ������żУ��
** input parameters:    ��
** output parameters:   ��
** Returned value:      ��
*********************************************************************************************************/
void UART0_Init (void)
{
	uint16_t usFdiv;
	LPC_PINCON->PINSEL0 |= (1 << 4);             /* Pin P0.2 used as TXD0 (Com0) */
	LPC_PINCON->PINSEL0 |= (1 << 6);             /* Pin P0.3 used as RXD0 (Com0) */
	LPC_UART0->LCR  = 0x83;                      /* �������ò�����               */

 //	LPC_UART0->FDR = 0x00000085; // c��  ��� LPC17xx-User-Manual_0[1].05 �� ���  311
  					   //���������� �� 8 �������� �� 5 
//  	usFdiv = 4;

	usFdiv = (FPCLK / 16) / UART0_BPS;           /* ���ò�����                   */
	LPC_UART0->DLM  = usFdiv / 256;
	LPC_UART0->DLL  = usFdiv % 256; 
	LPC_UART0->LCR  = 0x03;                      /* ����������                   */
	LPC_UART0->FCR  = 0x07;
}
void UART1_Init_temp (void)
{
	uint16_t usFdiv;
	LPC_PINCON->PINSEL4 |= (2 << 0);             /* Pin P2.0 used as TXD0 (Com0) */
	LPC_PINCON->PINSEL4 |= (2 << 2);             /* Pin P2.1 used as RXD0 (Com0) */
	LPC_UART1->LCR  = 0x83;                      /* �������ò�����               */
	usFdiv = (FPCLK / 16) / UART1_BPS;           /* ���ò�����                   */
	LPC_UART1->DLM  = usFdiv / 256;
	LPC_UART1->DLL  = usFdiv % 256; 
	LPC_UART1->LCR  =  0x03;                      /* ����������                   */
	LPC_UART1->FCR  = 0x07;
}

void UART2_Init (void)
{
	uint16_t usFdiv;
	LPC_PINCON->PINSEL0 |= (1 << 20);             /* Pin P0.10 used as TXD2 (Com2) */
	LPC_PINCON->PINSEL0 |= (1 << 22);             /* Pin P0.11 used as RXD2 (Com2) */
	LPC_SC->PCONP = LPC_SC->PCONP|(1<<24);	      /*����UART2��Դ����λ	           */

	LPC_UART2->LCR  = 0x83;                       /* �������ò�����                */
	usFdiv = (FPCLK / 16) / 9600;           			/* ���ò�����                    */
	LPC_UART2->DLM  = usFdiv / 256;
	LPC_UART2->DLL  = usFdiv % 256; 
	LPC_UART2->LCR  = 0x03;                       /* ����������                    */
	LPC_UART2->FCR  = 0x07;
}


void UART3_Init (void)
{
	uint16_t usFdiv;
    /* UART0 */
    LPC_PINCON->PINSEL1 |= (3 << 18);             /* Pin P0.25 used as TXD0 (Com0) */
    LPC_PINCON->PINSEL1 |= (3 << 20);             /* Pin P0.26 used as RXD0 (Com0) */
    	LPC_SC->PCONP = LPC_SC->PCONP|(1<<25);	      /*����UART2��Դ����λ	           */  

  	LPC_UART3->LCR  = 0x83;                      /* �������ò�����               */
    usFdiv = (FPCLK / 16) / UART3_BPS;           /* ���ò�����                   */
    LPC_UART3->DLM  = usFdiv / 256;
    LPC_UART3->DLL  = usFdiv % 256; 
    LPC_UART3->LCR  =   UART_LCR; 
 	LPC_UART3->FCR  = 0x07;
}

void UART2_InitSet (unsigned int speed, unsigned int SetLsr)
{
	uint16_t usFdiv;

	LPC_PINCON->PINSEL0 |= (1 << 20);             /* Pin P0.10 used as TXD2 (Com2) */
	LPC_PINCON->PINSEL0 |= (1 << 22);             /* Pin P0.11 used as RXD2 (Com2) */

	LPC_SC->PCONP = LPC_SC->PCONP|(1<<24);	      /*����UART2��Դ����λ	           */

	LPC_UART2->LCR  = 0x83;                       /* �������ò�����                */
	usFdiv = (FPCLK / 16) / speed;           			/* ���ò�����                    */
	LPC_UART2->DLM  = usFdiv / 256;
	LPC_UART2->DLL  = usFdiv % 256; 
	LPC_UART2->LCR  = SetLsr;                       /* ����������                    */
	LPC_UART2->FCR  = 0x07;

}


void UART3_InitSet (unsigned int speed, unsigned int SetLsr)
{
		uint16_t usFdiv;
    /* UART0 */
    LPC_PINCON->PINSEL1 |= (3 << 18);             		/* Pin P0.25 used as TXD0 (Com0) */
    LPC_PINCON->PINSEL1 |= (3 << 20);             		/* Pin P0.26 used as RXD0 (Com0) */
  
   	LPC_SC->PCONP = 		LPC_SC->PCONP|(1<<25);	      /*����UART2��Դ����λ	           */  
  	LPC_UART3->LCR  = 	0x83;                      		/* �������ò�����               */
    usFdiv = 						(FPCLK / 16) / speed;         /* ���ò�����                   */
    LPC_UART3->DLM  = 	usFdiv / 256;
    LPC_UART3->DLL  = 	usFdiv % 256; 
    LPC_UART3->LCR  =  	SetLsr; 
	LPC_UART3->FCR  = 	0x07;
}




void UART_InitSet (unsigned int Num,unsigned int Speed, unsigned int SetLsr)
{
	uint16_t usFdiv;

    usFdiv = ((FPCLK  / 16) / Speed) +1;          
    //usFdiv = ((FPCLK  / 4) / Speed) + 1 ;          

	if (Num == 0) 
	{
		LPC_PINCON->PINSEL0 |= (1 << 4);             /* Pin P0.2 used as TXD0 (Com0) */
		LPC_PINCON->PINSEL0 |= (1 << 6);             /* Pin P0.3 used as RXD0 (Com0) */
		LPC_UART0->LCR  = 0x83;                      /* �������ò�����               */
	 //	LPC_UART0->FDR = 0x00000085; 				// c��  ��� LPC17xx-User-Manual_0[1].05 �� ���  311
									 				//���������� �� 8 �������� �� 5 
	//  	usFdiv = 4;
		LPC_UART0->DLM  = usFdiv / 256;
		LPC_UART0->DLL  = usFdiv % 256; 
		LPC_UART0->LCR  = SetLsr;                      /* ����������                   */
		LPC_UART0->FCR  = 0x07;
	}
	if (Num == 1)
	{
		LPC_PINCON->PINSEL4 |= (2 << 0);             /* Pin P2.0 used as TXD0 (Com0) */
		LPC_PINCON->PINSEL4 |= (2 << 2);             /* Pin P2.1 used as RXD0 (Com0) */
	
		LPC_UART1->LCR  = 0x83;                      /* �������ò�����               */
		LPC_UART1->DLM  = usFdiv / 256;
		LPC_UART1->DLL  = usFdiv % 256; 
		LPC_UART1->LCR  = SetLsr;                      /* ����������                   */
		LPC_UART1->FCR  = 0x07;
	}
	if (Num == 2)
	{
		LPC_PINCON->PINSEL0 |= (1 << 20);             /* Pin P0.10 used as TXD2 (Com2) */
		LPC_PINCON->PINSEL0 |= (1 << 22);             /* Pin P0.11 used as RXD2 (Com2) */
		LPC_SC->PCONP = LPC_SC->PCONP|(1<<24);	      /*����UART2��Դ����λ	           */
		LPC_UART2->LCR  = 0x83;                      /* �������ò�����               */
		LPC_UART2->DLM  = usFdiv / 256;
		LPC_UART2->DLL  = usFdiv % 256; 
		LPC_UART2->LCR  = SetLsr;                      /* ����������                   */
		LPC_UART2->FCR  = 0x07;
	}
	if (Num == 3)
	{
		LPC_PINCON->PINSEL1 |= (3 << 18);             		/* Pin P0.25 used as TXD0 (Com0) */
		LPC_PINCON->PINSEL1 |= (3 << 20);             		/* Pin P0.26 used as RXD0 (Com0) */
		LPC_SC->PCONP = 		LPC_SC->PCONP|(1<<25);	      /*����UART2��Դ����λ	           */  
		LPC_UART3->LCR  = 0x83;                      /* �������ò�����               */
		LPC_UART3->DLM  = usFdiv / 256;
		LPC_UART3->DLL  = usFdiv % 256; 
		LPC_UART3->LCR  = SetLsr;                      /* ����������                   */
		LPC_UART3->FCR  = 0x07;
	}
}







 



















/*********************************************************************************************************
** Function name:       UART0_SendByte
** Descriptions:        �Ӵ���0��������
** input parameters:    data: ���͵�����
** output parameters:   ��
** Returned value:      ��
*********************************************************************************************************/
int UART0_SendByte (int ucData)
{
	while (!(LPC_UART0->LSR & 0x20));
    return (LPC_UART0->THR = ucData);

}






/*----------------------------------------------------------------------------
  Read character from Serial Port   (blocking read)
 *----------------------------------------------------------------------------*/
int UART0_GetChar (void) 
{
  	while (!(LPC_UART0->LSR & 0x01));
  	return (LPC_UART0->RBR);
}
/*----------------------------------------------------------------------------
  Read character from Serial Port   (blocking read)
 *----------------------------------------------------------------------------*/
int UART1_GetChar (void) 
{
  	while (!(LPC_UART1->LSR & 0x01));
  	return (LPC_UART1->RBR);
}

/*----------------------------------------------------------------------------
  Read character from Serial Port   (blocking read)
 *----------------------------------------------------------------------------*/
int UART2_GetChar (void) 
{
  	while (!(LPC_UART2->LSR & 0x01));
  	return (LPC_UART2->RBR);
}
/*----------------------------------------------------------------------------
  Read character from Serial Port   (blocking read)
 *----------------------------------------------------------------------------*/
int UART3_GetChar (void) 
{
  	while (!(LPC_UART3->LSR & 0x01));
  	return (LPC_UART3->RBR);
}

int UART0_Chek (void) 
{
  	if (LPC_UART0->LSR & 0x01) return 1; else return 0;
}

int UART1_Chek (void) 
{
  	if (LPC_UART1->LSR & 0x01)return 1; else return 0;
}


int UART2_Chek (void) 
{

  	if (LPC_UART2->LSR & 0x01)return 1; else return 0;
}

int UART3_Chek (void) 
{
  	if (LPC_UART3->LSR & 0x01)return 1; else return 0;
 
}






void UART0_SendString (char *s) 
{
  	while (*s != 0) 
	{
   		UART0_SendByte(*s++);
	}
}





int UART2_SendByte (int ucData)
{
	while (!(LPC_UART2->LSR & 0x20));
    return (LPC_UART2->THR = ucData);
}



void UART0_SendChar(uint16_t disp)
{
	uint16_t dispbuf[4];
	uint8_t i;

	dispbuf[3] = disp%10 + '0';
	dispbuf[2] = disp/10%10 + '0';
	dispbuf[1] = disp/10/10%10 + '0';
	dispbuf[0] = disp/10/10/10%10 + '0';
	for(i=0;i<4;i++)
		UART0_SendByte(dispbuf[i]);	
}



void Concol (void )
{
	if (OutBufConCount == 0)	
	{

		if (ConOutPnt != ConOutCur)
			if (LPC_UART0->LSR & 0x20)
			{
				ConOutCur++;
				ConOutCur = ConOutCur & 0x3ff; 
				SetDeUART0 ();
				LPC_UART0->THR = OutCon[ConOutCur];
			}
	}
	if (LPC_UART0->LSR & 0x01)
		{
			ConInCur++;
			ConInCur = ConInCur & 0x3ff; 
			InCon[ConInCur] = (LPC_UART0->RBR);
		}
	
	if (!(LPC_UART0->LSR & 0x40)) SetDeUART0 (); else ClrDeUART0() ;     			//���������� 485 

} 


void Concol1 (void )
{
	//if (OutBufCon1Count == 0)	
	if (Time_UART == 0)
	{
		if (ConOutPnt1 != ConOutCur1)
			if (LPC_UART1->LSR & 0x20)
			{
				ConOutCur1++;
				ConOutCur1 = ConOutCur1 & 0x3ff; 
				LPC_UART1->THR = OutCon1[ConOutCur1];
			}
	if (!(LPC_UART1->LSR & 0x40))  Gyro.PinReg  |=  PinRegBitTXE; else Gyro.PinReg  &=  ~PinRegBitTXE;
	}
	else if (OutBufCon1Count == 0)
	{
		
		Gyro.PinReg  |=  PinRegBitTXE;
	}
		
	if (LPC_UART1->LSR & 0x01)
	{//LoopOn
		ConInCur1++;
		ConInCur1 = ConInCur1 & 0x3ff; 
		InCon1[ConInCur1] = (LPC_UART1->RBR);
	}
} 

void Concol1Fast (void )
{
	if (OutBufCon1Count == 0)	
	{
		while((ConOutPnt1 != ConOutCur1) && (LPC_UART1->LSR & 0x20))
		{
				ConOutCur1++;
				ConOutCur1 = ConOutCur1 & 0x3ff; 
				SetDeUART1 ();	
				LPC_UART1->THR = OutCon1[ConOutCur1];
		}
	}
	while (LPC_UART1->LSR & 0x01)
	{
		ConInCur1++;
		ConInCur1 = ConInCur1 & 0x3ff; 
		InCon1[ConInCur1] = (LPC_UART1->RBR);
	}
	if (!(LPC_UART1->LSR & 0x40)) SetDeUART1 (); else ClrDeUART1() ;     			//���������� 485 
} 




void Concol2 (void )
{
	if (OutBufCon2Count == 0)	
	{
		if (ConOutPnt2 != ConOutCur2)
			if (LPC_UART2->LSR & 0x20)
			{
				ConOutCur2++;
				ConOutCur2 = ConOutCur2 & 0x3ff; 
				SetDeUART2 ();	
				LPC_UART2->THR = OutCon2[ConOutCur2];
			}
	}
	if (LPC_UART2->LSR & 0x01)
	{
		ConInCur2++;
		ConInCur2 = ConInCur2 & 0x3ff; 
		InCon2[ConInCur2] = (LPC_UART2->RBR);
	}
	if (!(LPC_UART2->LSR & 0x40)) SetDeUART2 (); else ClrDeUART2() ;     			//���������� 485 
} 





void Concol3 (void )
{
	if (OutBufCon3Count == 0)	
	{
		if (ConOutPnt3 != ConOutCur3)
			if (LPC_UART3->LSR & 0x20)
			{
				ConOutCur3++;
				ConOutCur3 = ConOutCur3 & 0x3ff; 
				SetDeUART3 ();	
				LPC_UART3->THR = OutCon3[ConOutCur3];
			}
	}
	if (LPC_UART3->LSR & 0x01)
	{
		ConInCur3++;
		ConInCur3 = ConInCur3 & 0x3ff; 
		InCon3[ConInCur3] = (LPC_UART3->RBR);
	}
	
	if (!(LPC_UART3->LSR & 0x40)) SetDeUART3 (); else ClrDeUART3() ;     			//���������� 485 
} 



void Concol2M (void )
{
	if (OutBufCon2Count == 0)	
	{
		if (ConOutPnt2M != ConOutCur2M)
			if (LPC_UART2->LSR & 0x20)
			{
				ConOutCur2++;
				ConOutCur2 = ConOutCur2 & 0x3ff; 
				SetDeUART2 ();	
				LPC_UART2->THR = OutCon2[ConOutCur2];
			}
	}
	if (LPC_UART2->LSR & 0x01)
	{
		ConInCur2++;
		ConInCur2 = ConInCur2 & 0x3ff; 
		InCon2[ConInCur2] = (LPC_UART2->RBR);
	}
	if (!(LPC_UART2->LSR & 0x40)) SetDeUART2 (); else ClrDeUART2() ;     			//���������� 485 
} 






void WriteCon (char *s)
{
 	OutBufConCount = 0;
	while (*s != 0) 
	{
		ConOutPnt++;
		ConOutPnt = ConOutPnt & 0x3ff; 
		OutCon[ConOutPnt] = (*s++);
	}
}

void WriteCon1 (char *s) 
{
 	OutBufCon1Count = 0;
	while (*s != 0) 
	{
		ConOutPnt1++;
		ConOutPnt1 = ConOutPnt1 & 0x3ff; 
		OutCon1[ConOutPnt1] = (*s++);
	}
}

void WriteConN (char *s, unsigned int N) 
{
 	OutBufCon1Count = 0;
 	
	while (N != 0) 
	{
		N--;
		ConOutPnt1++;
		ConOutPnt1 = ConOutPnt1 & 0x3ff; 
		OutCon1[ConOutPnt1] = (*s++);
	}
	Time_UART=Gyro.DropDelayGLD;
	OutBufCon1Count = 100;
}


void WriteCon0N (char *s, unsigned int N) 
{
 	OutBufConCount = 0;
	while (N != 0) 
	{
		N--;
		ConOutPnt++;
		ConOutPnt = ConOutPnt & 0x3ff; 
		OutCon[ConOutPnt] = (*s++);
	}
	OutBufConCount = 10;
}


void WriteCon2 (char *s) 
{
 	OutBufCon2Count = 0;
	while (*s != 0) 
	{
		ConOutPnt2++;
		ConOutPnt2 = ConOutPnt2 & 0x3ff; 
		OutCon2[ConOutPnt2] = (*s++);
	}
}
void WriteCon3 (char *s) 
{
 	OutBufCon3Count = 0;
	while (*s != 0) 
	{
		ConOutPnt3++;
		ConOutPnt3 = ConOutPnt3 & 0x3ff; 
		OutCon3[ConOutPnt3] = (*s++);
	}
}




void 	WriteConF (char *s, unsigned int Num)
{
		if (Num == 0) WriteCon(s);
		if (Num == 1) WriteCon1(s);
		if (Num == 2) WriteCon2(s);
		if (Num == 2) WriteCon3(s);

}




void WriteConByte (unsigned int In) 
{
	ConOutPnt++;
	ConOutPnt = ConOutPnt & 0x3ff; 
	OutCon[ConOutPnt] = In;
}

void WriteCon1Byte (unsigned int In) 
{
	ConOutPnt1++;
	ConOutPnt1 = ConOutPnt1 & 0x3ff; 
	OutCon1[ConOutPnt1] = In;
}


void WriteCon2Byte (unsigned int temp) 
{
	ConOutPnt2++;
	ConOutPnt2 = ConOutPnt2 & 0x3ff; 
	OutCon2[ConOutPnt2] = temp;
}

void WriteCon3Byte (unsigned int temp) 
{
	ConOutPnt3++;
	ConOutPnt3 = ConOutPnt3 & 0x3ff; 
	OutCon3[ConOutPnt3] = temp;
}





void WriteConByteF (unsigned int In,unsigned int Num ) 
{
		if (Num == 0) WriteConByte(In);
		if (Num == 1) WriteCon1Byte(In);
		if (Num == 2) WriteCon2Byte(In);
		if (Num == 3) WriteCon3Byte(In);
	
}









int ReadCon (char *s) 
{ 
	int i = 0;
	while (ConInPnt != ConInCur) 
	{
	i++;
	ConInPnt++;
	ConInPnt = ConInPnt & 0x3ff; 
	(*s++) = InCon[ConInPnt] ;
 	}
	(*s++) = 0;
	return i;
}

int ReadCon1 (char *s) 
{ 
	int i = 0;
	while (ConInPnt1 != ConInCur1) 
	{
	i++;
	ConInPnt1++;
	ConInPnt1 = ConInPnt1 & 0x3ff; 
	(*s++) = InCon1[ConInPnt1] ;
 	}
	(*s++) = 0;
	return i;
}

int ReadCon2 (char *s) 
{ 
	int i = 0;
	while (ConInPnt2 != ConInCur2) 
	{
		i++;
		ConInPnt2++;
		ConInPnt2 = ConInPnt2 & 0x3ff; 
		(*s++) = InCon2[ConInPnt2] ;
 	}
	(*s++) = 0;
	return i;

}


int ReadCon3 (char *s) 
{ 
	int i = 0;
	while (ConInPnt3 != ConInCur3) 
	{
		i++;
		ConInPnt3++;
		ConInPnt3 = ConInPnt3 & 0x3ff; 
		(*s++) = InCon3[ConInPnt3] ;
 	}
	(*s++) = 0;
	return i;

}





int ReadChekCon (char *s) 
{ 
	int i = 0;
	int ConInPntTemp = ConInPnt;
	while (ConInPntTemp != ConInCur) 
	{
		i++;
		ConInPntTemp++;
		ConInPntTemp = ConInPntTemp & 0x3ff; 
		(*s++) = InCon[ConInPntTemp] ;
 	}
	(*s++) = 0;
	return i;
}

int ReadChekCon1 (char *s) 
{ 
	int i = 0;
	int ConInPntTemp = ConInPnt1;
	while (ConInPntTemp != ConInCur1) 
	{
		i++;
		ConInPntTemp++;
		ConInPntTemp = ConInPntTemp & 0x3ff; 
		(*s++) = InCon1[ConInPntTemp] ;
 	}
	(*s++) = 0;
	return i;
}




int ReadChekCon2 (char *s) 
{ 	
	int i = 0;
	int ConInPntTemp = ConInPnt2;
	while (ConInPntTemp != ConInCur2) 
	{
		i++;
		ConInPntTemp++;
		ConInPntTemp = ConInPntTemp & 0x3ff; 
		(*s++) = InCon2[ConInPntTemp] ;
 	}
	(*s++) = 0;
	return i;
}


int ReadChekCon3 (char *s) 
{ 	
	int i = 0;
	int ConInPntTemp = ConInPnt3;
	while (ConInPntTemp != ConInCur3) 
	{
		i++;
		ConInPntTemp++;
		ConInPntTemp = ConInPntTemp & 0x3ff; 
		(*s++) = InCon3[ConInPntTemp] ;
 	}
	(*s++) = 0;
	return i;
}






int ChekInCon ( void )	{if (ConInPnt != ConInCur) return 1; else return 0;}
int ChekInCon1 ( void ) {if (ConInPnt1 != ConInCur1) return 1; else return 0;}
int ChekInCon2 ( void ) {if (ConInPnt2 != ConInCur2) return 1; else return 0;}
int ChekInCon3 ( void ) {if (ConInPnt3 != ConInCur3) return 1; else return 0;}

int ChekOutCon ( void )		{if (!(LPC_UART0->LSR & 0x40)) return 1; else return 0;}
int ChekOutCon1 ( void )	{if (!(LPC_UART1->LSR & 0x40)) return 1; else return 0;}
int ChekOutCon2 ( void )	{if (!(LPC_UART2->LSR & 0x40)) return 1; else return 0;}
int ChekOutCon3 ( void )	{if (!(LPC_UART3->LSR & 0x40)) return 1; else return 0;}




void Delay(int t)
{
}


void SetDeUART0 (void)	{if ((PortEUART0 & (PinEUART0)) == 0) 	{PortEUART0   |= (PinEUART0); Delay(10);}	}
void ClrDeUART0 (void)	{if ((PortEUART0 & (PinEUART0)))				{ Delay(10); PortEUART0   &= (~(PinEUART0));}}

void SetDeUART1 (void)	{if ((PortEUART1 & (PinEUART1)) == 0) 	{PortEUART1   |= (PinEUART1); Delay(10);}	}
void ClrDeUART1 (void)	{if ((PortEUART1 & (PinEUART1)))				{ Delay(10); PortEUART1   &= (~(PinEUART1));}}



void SetDeUART2 (void)	{if ((PortEUART2 & (PinEUART2)) == 0) {PortEUART2   |= (PinEUART2); Delay(10);}}
void ClrDeUART2 (void)	{if ((PortEUART2 & (PinEUART2)))			{Delay(10); PortEUART2   &= (~(PinEUART2));}}


void SetDeUART3 (void)	{if ((PortEUART3 & (PinEUART3)) == 0)	{PortEUART3   |= (PinEUART3); Delay(10);}}
void ClrDeUART3 (void)	{if ((PortEUART3 & (PinEUART3)))			{Delay(10);PortEUART3   &= (~(PinEUART3));}}





