#include "MTimer.h"
#include "LPC17xx.h"
#include "MTimer.h"
#include "vibro.h"
#include "QEI.h"
#include "Global.h"
#include "SPI.h"
#include "InputOutput.h"

unsigned int CountV64=0;
unsigned int CountV31=0;
unsigned int CountV255=0;
unsigned int f;
int loop=0;

/////////////////////////////////////////////////////
/////////////////////EVENT///////////////////////////
/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
///////////////////// 1Hz ///////////////////////////
/////////////////////////////////////////////////////
void Event_1Hz(void)// событие раз в 1 Гц
{   int i,t;
    if (Event1Hz)	
    {  
       Gyro.Rate1_Event = 1; 
       Event1Hz--;
       Time1Hz++;
       Discharg ();
       BackLight();
     }
}
/////////////////////////////////////////////////////
///////////////////// 1kHz //////////////////////////
/////////////////////////////////////////////////////
void Event_1KHz(void)// событие раз в 1 кГц
{
    if (Event1K) 
    {
        Event1K --;
        Time1K++;//первый ++ работает каждые 125 (event100kHz)второй был в 100 кГц
 
        if (Time1K == 1000) 
        {
            Time1K = 0;
            Event1Hz ++;
        }
    }
}
void Event_500Hz(void)// событие раз в 500 Гц
{
	if(Event500Hz)
	{   Event500Hz--;
		Gyro.Event_500Hz=1;// Event 500Гц  выдачи данных для постройки графика управления вибро
	}
}


void Event_250Hz(void)// событие раз в 500 Гц
{
	if(Event250Hz)
	{   
		Event250Hz--;
	    Gyro.EventMOD=1;// Event 500Гц  выдачи данных для постройки графика управления вибро
	}
}
/////////////////////////////////////////////////////
///////////////////// 100kHz //////////////////////////
/////////////////////////////////////////////////////
void Event_100KHz(void)// событие раз в 100 кГц
{
        
    if (Event100K)	{
       
        Event100K --;
      
        if (OutBufCon1Count)OutBufCon1Count--;  // обратный отсчет для управления ногой и формирование задержки на выдачу
       
         PinCheng();	// чтение регистра состояния выводов(вибро, полсветка, поджиг, LED) и управление выводами.
    }
}
/////////////////////////////////////////////////////
//////////////////vibro EVENT////////////////////////
/////////////////////////////////////////////////////
void Event_Vibro(void)// событие от вибр
{
    if (EventVibro)	{
        EventVibro --;
    }
}
/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
/////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////TIMER1////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
/////////////////////инициализация таймера 1 /////////////////////////
//////////////////////////////////////////////////////////////////////

unsigned int Init_TIM1 (unsigned int TimerInterval )
{
    LPC_TIM1->MR0 = TimerInterval;
    LPC_TIM1->MCR = 3;				/* Interrupt and Reset on MR1 */
    NVIC_EnableIRQ(TIMER1_IRQn);
}


//////////////////////////////////////////////////////////////////////
/////////////////////////включение таймера 1//////////////////////////
//////////////////////////////////////////////////////////////////////
void enable_timer1( void )
{
    LPC_TIM1->TCR = 1;
    return;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////TIMER2//////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
/////////////////////инициализация таймера 2 /////////////////////////
//////////////////////////////////////////////////////////////////////
unsigned int Init_TIM2 (void)
{
    LPC_TIM2->MR0 = 257;
    LPC_TIM2->MCR = 3;				/* Interrupt and Reset on MR0 */
    NVIC_EnableIRQ(TIMER2_IRQn);
    return 1;
}

//////////////////////////////////////////////////////////////////////
/////////////////////////включение таймера 2//////////////////////////
//////////////////////////////////////////////////////////////////////
void enable_timer2(void)
{
    LPC_TIM2->TCR = 1;
    LPC_TIM2->TCR = 0x01;
}


//////////////////////////////////////////////////////////////////////
/////////////////////////прерывание таймера 1//////////////////////////
//////////////////////////////////////////////////////////////////////
__irq void TIMER1_IRQHandler (void)//13.27 kHz
{   // LoopOn
    ResetCS(ADC);					  	 	//prepare ADC for sampling
    SetDAC(DAC);

    CountV255++;							// инкремент счеттчика
    CountV255 &= 0xff;						// ОБРЕЗАНИЕ СЧЕТЧИКА 
    CountV64 = CountV255 & 0x3f;
    CountV31 = CountV255 & 0x1f;			// малый счетчик
   
    D_QEI();								//чтение данных по счетчику
    cheng();		             			// выставление флагов в 32 тактном цикле.


    SetCS(ADC);					    		//start ADC sampling
    ResetDAC(DAC);
	SPI_Exchange(); 						//Чтение ADC_SPI

    LPC_TIM1->IR = 1;
     
       // LoopOff
     
}

///////////////////////////////////////////////////////////////////////
/////////////////////////прерывание таймера 2//////////////////////////
///////////////////////////////////////////////////////////////////////
__irq void TIMER2_IRQHandler (void)
{  
    LPC_TIM2->IR = 1;
    Global_Time++;
    if(Time_UART) Time_UART--;
    Time_vibro++;
    Gyro.VibroOutF=1;
    Event100K ++;  
    Time500Hz++;
    Time100K++;
    Time250Hz++;
        if (Time100K == 100)
         {  
            Time100K = 0;
            Event1K ++;
       
         }
        if (Time500Hz > 200) 
         {  
            Time500Hz -= 200;
            Event500Hz ++; 
             
         }
        if (Time250Hz > 400) 
         { 
            Time250Hz -= 400;
            Event250Hz ++;
         }
}