#include "stdlib.h"
//#include "math.h"
#include "LPC17xx.h"
#include "Global.h"
int tempNH,tempNL;
unsigned int Rate_Flag;
unsigned int CountBuFFIn;
unsigned int N=0,CRC_N;
unsigned int Param1=0;
unsigned int Param2=0;
unsigned int Param3=0;
unsigned int Param4=0;
unsigned int Consol=123;
unsigned int TempParam=1;
unsigned int CountParam=0;

int ttemp;
int OLDDAC=0;

unsigned int pDestT ; 
GyroParam *Flash;
 ///////////////flah and boot///////////
void GoBoot(void)
  {
 	/*	Prepare Sectors to be flashed */
    NVIC_DisableIRQ(TIMER1_IRQn);
    NVIC_DisableIRQ(TIMER2_IRQn);
 	NVIC_DisableIRQ(TIMER3_IRQn);
 	NVIC_DisableIRQ(EINT3_IRQn);
    SystemInitDef();
    vIAP_ReinvokeISP();
  } 

void DropDelay(void)
{   
    Gyro.DropDelayGLD = DropDelayGLD_0;
    switch(Gyro.My_Addres) {
    case 1: Gyro.DropDelayGLD = DropDelayGLD_1;	 	  break;  
    case 2: Gyro.DropDelayGLD = DropDelayGLD_2; 	  break;    
    case 3: Gyro.DropDelayGLD = DropDelayGLD_3;       break;   
  }
  
}

void WriteFlash(void)
  {
 	 
    NVIC_DisableIRQ(TIMER1_IRQn);
    NVIC_DisableIRQ(TIMER2_IRQn);
 	NVIC_DisableIRQ(TIMER3_IRQn);
 	NVIC_DisableIRQ(EINT3_IRQn);
 
   SystemInitDef();
   WriteCon("\r\n Start Prepare Sectors");
   if(u32IAP_PrepareSectors(18, 21) == IAP_STA_CMD_SUCCESS)
     {
      WriteCon("\r\nPrepare Sectors OK");
      WriteCon("\r\n Start Erase");
      u32IAP_EraseSectors(IMG_START_SECTOR, IMG_END_SECTOR);
      WriteCon("\r\n AND Erase");
     }
     else WriteCon("\r\nPrepare Sectors ERROR");  
          SystemInit1(); 
          Gyro.FlashMod = 0;
     }
  
 void ReadFlash ( void)
 {
  Gyro.FlashMod = 0;
  WriteCon("\r\n Pirivet Flash");
  pDestT= (unsigned int) (0x10000);
  Flash = (GyroParam*) pDestT;
  GyroP = *(Flash);
  sprintf((Time)," dffddfd <%07d> ",	GyroP.Str.K_WP_rst_heating);
  WriteCon(Time);
 }
 ///////////////end flah and boot///////////
 void M_RateA(void)
 {  
    switch(Gyro.ModeOut) {
    case 1: if(Gyro.Rate1_Event ) 				CMD_Rate();  		 	  break;  
    case 2: if(Gyro.Reper_Event )				CMD_Rate2(); 			  break;    //Gyro.Reper_Event выставляется при переходе синуса из - в + 
    case 3: if(Gyro.Event_500Hz ) 				CMD_Delta_PS();           break;   
    case 4: if(Gyro.EXT_Latch   ) 				CMD_Delta_PS();           break;   
    case 5: if(Gyro.Event_500Hz ) 				CMD_Delta_Bins();         break;   
    case 6: if(Gyro.B_Delta_EventEXT ) 			CMD_B_Delta();            break;      	
    case 7: if(Gyro.Event_500Hz ) 				CMD_B_Delta();            break;      	
    }
 }
 
void CMD_M_Param_R(void)
{
   unsigned int NP;
   unsigned int Param;
   BuffTemp[0] =  Gyro.SOC_Out;
   BuffTemp[1] =  Gyro.My_Addres;
   
   NP    = BuffTemp[3]; 
   
   Param = GyroP.Array[NP];
   
   BuffTemp[2] =(Param >> 8) & 0xff;//старший байт требуемого параметра
   BuffTemp[3] =(Param >> 0) & 0xff;//младший байт требуемого параметра
   
   Check(BuffTemp, 6);
   WriteConN (BuffTemp,6);
}
void CMD_M_Param_W(void)
{
   unsigned int NP;
   unsigned int Param;
   
   NP     =  BuffTemp[3];
   Param  = (BuffTemp[4]<<8);
   Param |=  BuffTemp[5];
 
  GyroP.Array[NP] = Param;
     
   
   BuffTemp[0] =  Gyro.SOC_Out;
   BuffTemp[1] =  Gyro.My_Addres;
   BuffTemp[2] =  Gyro.CMD_In;
   BuffTemp[3] =  0x00;//старший байт требуемого параметра
   
   Check(BuffTemp, 6);
   WriteConN (BuffTemp,6);
}
void CMD_Maintenance(void)
{
   
    Gyro.DropDelayGLD = DropDelayGLD_0;//задержка на выдачу 45 микросекунд для любого адреса ГЛД
    BuffTemp[0] =  Gyro.SOC_Out;
    BuffTemp[1] =  Gyro.My_Addres;
    BuffTemp[2] =  Gyro.Firmware_Version;
    BuffTemp[3] =  Gyro.GLD_Serial;
    BuffTemp[4]=0x00;
    BuffTemp[5]=0x00;
    Check(BuffTemp, 8);
    WriteConN (BuffTemp,8);
   
}
void CMD_B_Delta(void)
{ 	
	//Gyro.B_Delta_Event500=0;
	Gyro.Event_500Hz=0;
 	Gyro.B_Delta_EventEXT=0;	
 	unsigned int Temp;
	BuffTemp[ 0] = Gyro.SOC_Out;
    BuffTemp[ 1] = Gyro.My_Addres;
    
    Temp = Gyro.CuruAngle;
    Gyro.CuruAngle = 0;
    BuffTemp[ 2] =(Temp >> 16) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 3] =(Temp >>  8) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 4] =(Temp >>  0) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 5] = 0x00000000;
    Check(BuffTemp, 8);
    WriteConN (BuffTemp,8);
}

void CMD_Delta_Bins(void)
{   Gyro.Event_500Hz=0;
	//Gyro.Delta_Bins_Event500=0;
	unsigned int Temp;
	BuffTemp[ 0] = Gyro.SOC_Out;
    BuffTemp[ 1] = Gyro.My_Addres;
    
    Temp = Gyro.CuruAngle;
    Gyro.CuruAngle = 0;

    BuffTemp[ 2] =(Temp >> 24) & 0xff;//старший байт разности счетчиков
    BuffTemp[ 3] =(Temp >> 16) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 4] =(Temp >>  8) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 5] =(Temp >>  0) & 0xff;//младший байт разности счетчиков
    BuffTemp[ 6] = 0x0000;
    Check(BuffTemp, 9);
    WriteConN (BuffTemp,9);
}  
void CMD_Delta_PS(void)
{   
    //Gyro.Delta500_Event=0;
    Gyro.EXT_Latch=0;
    Gyro.Event_500Hz=0;
    unsigned int Temp;
	BuffTemp[ 0] = Gyro.SOC_Out;
    BuffTemp[ 1] = Gyro.My_Addres;
    
    Temp = Gyro.CuruAngle;
    Gyro.CuruAngle = 0;

    BuffTemp[ 2] =(Temp >> 8) & 0xff;//старший байт разности счетчиков
    BuffTemp[ 3] =(Temp >> 0) & 0xff;//младший байт разности счетчиков
    
    BuffTemp[ 4] = CountParam;
     switch(CountParam) {
  
    //F_ras  
     case 0:
           Temp = Gyro.F_ras;
           BuffTemp[5] = (Temp >> 8) & 0xff;
     break;  
     
     case 1:
           BuffTemp[5] = (Temp >> 0) & 0xff;
     break; 
    
    
     
     //HFO
     case 2:
           Temp = 0;//HFO
           BuffTemp[5] = (Temp >> 8) & 0xff;
     break;     
     
     case 3:
           Temp = 0;//HFO
           BuffTemp[5] = (Temp >> 0) & 0xff;
     break;  
   
   
     
     //T_Vibro
     case 4:
           Temp = (unsigned int)((7680000*16/(Gyro.Frq>>12))); 
           BuffTemp[5] = (Temp >> 8) & 0xff;
     break;  
    
     case 5:
           BuffTemp[5] = (Temp >> 0) & 0xff;
     break; 
    
    
     
     //L_Vibro  
     case 6:
          Temp = (unsigned int)(((7680000*16/200) *Gyro.AmpPer /(Gyro.Frq>>12))); 
          BuffTemp[5]  =  (Temp >> 8) & 0xff;
 
     break;  
   
     case 7:
          BuffTemp[5]  =  (Temp >> 0) & 0xff;
     break;  
     
     
     
     //Напряжение на регуляторе периметра
     case 8:
          Temp = Spi.DAC_B /*- 0x7fff*/;
          BuffTemp[5] =  (Temp >> 8) & 0xff;
  
     break;  
   
     case 9:
          BuffTemp[5] =  (Temp >> 0) & 0xff;
     break;  
     
     
     
     //темпкратурный канал 0
     case 10:
          Temp = 100;
          BuffTemp[5] =  (Temp >> 8) & 0xff;

     break;  
    
     case 11:
         BuffTemp[5] =  (Temp >> 0) & 0xff;
     break;
     
       
       
     //f 
     case 12:
        Temp = Gyro.AD_Slow >> 16;
        BuffTemp[5] = (Temp >> 8) & 0xff;
   
     break;  
   
     case 13:
        BuffTemp[5] = (Temp >> 0) & 0xff;
     break; 
     
          
      
     //ток 1
     case 14:
        Temp = Gyro.In1;
        BuffTemp[5] = (Temp >> 8) & 0xff;//in1//2
        
     break;  
    
     case 15:
        BuffTemp[5] = (Temp >> 0) & 0xff;
     break; 
     
      
      
     //ток 2
     case 16:
        Temp = Gyro.In2;
        BuffTemp[5] = (Temp >> 8) & 0xff;
     break;  
     
     case 17:
        BuffTemp[5] = (Temp >> 0) & 0xff;//in2//3      
     break;  
     
     
     
     //разностный температурный канал Delta Temp
     case 18:
        Temp = Gyro.DeltaT;
        BuffTemp[5] = (Temp >> 8) & 0xff;//дельта
     break;  
    
     case 19:
        BuffTemp[5] = (Temp >> 0) & 0xff;
     break; 
     
     
     
     //температурный канал 5
     case 20:
        Temp = Gyro.Termo;//0xa4=164
        BuffTemp[5] =(Temp >> 8) & 0xff;//температура
    
     break;       
     
     case 21:
        BuffTemp[5] =(Temp >> 0) & 0xff;//ADC6   sesnsor 5
     break; 
     } 
    Check(BuffTemp, CRC_N);
    WriteConN (BuffTemp,CRC_N);  
   
    
    if(CountParam>20)CountParam=0;//зацикливания буфера от 0 до 21
    else CountParam++;
    
}

void CMD_Rate2(void)
{
	Gyro.Reper_Event=0;
    BuffTemp[ 0] = Gyro.SOC_Out;
    BuffTemp[ 1] = Gyro.My_Addres;


    BuffTemp[ 2] =(Gyro.CaunPlus >> 8) & 0xff;//старший байт счетчика +.
    BuffTemp[ 3] =(Gyro.CaunPlus >> 0) & 0xff;//младший байт счетчика +.
 
    BuffTemp[ 4] =(Gyro.CaunMin >> 8) & 0xff;//старший байт счетчика -.
    BuffTemp[ 5] =(Gyro.CaunMin >> 0) & 0xff;//младший байт счетчика -.
  
    Check(BuffTemp, 8);
    WriteConN (BuffTemp,8);
}

void CMD_Rate(void)
{ 
    Gyro.Rate1_Event=0;
   	unsigned int Temp;
	unsigned int OldCuruAngle;
    Gyro.Firmware_Version=0xff; /// промежуточная затычка
 

    BuffTemp[ 0] = Gyro.SOC_Out;
    BuffTemp[ 1] = Gyro.My_Addres;


    BuffTemp[ 2] =(Gyro.CaunPlus >> 8) & 0xff;//старший байт счетчика +.
    BuffTemp[ 3] =(Gyro.CaunPlus >> 0) & 0xff;//младший байт счетчика +.
 
    BuffTemp[ 4] =(Gyro.CaunMin >> 8) & 0xff;//старший байт счетчика -.
    BuffTemp[ 5] =(Gyro.CaunMin >> 0) & 0xff;//младший байт счетчика -.
 
 
    Temp=Gyro.CuruAngle;												//(0,28/с)
 
 
 //8 байт       + 4 байта от прошлых измерений
//Gyro.CuruAngle = Gyro.CuruAngle + OldCuruAngle; 								//(72 град/с)
/*  OldCuruAngle=Gyro.CuruAngle & 0xff;											//сохраняем 4 байта для след измирений
  Temp=Gyro.CuruAngle>>8; 		*/											//приводим к форме вывода 
 														
 	/*																			//(9 град/с)
OldCuruAngle=Gyro.CuruAngle & 0x1f;											//сохраняем 5 бит для след измирений 
Temp=Gyro.CuruAngle>>5;   */                                               //приводим к форме вывода
Gyro.CuruAngle = 0;
    BuffTemp[ 6] =(Temp >> 8) & 0xff;//старший байт разности счетчиков
    BuffTemp[ 7] =(Temp >> 0) & 0xff;//младший байт разности счетчиков

  
    Temp = Gyro.F_ras;
    BuffTemp[ 8] = (Temp >> 8) & 0xff;//расщипление частота
    BuffTemp[ 9] = (Temp >> 0) & 0xff;//

    BuffTemp[10] = (Temp >> 8) & 0xff;//выход регулятора гвч;
    BuffTemp[11] = (Temp >> 0) & 0xff;

    Temp = (Gyro.AD_Slow >> 16)- 0x7fff;
    BuffTemp[12]=(Temp >> 8) & 0xff;////
    BuffTemp[13]=(Temp >> 0) & 0xff;////

 
 	Temp = (unsigned int)((7680000*16/(Gyro.Frq>>12))); 
    BuffTemp[14]  =  (Temp >> 8) & 0xff;
    BuffTemp[15]  =  (Temp >> 0) & 0xff;

    BuffTemp[16] = 0xf;
    BuffTemp[17] = 0x02;
 

 	Temp = (unsigned int)(((7680000*16/200) *Gyro.AmpPer /(Gyro.Frq>>12))); 
    BuffTemp[18]  =  (Temp >> 8) & 0xff;
    BuffTemp[19]  =  (Temp >> 0) & 0xff;

    BuffTemp[20] = 0x00;
    BuffTemp[21] = 0x00;

    Temp = Spi.DAC_B - 0x7fff;
    BuffTemp[22] =  (Temp >> 8) & 0xff;
    BuffTemp[23] =  (Temp >> 0) & 0xff;

    Temp = Gyro.PLC_Delta >> 16;
    BuffTemp[24] = (Temp >> 8) & 0xff;
    BuffTemp[25] = (Temp >> 0) & 0xff;//
    
    Temp = Gyro.AD_Slow >> 16;
    BuffTemp[26] =  (Temp >> 8) & 0xff;
    BuffTemp[27] =  (Temp >> 0) & 0xff;
    
    Temp = Gyro.AD_Slow >> 16;
    BuffTemp[28] = (Temp >> 8) & 0xff;
    BuffTemp[29] = (Temp >> 0) & 0xff;
	
	Temp = Gyro.In1;
    BuffTemp[30] = (Temp >> 8) & 0xff;//in1//2
    BuffTemp[31] = (Temp >> 0) & 0xff;
    
 	Temp = Gyro.In2;
    BuffTemp[32] = (Temp >> 8) & 0xff;
    BuffTemp[33] = (Temp >> 0) & 0xff;//in2//3
	
	Temp = Gyro.DeltaT;
    BuffTemp[34] = (Temp >> 8) & 0xff;//дельта
    BuffTemp[35] = (Temp >> 0) & 0xff;
	//  Temp = 000;  
	Temp = Gyro.Termo;
    Temp = (0x7fff + Temp);///164

    BuffTemp[36] =(Temp >> 8) & 0xff;//температура
    BuffTemp[37] =(Temp >> 0) & 0xff;//ADC6   sesnsor 5

    BuffTemp[38] =0x00;
    BuffTemp[39] =0x00;
    BuffTemp[40] =0x00;
    BuffTemp[41] =0x00;


    Check(BuffTemp, 44);
    WriteConN (BuffTemp,44);
    
}
void CMD_M_vib()
{   
    unsigned int temp1,temp2;

    temp1 =((BuffTemp[4]<<8) | BuffTemp[5]);
    temp1=temp1&0xFFFF;
    (unsigned int)((7680000*16/(Gyro.Frq>>12))); 
    Gyro.Frq=(122880000/temp1)<<12;
    
    temp2 =((BuffTemp[6]<<8) | BuffTemp[7]);
    temp2=temp2&0xFFFF;
    
    Gyro.AmpPer=(((((Gyro.Frq>>12)*200)/16)*temp2)/7680000);
}
void CMD_M_Control_D8()///установка\сброс регистров управления
{
    unsigned int bit,NReg,Pa;
    unsigned int SR,V,A,Bit_num;
    SR=0;
    V=0;
    A=0;
    Bit_num=0;
    
    BuffTemp[0] = Gyro.SOC_Out;      //DD
    BuffTemp[1] = Gyro.My_Addres;    //00
    BuffTemp[2] = Gyro.CMD_In;       //D8
    
    Pa = BuffTemp[3];
    SR = Pa >> 0x7;
    V  = Pa >> 0x5;
    V  = V  &  0x3;
    A  = Pa >> 0x4;
    A  = A  &  0x1;
    Bit_num = Pa & 0xf;
    
    if(SR) 
    {
    	 switch (Bit_num){
    	 case 0x06: FrqON  	 break;
    	 case 0x05: AVibON 	 break;
    	 case 0x01: HFOON  	 break;
    	 case 0x03: PlcON 	 break;
    	 }
    } 
   else{
   switch (Bit_num){
   	     case 0x06: FrqOFF 	 break;
    	 case 0x05: AVibOFF	 break;
    	 case 0x01: HFOOFF 	 break;
    	 case 0x03: PlcOFF 	 break;
    	}
   } 
    BuffTemp[0] = Gyro.SOC_Out;      //DD
    BuffTemp[1] = Gyro.My_Addres;    //00
    BuffTemp[2] = Gyro.CMD_In;       //D8
    BuffTemp[3] = A<<4;       
    BuffTemp[4] = 0x0;
    BuffTemp[5] = 0x0;
    Check(BuffTemp, CRC_N);
    WriteConN (BuffTemp,CRC_N);
}

void CMD_M_Control_D9()///чтение регистров управления
{
    int bit,NReg;
    BuffTemp[0] = Gyro.SOC_Out;      //DD
    BuffTemp[1] = Gyro.My_Addres;    //00
    BuffTemp[2] = Gyro.CMD_In;       //D9
    if ((Param1 & 0x10) == 0) {
        BuffTemp[3]=0<<4;
        BuffTemp[4] = (Gyro.RgConA>>8 )& 0xff;
        BuffTemp[5] =  Gyro.RgConA     & 0xff;
    } else {
        BuffTemp[3]=1<<4;
        BuffTemp[4] = (Gyro.RgConB>>8 ) & 0xff;
        BuffTemp[5] =  Gyro.RgConB      & 0xff;
    }
    Check(BuffTemp, CRC_N);
    WriteConN (BuffTemp,CRC_N);
}
// (номер (код) ЦАПа 0...3, старший байт требуемого ЦАПа, младший байт треб ЦАПа)
void CMD_M_Stymul()
{
    int temp;
    int HFO;
    temp=BuffTemp[3];
    Consol = temp&0x3;
    HFO    = temp&0x3;// // (номер (код) ЦАПа 0...3, HFO - 3dac, PLC - 0DAC
    temp =((BuffTemp[4]<<8) | BuffTemp[5]);
    // temp=0;
    temp=temp&0xFFFF;
    
    if(HFO)
    {
     Spi.DAC_A=(unsigned int)temp;
    }
    else{
    DACF =(temp*K_DAC)+deltaDAC;
    Spi.DAC_B =(unsigned int)(DACF) /*(unsigned int)(temp*K_DAC+deltaDAC)*/; // K_DAC);
    }
}

void GLDStartDischarg(void)
{
	   				switch(Gyro.My_Addres)
   						 {//смещение поджига и подсветки в зависимости от адреса ГЛД
  						  case 0:
  						  Gyro.Discharg =  StartDischarg  << ShiftStart0;
					 	  Gyro.BackLight = StartBackLight << ShiftStart0;
  						  break;
	    				  case 1:
                          Gyro.Discharg =  StartDischarg  << ShiftStart1;
                          Gyro.BackLight = StartBackLight << ShiftStart1;
                          break;
                          case 2:
                          Gyro.Discharg =  StartDischarg  << ShiftStart2;
                          Gyro.BackLight = StartBackLight << ShiftStart2;
                          break;
                          case 3:
                          Gyro.Discharg =  StartDischarg  << ShiftStart3;
                          Gyro.BackLight = StartBackLight << ShiftStart3;
                          break;
                          }
}

void Gph_W()
{
 	Gyro.flagGph_W=3;
 	Out_G_photo(BuffTemp[4],BuffTemp[5]); 
 	   
}


unsigned int Check(char *c, unsigned int Count)
{
    int i=1;
    unsigned int temp,CRC;


    temp=1;
    CRC=0;


    for(; i<Count-2; i++) {
        CRC+=c[i];
    }

    if(c[Count-2]!=((CRC>>8)&0xFF)) {
        temp=0;
        Gyro.RsErrLine = (Gyro.RsErrLine)&=0x2;
    }

    if(c[Count-1]!=((CRC>>0)&0xFF)) {
        temp=0;
//		Gyro.RsErrLine= (Gyro.RsErrLine)=0x2;
    }

    c[Count-2]=(CRC>>8)&0xFF;
    c[Count-1]=(CRC>>0)&0xFF;



    return temp;
}

int Getlengf(void)
{
    unsigned int lengf;
    lengf = 1;
    switch(Gyro.CMD_In) 
    {
       case 0x99:  lengf=6; CRC_N=8;     break;  //Mintainance
       case 0xB0:  lengf=6; CRC_N=9;     break;  //Delta_Bins
       case 0x0F:  lengf=6; CRC_N=8;     break;  //Delta_Bins
       case 0xA0:  lengf=6; CRC_N=8;     break;  //Delta_PS
       case 0xDD:  lengf=6; CRC_N=44;    break;  //m_rate    
       case 0x0A:  lengf=8;           	 break;	 //m_stymul
       case 0xE9:  lengf=6; CRC_N=8;	 break;	 //DeviceMode
       case 0xE8:  lengf=6; CRC_N=8; 	 break;  //DeviceMode
       case 0xA5:  lengf=6; CRC_N=8;     break;  //DeviceMode
       case 0xD8:  lengf=6; CRC_N=6;     break;  //m_control   
       case 0xD9:  lengf=6; CRC_N=8;     break;  //m_control
       case 0xE4:  lengf=8;              break;  //M_VIB_W
       case 0xE6:  lengf=8;              break;  //M_Gph_W
    }  return lengf;
}

void Read_CMD(void)
{
  
 Gyro.RsErrLine = (Gyro.RsErrLine)& 0xffff;//для сброса ошибки
 CountBuFFIn=ReadChekCon1(BuffTemp);	
 // чтение данных из консоли
 if(CountBuFFIn==1) {
  	// если есть первый байт 
    if (BuffTemp[0] != SOC_In) {
       ReadCon1(BuffTemp);
       Gyro.RsErrLine += 0x100;
       BuffTemp[99]=Gyro.RsErrLine; 
       }
    } 
    else if(CountBuFFIn==2) //если второй байт
    {		//                                 широковещаительный
         if (BuffTemp[1] != Gyro.My_Addres /*|| BuffTemp[1] !=0x1f*/) {
            ReadCon1(BuffTemp); 
            Gyro.RsErrLine += 0x1;
          } 
    } 
    else if(CountBuFFIn==3) // если третий байт
    {				
        Gyro.CMD_In=BuffTemp[2];
        N=Getlengf(); 
    } 
    else if(CountBuFFIn==4 && (N==6)) 
    {	// N -  длина посылки аскглд(для записи параметров). определяется по коду команды в Getlengf();
        Param1=BuffTemp[3];
    } 
    else if((CountBuFFIn==5)&&(N==7)) 
    {
        Param1=BuffTemp[3];
        Param2=BuffTemp[4];

    } 
    else if((CountBuFFIn==6)&&(N==8))
    {
        Param1=BuffTemp[3];
        Param2=BuffTemp[4];
        Param3=BuffTemp[5];
    } 
    else if((CountBuFFIn==8)&&(N==10))
    {
        Param1=BuffTemp[4];
        Param2=BuffTemp[5];
        Param3=BuffTemp[6];
        Param4=BuffTemp[7];
    } 
  
    else if(CountBuFFIn > (N-1))
     {
      ReadCon1(BuffTemp); 
      switch(Gyro.CMD_In) {
      case 0x99: Gyro.ModeOut=0;  	CMD_Maintenance(); 							 break;
      case 0xD8: 					CMD_M_Control_D8();		   					 break;
      case 0xE9:	 				CMD_M_Param_R();							 break;		//чтение параметров
      case 0xE8: 					CMD_M_Param_W(); 							 break;     //запись параметра
      case 0xDA:                    GLDStartDischarg();  						 break; 
      case 0xD9: 		            CMD_M_Control_D9();				             break;
      case 0x0A:	                CMD_M_Stymul();					             break;
      case 0xDD: 	TempParam=(BuffTemp[3]) & 0x9f; 							//Rate
                  switch(TempParam) {
  				  case  Rate1  :  CMD_Rate(); 			 	    				break;  
				  case  Rate2  :  CMD_Rate2();             						break;
				  case  PRate1 :  Gyro.ModeOut=1;	    						break;  
				  case  PRate2 :  Gyro.ModeOut=2;								break;  
				 }
      break;      //DropDelay(); выставка задержки для мультидропа сбрасывается в команде CMD_Maintenance() на () микросекунд; 
      case 0xA0:  DropDelay();    TempParam=(BuffTemp[3]) & 0x90; 				//Delta_PS
                  switch(TempParam) {
  				  case  Delta_500  :  CMD_Delta_PS();		 	    			break;  
				  case  Delta_EXT  :  CMD_Delta_PS();              				break;
				  case  PDelta_500 :  Gyro.ModeOut=3;   Gyro.Event_500Hz=0;		break;  
				  case  PDelta_EXT :  Gyro.ModeOut=4;              				break;
				 }
	  break;
	  case 0xB0:  DropDelay();	TempParam =	TempParam=(BuffTemp[3]>>7);	        //Delta_Bins
                  switch(TempParam) {
  				  case  PDelta_Bins:  Gyro.ModeOut=5;   Gyro.Event_500Hz=0;		break;  
				  case  Delta_Bins :  CMD_Delta_Bins();             			break;
				 }
	  break;
  	  case 0x0F:   DropDelay(); TempParam = (((BuffTemp[3])>>4) & 0x9); 						//B_Delta
                  switch(TempParam) {
  				  case  PB_Delta_EXT: Gyro.ModeOut=6; 		 	  				break;  
				  case  PB_Delta_INT: Gyro.ModeOut=7;   Gyro.Event_500Hz=0; 	break;
				  case  B_Delta_EXT:  CMD_B_Delta();		      				break;   
    			  case  B_Delta_INT:  CMD_B_Delta();              				break;   		
    			}
      break;
      case 0xE4:                	 CMD_M_vib(); 								break; 
      case 0xE6:					 Gph_W();									break; 
      Gyro.RsErrLine = 0;                       
      }
   }
}





















void TechLog(void)
{
 if (ReadCon (Time)) {
/////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
//////////////////////Выбор FlashMod///////////////////////////
////////////////////////////////////////////////////////////////

            if (Time[0] == 'B') 
            {
         //       sprintf((Time),"<%015d>\r\n", ModArray[7]);
                WriteCon(Time);}  
            if (Time[0] == 'W') {Gyro.FlashMod=2;}
            if (Time[0] == 'R') {Gyro.FlashMod=3;}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
            if (Time[0] == 'H') { // если ввели буквц h то выдать подсказку. сделанно через принф ОЧЕНЬ плохо в работе не использовать
                sprintf(Time,"\r\nCompiled: %s %s.",__DATE__,  __TIME__ );                 //Подготовка даты и времени компиляции
                WriteCon(Time);
                sprintf(Time,"--%d.%3.d.%2.d.",Time1Hz,Time1K,Time100K);                 //Временно выдачпа временни из трех чисел
                WriteCon(Time);
            }
            if (Time[0] == 'D') {
                Gyro.Discharg = StartDischarg;
            }
            if (Time[0] == 'L') {
                Gyro.BackLight = StartBackLight;
            }
            if (Time[0] == 'F') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf((Time)," <%015d>", Gyro.CuruAngle);
                WriteCon(Time);
            }   
            if (Time[0] == 'q') {		// внешняя защелка
                Gyro.EXT_Latch=1;
            }   
            if (Time[0] == '1') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%05d> ",Buff_1Point[i]);
                WriteCon(Time);
            }
            if (Time[0] == '2') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%05d> ",   Buff_32Point[CountV31]);
                WriteCon(Time);
            }
            if (Time[0] == '3') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%05d> ",    Buff_16Point[i]);
                WriteCon(Time);
            }
            if (Time[0] == '4') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%07d> ",    Buff_8Point[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%07d> ",    Buff_16PointD[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%07d> ",    Buff_32Point[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 9)," <%07d> ",    Buff_Restored_sin[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n\r\n\r\n");
                WriteCon(Time);
             }
            if (Time[0] == 'z'){		// выдача технологичес6кая
              
                sprintf(Time,"\r\n");
                WriteCon(Time);
              
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp+=(Buff_Restored_sin[i]);
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
                 
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_64Point[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
                 
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_32Point[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
                 
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_16Point[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
                 
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_16PointD[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
               
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_8Point[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
                 
                  for (int i = 0; i < 32; i++ ) 
                  { 
                  ttemp += Buff_1Point[i];
                  }
                  sprintf((Time)," %d ",ttemp);
                  WriteCon(Time);
            }
             if (Time[0] == '6') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )
                {
                	sprintf((Time + i * 9)," <%07d>", (Buff_Restored_Mod[i]>>20));
                }
                WriteCon(Time);
                }  
        /*    if (Time[0] == '7') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
             
                for (int i = 0; i < 32; i++ )sprintf((Time + i * 13)," <%010d>", (BuffADC_64Point[i+32]>>10));
                WriteCon(Time);
                } */   
                /*for (int i = 32; i < 64; i++ )sprintf((Time + i *8),"  <%05d> ",Buff_ADC_5[i]);
                WriteCon(Time);*/
                /*
                sprintf(Time,"\r\n");
                WriteCon(Time);
               for (int i = 0; i < 64; i++ )sprintf((Time + i * 9)," <%05d> ",BuffADC_16Point[i]>>16);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
               for (int i = 0; i < 64; i++ )sprintf((Time + i * 14)," <%010d> ",BuffADC_32Point[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 64; i++ )sprintf((Time + i * 14)," <%010d> ",BuffADC_64Point[i]>>16);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time); 
                for (int i = 0; i < 64; i++ )sprintf((Time + i * 14)," <%010d> ",BuffADC_32PointD[i]);
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf(Time,"\r\n");
                WriteCon(Time);
                
                */
                
               
          /*   if (Time[0] == 'm') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 64; i++ )sprintf((Time + i * 10)," <%010d> ", ModArray[i]);
                WriteCon(Time);
             }*/
             if (Time[0] == '9') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time)," <%07d> ",Gyro.Frq);
                WriteCon(Time);
             }
             /*if (Time[0] == 'p') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ )sprintf((Time)," <%07d> ",Gyro.MaxAmp);
                WriteCon(Time);
             }*/
              if (Time[0] == 'x') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf((Time)," Gyro.MaxAmp = <%07d>  Gyro.CaunPlus = <%07d>  Gyro.CaunMin= <%07d> Gyro.CaunPlus+Gyro.CaunMin-5000 <%07d>  ",Gyro.MaxAmp, Gyro.CaunPlus, Gyro.CaunMin, ((Gyro.CaunPlus + Gyro.CaunMin)-5000));
                WriteCon(Time);
             }
             if (Time[0] == 'm') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                sprintf((Time),"PLC_Delta  <%07d> ",	Gyro.PLC_Delta);  	    WriteCon(Time);
                sprintf((Time),"PLC_DeltaADD  <%07d> ",	Gyro.PLC_DeltaADD);  	WriteCon(Time);
             }
             if (Time[0] == 'V') {		// выдача технологическая
                Spi.DAC_B += 200;
               /* sprintf(Time,"%d\r\n", Spi.DAC_B);
                WriteCon(Time);*/
             }
             if (Time[0] == 'v') {		// выдача технологическая
                Spi.DAC_B -= 200;
               /* sprintf(Time,"%d\r\n", Spi.DAC_B);
                WriteCon(Time);*/
             }
             
            if (Time[0] == 'w')   TypeMod=2; 
            if (Time[0] == 'a')   TypeMod=1;          
            if (Time[0] == 's')   TypeMod=0; 
       ////////////////////////////////////////////////////////////////////////////////   
                      /*Запись лога регулировки частоты*/
            if (Time[0] == 'y')   Gyro.flag=1;           //включит передачу
            if (Time[0] == 'u')   Gyro.flag=0;  //LPC_TIM1->MR0+1000  вносим помеху        
            if (Time[0] == 'i')   {Gyro.flag=2;  } //LPC_TIM1->MR0       убираем помеху  
            if (Time[0] == 'o')   Gyro.flag=3;           //Отключить передачу
            if (Time[0] == 'p')   Gyro.LogHZ = 1;           //Отключить передачу
            if (Time[0] == 'l')   Gyro.LogHZ = 0;           //Отключить передачу
       ////////////////////////////////////////////////////////////////////////////////////     
                      /*Запись лога регулировки периметра*/
            if (Time[0] == 'g')   Gyro.LogPLC=1;  if(OLDDAC)   Spi.DAC_B=OLDDAC;                                //включит передачу
            if (Time[0] == 'h')  {Gyro.LogPLC=2; Spi.DAC_B=19000; Gyro.PLC_Error2Mode = 1400; OLDDAC=Spi.DAC_B; Spi.DAC_B=19000;}                             //десперсионка
            if (Time[0] == 'j')   Gyro.LogPLC=0;  if(OLDDAC)   Spi.DAC_B=OLDDAC;                              //регулировка без выдачиж
            if (Time[0] == 'b')   Gyro.StrayPLC_flag = 3;  //LPC_TIM1->MR0-1000  вносим помеху -
            if (Time[0] == 'n')   Gyro.StrayPLC_flag = 2;  //LPC_TIM1->MR0+2500  большая помеха.  
            if (Time[0] == 'k')   Gyro.LogPLC = 0;         //Отключить передачу 
            if (Time[0] == 'd')   {Gyro.ModJump = 1;   }   //прыжок на воду +     
            if (Time[0] == 'f')   {Gyro.ModJump = 2;   }     //прыжок на воду -  
            //if (Time[0] == 'z')   {Gyro.ModJump = 3; Spi.DAC_B = 0x3a98; }       //прообежать по всем модам.
      //////////////////////////////////////////////////////////////////////////////////////  
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   ////////////////////////////////////////////////////выдача частоты в терминал длля записи лога///////////////////////////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   //////G=1,K=0 в терменале 

        /*  if((Gyro.LogHZ == 1)&&(Gyro.Event_500Hz==1))	//Запись для Ориджина.		
   		   {
    		 Gyro.Event_500Hz=0;
     		 sprintf((Time),"%d \r\n",Gyro.MaxAmp);
       		 WriteCon(Time);
    		}  
      
         */
            if (Time[0] == '8') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ ) 
                   { 
                    ttemp=(Buff_AMP64P[i]-(Buff_AMP[i]));
                    if (ttemp < 0) WriteCon("1"); else WriteCon("0");
                   }
              }
             if (Time[0] == 'q') {		// выдача технологическая
                sprintf(Time,"\r\n");
                WriteCon(Time);
                for (int i = 0; i < 32; i++ ) 
                    { 
                     ttemp=(Buff_Restored_sin[i]);
                     if (ttemp < 0) WriteCon("1"); else WriteCon("0");
                    }
              }
             if (Gyro.PLC_Error2Mode) {		// выдача технологическая
               // sprintf(Time,"\r\nPLC_Error2Mode");
                WriteCon(Time);
              }
        }
}


