/* usbhid.h */
/* USB HID class device */
/* Copyright (c) Phil Wright 2008 */

/* modified by Shinichiro Oba <http://mbed.org/users/bricklife/> */

#ifndef USBHID_H
#define USBHID_H

#include "usbdevice.h"

/* Mouse buttons */
#define MOUSE_L (1<<0)
#define MOUSE_M (1<<1)
#define MOUSE_R (1<<2)

class usbhid : public usbdevice
{
public:
    usbhid();
    bool keyboard(char c);
    bool keyboard(char *string);
    bool mouse(signed char x, signed char y, unsigned char buttons=0, signed char wheel=0);
protected:
    virtual bool requestSetConfiguration();
    virtual void endpointEventEP1In(void);
    virtual void deviceEventReset(void);
    virtual bool requestGetDescriptor(void);
    virtual bool requestSetup(void);
private:
    bool sendInputReport(unsigned char id, unsigned char *data, unsigned char size);
};


//
// USBJoystick
//

#define JOYSTICK_UP    (1<<0)
#define JOYSTICK_DOWN  (1<<1)
#define JOYSTICK_LEFT  (1<<2)
#define JOYSTICK_RIGHT (1<<3)

class USBJoystick : public usbhid
{
public:
    USBJoystick();
    bool joystick(unsigned char buttons1, unsigned short buttons2, signed char x, signed char y, signed char cx, signed char cy, unsigned char L, unsigned char R);
protected:
    virtual bool requestGetDescriptor(void);
private:
    bool sendInputReport(unsigned char *data, unsigned char size);
};

#endif