#include "mbed.h"
#include "stdio.h"
#include "SPI_TFT.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"

void print_char(char c = '*')
{
    printf("%c", c);
    fflush(stdout);
}

Thread thread;

DigitalOut led1(LED1);

void print_thread()
{
    while (true) {
        wait(1);
        print_char();
    }
}

int main()
{
    printf("\n\n*** RTOS basic example ***\n");

    thread.start(print_thread);



    // the TFT is connected to SPI
    // PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset
    SPI_TFT TFT(PA_7, PA_6, PA_5, PB_6, PA_8,"TFT"); // mosi, miso, sclk, cs, reset
    
    TFT.claim(stdout);      // send stdout to the TFT display 
    TFT.claim(stderr);      // send stderr to the TFT display
    
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
     
    TFT.set_orientation(0);
    TFT.locate(0,0);
    printf("  Hello Mbed 0");
    TFT.set_font((unsigned char*) Arial24x23);  // select font 2
    TFT.locate(2,5);
    TFT.printf("Bigger Font");

    while (true) {
        led1 = !led1;
        wait(0.5);
    }
}
