/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Reloj
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     :07-12-2021, 16:03
**    Descripción    :Reloj fechador automatico con varios ajustes
**   Componentes     : GPIO, Timer, Buzzer.
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :Salazar Servin Igal 
**         
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 00/00/2021
**
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "iostream"
#include "stdio.h"


/*
:...............................................................................
:  Definiciones
:...............................................................................
*/

#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Periodo de interrupción (us)=1ms
#define Baud_Rate       115200          // Velocidad de Transmisión (Bauds)
#define Inicio_segundos 10
#define Inicio_minutos  16
#define Inicio_horas    16
#define Inicio_dia      12
#define Inicio_mes      12
#define Inicio_anio     2021
#define inicio_dia      1
#define Contador        0                           
#define Cuenta_regresiva            364                      
#define Semana          1
#define TDC             1                         
#define AMPM            0                         
#define FormatoH        1                      
#define Verano          1                        

/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
//confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor (Interno)
DigitalOut  led_testigo(PB_1);      // Inicializa el LED Testigo (Externo)
PwmOut      servo(PA_7);            // Inicializa el PWM
AnalogIn    sensor1 (PB_0);         // Inicializa Canal Analógico para sensor 1
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
char          Opcion;
bool          Bandera1,Bandera2= TDC,Bandera3= FormatoH,Bandera4= AMPM,Bandera5=Verano;  
              /*Bandera Num= BN 
              B1=Año bisiesto                 ----->> 1=año bisiesto    0=año no bisiesto                 
              B2=Tipo de calendario           ----->> tipo de calendario 1=julioano 0=gregoriano
              B3=FORMATO DE 12 O 24 HRS       ----->> formato de 0=24hrs    1=12 horas AM/PM
              B4=Formato de la hora AM-PM     ----->> inicio de medio dia 0=am  1=pm
              B5=Cambio de horario de verano  ----->> Cambia De Horario 0=horario de verana 1=horario de invierno
              */    
int8_t        dia= inicio_dia,Dia= Inicio_dia,Mes= Inicio_mes,SemanaN= Semana;

              /*
              dia=inicio_dia    -->>inicializa la variable a un valor definido de 1-30 o 31
              Dia= Inicio_dia   -->>inicializa la variable 0=lunes 1=martes 2=miercoles 3=jueves 4=viernes 5=sabado 6=domingo    
              Mes=Inicio_Mes    -->>inicializa la variable a un valor definido de 1-12
              SemanaN           -->>Auxiliar para saber el numero de semanas transcurridas
              */
              
uint8_t       Segundos= Inicio_segundos ,Minutos= Inicio_minutos,Horas= Inicio_horas;
                /*
                Segundos= Inicio_segundos   -->> Inicializamos los segundo [0-60]
                Minutos= Inicio_minutos     -->> Inicializamos los minutos [0-60]
                Horas= Inicio_horas         -->> Inicializamos las horas   [1-24 o 1-12]segun el formato
                */
uint16_t      Anio= Inicio_anio,DiasT= Contador,DiasF= Cuenta_regresiva ;
                
                /*
                Anio= Inicio_anio           -->> Inicializamos la variable de años
                DiasT= Contador             -->> Contador que utilizartemos para ver los dias que han pasado desde 1-365 o 1-366
                DiasF= Cuenta_regresiva     -->> Cntador que utilizartemos para ver los dias que han pasado desde 365- o 366-1
                */

string MES[12]={"ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE"};
string DIA[7]={"LUNES","MARTES","MIERCOLES","JUEVES","VIERNES","SABADO","DOMINGO"};

/* END variables */
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !

void clear_screen(void); 
void Portada(void);
void Reloj(void);
void Fecha(void);
void Imprimir_reloj(void);
void Imprimir_fecha(void);
void Menu(void);
void Cont(void);
void reg(void);
void Horario_Invierno_Verano(void);
void Config_Hora();
void Config_Fecha();

/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main() 
{ 
terminal.baud(Baud_Rate);  
Portada();
while(1) 
  { 
  while(!terminal.readable())
   {
    clear_screen();
    Reloj();
    Fecha();
    Imprimir_reloj();
    Imprimir_fecha();
    wait(1);
    }
    terminal.getc();
    Menu();
   }   
}
/*----------------------------------------------------------------------------------------------------*/
void Menu()
{
    clear_screen();
    terminal.printf("\n\n\r\t\t    ------------------MENU------------------");
    terminal.printf("\n\n\r\t\t   |           1)Configuracion  Hora           |");
    terminal.printf("\n\n\r\t\t   |           2)Configuracion fecha           |");
    terminal.printf("\n\n\r\t\t   |           3)Configuracion de horario      |");
    terminal.printf("\n\n\r\t\t   |           4)Retornar                      |");
    terminal.printf("\n\n\r\t\t   ------------------\e[0;37;41mIPN\e[0m ------------------");
    Opcion = terminal.getc();
    if(Opcion=='1')Config_Hora();    
    if(Opcion=='2')Config_Fecha();
    if(Opcion=='3')Horario_Invierno_Verano();
}
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/

void Portada()
{

  clear_screen();
   terminal.printf ("\e[0;30;42m100110010 00110000 00110001 00111001 00110011 00110101 00110000 00110010 00110101 00110110\e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\e[1;37;41m\t\t\t  Instituto Politecnico Nacional  \e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\e[1;37;42m\t\t  ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA \e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\e[1;37;43m\t\t\t\t Salazar Servin Igal \e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\e[1;37;45m\t\t\t\t\t 4CV6 \e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");        
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");
    terminal.printf ("\e[0;30;42m   \e[0m\e[1;37;46m\t\t\t\t Analisis Numerico  \e[0m\n\r");
    terminal.printf ("\e[0;30;42m   \e[0m\r                                                                                       \e[0;30;42m   \e[0m\r");    
    terminal.printf ("\e[0;30;42m100110010 00110000 00110001 00111001 00110011 00110101 00110000 00110010 00110101 00110110\e[0m\n\r");
        
    wait(5);
    
terminal.printf ("\e[0;30;42m:::  :::   :::   :::  :::   :::   ::. f#tW   :::   :#E#L ::   :::   :::  :::   :::   :::  ::.   :     \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  :::   :::   :::  :::   :::   ::: ,,:,   :::    :,,,:::   :::   :::  :::   :::   :::  ::.   :     \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  .::   :::   :::  :::   :::   :: ,,,,,K  :::   #;,,,:::   :::   :::  .:.   :::   :::  :::   :     \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::   :::   :::  K,,,,,,.:   :: :,,,,,  :::   :::   ::   :::   .::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::   :::   :::  #:,,,,,#:   ::#,,,,,,  :::   :::   ::   :::   .::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   .::   :::   :.   ,f.   :::  #,,,,,:.:   ::t,,,,,,: :::   , tL  ::   :::   :::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::  ,t,,,:K.:   ::#,,,,,,: :::  :,,,,,, :   ::.#,,,,#  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::  t,,,,,,,:   ::W,,,,,,, :::  ;,,,,,: :   :.f,,,,,,  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::   .::   .::   .::   ,,,,,, .   .: ,,,,,,, ::. f,,,,,,.::   . .,,,,::  .::   .::   :::   :.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::  ,,,,,,..::    ,,,,,,,:::iW,,,,,,K  :::  ,,,,,,;::   :::   .::   ::   :::   \e[0m\n\r"); 
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   :: K,,,,,,:#::   #,,,,,,,,,,::,,,,,,f  :::#,,,,,,,#.:   :::   .::   ::   :::   \e[0m\n\r"); 
terminal.printf ("\e[0;30;42m   ::.  .::   .::   .::  .j,,,,,,,:  : #i,,,,,,,,,,,,,,,,,,,Lj   .,,,,,,,   .::   .::   .::  .:.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::  :.,,,,,,,, tE:,,,:,::,::.:,,,,,,,,,,,;E ,,,,,,,j:  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::  :.,:,,,,,,,,,,,,.#E :,;,,,,,,:;#j:,,,,,,,,,,,,, :  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   .::  ##::   ::   i:,,,,,,,,.#.;,,,,..,ii..:,:,,:LD.,,,,,,,,,K  :.   :: D: :::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   ::: f,,,t.  ::   . ,,,,,;;G,,,.G#,:,,,,,,,:.t# ,,,.#..,,,,,:   ::   ff,,: ,::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   ::: :,,:::W ::   :#,,,,:;,,:Dt,,,,,,,,,,,,,,,:, #:,::#:,,,,#   ::  t,,,,:;:::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m... t############:,:. W#######W#######,,,,W##WK#,,,,#WKEEG #.,,#:,.WW### G.,;############ :.:   .     \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::: LGGGGGGGGGGGG,,,:jGGGGGGGGGGGGGGGG,,,,#GGGG#,,,,LGGGGG.,.#,,:.KGGGGGf:,,,GGGGGGGGGGGGE,::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::#GGGGGGGGGGGGG,,,, GGGGGGGGGGGGGGGG,,,,#GGGG#,,,,LGGGGGW,:,G.:EGGGGGG ,,,,GGGGGGGGGGGGGW..   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   LGGGGGGGGGGGGG,,,,:GGGGGGGGGGGGGGGG,,,,#GGGG#,,,,LGGGGGG:,,:.EGGGGGGG ,,,,GGGGGGGGGGGGGL  ::.   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  EGGGGGGGGGGGGGG,,,,:GGGGGGGGGGGGGGGG,:,;#GGGG#,,:,LGGGGGGL:,:,WGGGGGGG ,,,,GGGGGGGGGGGGGG# :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  GGGGGW#######ED,,,,:GGGGD###########W   #GGGG#,,: fGGGGGGGW,,KGGGGGGGG.,,,,GGGGG#########W :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   .#GGGGL.   .:: .:,,,,:GGGGD,,,,,,,:f;  :::#GGGG#,,#:LGGGGGGGGD.GGGGGGGGG.,,,,GGGGG   .::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m    GGGGG,    .     #::,.GGGGG::::::,i..  :.:#GGGG#,,#:GGGGGGGGGGDGGGGGGGGG:,,:#GGGGG         .    :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   #GGGGGGGGGGGGGGGG,,,,KGGGGGGGGGGGGGGGG .:.#GGGG#,,#.GGGGGGGGGGGGGGGGGGGGi,,.:GGGGGGGGGGGGGGGGW  :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::LGGGGGGGGGGGGGGGGt,,K:GGGGGGGGGGGGGGGG:   #GGGG#,,# LGGGGGGGGGGGGGGGGGGG .,,DGGGGGGGGGGGGGGGGG::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m::DGGGGGGGGGGGGGGGGG,,.::GGGGGGGGGGGGGGGG:   #GGGG#,,# LGGGGGGGGGGGGGGGGGGG:E,,,GGGGGGGGGGGGGGGGGj:   \e[0m\n\r");
terminal.printf ("\e[0;30;42m  DGGGGGGGGGGGGGGGGG,,,,tGGGGGGGGGGGGGGGG .:.#GGGG#,,#.LGGGGGGGGGGGGGGGGGGG,,W,,GGGGGGGGGGGGGGGGG# :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m  GGGGGGGGGGGGGGGGGG,;,,;GGGDGGGGGGGGGGGG :::#GGGG#,,#:GGGGGGGGGGGGGGGGGGGG#: :,GGGGGGGGGGGGGGGGGL :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m  GGGGG ::::........;;,#,:::::::;  jGGGGG ...#GGGG#,, #GGGGGWGGGGGGGGLGGGGG.:,G;GGGGG:::::::  ..   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:#GGGG##,,,,,,,,,,,,,,, ,,,,,,,,,# fGGGGG: W:#GGGG#,,,,LGGGG LGGGGGGG:LGGGG:#, ,GGGGG,,,,,,,E   .::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:LGGGG##############i:#::###########GGGGGW,,,#GGGG#j.,:LGGGG .GGGGGGL,GGGGG,,.,KGGGGG#######W######   \e[0m\n\r");
terminal.printf ("\e[0;30;42m LGGGGGGGGGGGGGGGGGG,,.,.GGGGGGGGGGGGGGGL,,,.#GGGG#,,,#LGGGG  #GGGGD,,GGGGG,,#,,GGGGGGGGGGGGGGGGGGG   \e[0m\n\r");
terminal.printf ("\e[0;30;42mfGGGGGGGGGGGGGGGGGGG,.,,.GGGGGGGGGGGGGGGL,.W,#GGGG#:,,,GGGGG ::GGGG.,,GGGGG,, ,,GGGGGGGGGGGGGGGGGGG   \e[0m\n\r");
terminal.printf ("\e[0;30;42m#GGGGGGGGGGGGGGGGGGG:#,,.GGGGGGGGGGGGGGGG.,::WGGGGW:LD,LGGGG ,:;GDE,,,GGGGG,,,.,GGGGGGGGGGGGGGGGGGG#  \e[0m\n\r");
terminal.printf ("\e[0;30;42mLGGGGGGGGGGGGGGGDGGL, ,, GGGGGGGGGGGGGGGL.;.L#DDGG#:,,:GGGGG.,,,E#,,,,GGGGG,,,#;GGGGGGGGGGGGGGGGGGDW  \e[0m\n\r");
terminal.printf ("\e[0;30;42mWWWWWWWWW######W#WW# ,,,:##W##########WWW::.,###WW#W:,,####K ,,,,:,,,WW####,,:i;###WWWKKEDDDDDGGGGGf  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   ::: #:,j,E,,,,,, .::f.:,,,iGGGGW,:,,:    .,,,:#LGGL:,,,: j::  ,,,,,:::j,,..::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   .:: #,,:,#,,,,,L :::  W:, GGGGGGGE: K   :#,:#GGGGGGG.,:# :::   ,,,,, ,#,,:,::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  .::   :t,,:,,,,,,,W:   ::: .WGGGGGGGLE  :::  GKGGGGGGGG#t ::   :.#,,,,,E,j:,:   :::  .::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  ##ftL##.,:,,.,,,,, :   ::: LGGGLW,#LLGD :::  LGGGL#WGGGLj:::   ::E,,,,,#,.,,,##EE##   :.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::tf,,,,,,,,,:,,,:,,,,, :   :::  GGGi:,::WGGL::: fGGGE,,#:GGG::::   :. ,,,,,#,:,,,,,,,,:,.# .   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  ;,,,,,,,,,,,:,:,,,,,.  ::.   :jGGW.,,,: #GGD  GGG#W,,,K:#GG;   :.:   :,,,,L,,,,,,,,,,,,,,. :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  ,,,,:,:,,,,,,,.,,,,,.  :::   :KGGKi:,,: .WDGWLGG#  ,,,f,jGGE   :::   :,,,,i,,,,,,,,,,:,,,: :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::  ,,,,,W:,,,,,,,.,,,,,.  :::   :#GG.;,,:: :.#GDGG#.  :,,f,tGGG   :::   :,,,,i,,,,,,,,L,:,,,, .::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::,,,:,WL,:,,:,:,,,,,:.:   ::: #GG..;,,,.   WGGW  :f,,,#:WGGi:::   ::.,,,,,G,,,,,, #::,,,,,.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :: #:;,,,:G#:,.,,:,,,,, .   ::: DGG.,.,,,L  fGG#G  .i,,,f,KGG :::   :: ,,,,,#,::,.DW;,:,,.# .   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   .: j##G #LG ,,:,,,,,  :::   :iGG.,#,,,, .GGKLGK: ;,,,:, GGi   :::  t,,,,:#,.:#Gi####L :   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   ::: WDG::;,,,,,# :::   i GG#,..,,,:KGL GGGW:,,:#,:tGG,.  :::  #,,,,,D,WGD#.::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   .:: KiLGWK::,,,D ::.  W:.GG.:,#,,,fGG;  WDG.,,.,,D#GL,,# :.:  f,,,;ifGG#:#:::   :.   ::.   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  .::   :#,,KGGD.,,,.    E,,,,GG##::E,;GG#,,,;GGL:..:G:WG#,,,,#  :W;,,,LGLGD,::   :::  :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   : ,,#WGGG#.,,:WLG,,,,,KD#;G,;#WGG,,,,,fGGi:,. ,LG#,,,,,,,#,:,,DGGE: ,:.   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  :::   :  ,j,;LGGG#.,:,,,K.:,#GG,.t:,LGt,,,,:,WGD,,,,.GG:,,;#,,,,,:#GGG#,.,,.,   :::  .::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :Ef:,,,,:,#WGGGGW:,,,GG#,.GG:,,E#G# #Kif#i:GG# ;,#GG,,GLG,,,.EGGGL,:,#,,,:,#    ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   :: .f::,,,,,:W,.,#GGGGG#.:GGG#:GG;,, DL,:,:,,,:,jGD.,,KGW,#GGG,.#LGGGW. ,,,,,,,,,,W  ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   :: G,,,,,,,,,i,, ,,LGGGGGKGGGGGWG#W;#G#W,:,:,,.#,LG#,#GG#DGGGGWGGGGG#,:#,:,,,,,,,,,:#,:   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.   ,:,,,,,,,,,.,#:,.DGGGDGLGGGGGWG iGL.;,,   :,,:jGGL:GKGGGGGGGGGGLD,,:.:#,,,,,,,,,,,L :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  ,,,,,,,,,,,,G,, ,,;DGGGGGGGGGGGD,#G# ,,,,,,,,,;;#G##GGGGGGGGGGGD:,,:#,.:,,,,,,,,,,,,i::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::. #,,,,,,,:,,,:,::K,,,,tLGGGGGGGGGGG#G:.#:,,,,,,.i: GWLGGGGGGGGGG#,,,,..,#:,:.,,,,,,,,,#:::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   . ,,,,,,,,:#K:,D,,;,,,, EGGGGGGGGGGD#  ,K,,,,,,#   WGGGGGGGGGGGL::,,:K:,,:,f#.,,,,,,,,    :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::,,:,::iG : :,;.,,,,,,,;#GGGGGGGGGGGG,:K,,,,,,# tLGGGGGGGGGLG.,,,,,.,,#,,D:  W:,:,,,.:   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m...   ..    .:   ..W::i,,#:,,,,,iLGGGGGGGGGGG#D,,,,:,#WGGGGGGGGGGD#,,,,,::;;;::. .   ::    ..   ...   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  .::   ...   t::W:,;::::::.KGGGGLDGGGGLD,,,,:ifGGGGGDGGGGLt,:,,,,:K::,,:D   ..    ..  :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::E                      ;#GGGGGWLGGGGGj,,#GGGGGLEWGGGG.::#                     ..  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::    ::                        ,DGGL#GK#LGDGG#KGGGGGWLGDGG#,,,#                     i.:   :.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :E                      :,:DL #G, DGGGGGGGDj GGWELW,,,#                     K   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :. :::K.,KW             i,:GKiWGE #:KGGGG#;D DL# GG:,G              .#E###W ,   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :.#,,,,,G             W#G#j:GLELGLGGLGGD.LGG,,GG :             #,,,,:::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :j,,,,,,,,, ,,tD       DG    G#GGE :,;GGDWGW  #G#        K,:.,;,,,,,,.    :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  :::   ,:,,,,,,,:  E,,:#      GL   iLDK.      DLG#   :GE      .E;:L :,,,,,,,,K   :::  .::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::t,,,,,,,,..  #:,:#    ;G#  EGGEL        LWGG   DG      ;,,# .f:,,,,,,,, ::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::#,,,,,,,; :   W,,,D   #DK WGf #GK      #GE #Li LG     ,;,#  :...,,,,,,,#::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m..:   ..   ... :,,,,.# ..   :#,,,#  GGWE.:   GG.    #GD    #WWGK    ,;t   .:  #:,,,:G,..   .:   :.:   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::.:# ::  ::: :,,,,:iL#:,,,;#LWGG    GL# # ,,:#L#..,,,,. ::  ::: #.,i.   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :.W#  :::  ::::,,,,,,,EG#;:,:,,iDGi  KGEW,,,,:WWGW,:,,,,:G::  :::   G.:   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  :::   :::   :::  ::i:,,,,,, GG,,.Kf.,,;Df #GG,,, #i:,,GL,,,,,,,,.:  :::   :::   .::  :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::  ,,,,,,:,iGG:,:,,,,:.KL#GG,.,,,,,,::GGt,,,,,,,: ::   :::   .::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   :: G,,,,,,,LjGG W;,,,,,,,KDG#.,,,,,,LL GG..,,,,,,,.::   :::   .::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   .::   :::   :: G,,,,,,,.fGG  #,,,,,,.LGK#;,,,,,,; .GG #,,,,,,,#::   :::   :::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  :::   .::   :::  ::,,,,,,# jGG.: ,,,,,:LGDLL#,,,,,,#:fGG  .,,,,,,   :::   :::   :::  :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::   ,,,,,,D:  GG# ,,,,,fLGD fGGD.,,,,..#GG : .,,,,,,  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ::.  .::   .::   :::   ,,,,,: :  GGL ,,,,DLGL .:GGGLi:,,: GGG :.L;,,,,,  .::   :::   .::  .:.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   .::   :: L,,,:i  ::GGGW.,,KDGG:   .#GGGEf.,GDGL:   #,,,,# :   :::   :::   :.   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::   ,:.   :.#GGGGGGGGK#:   :..GGGGGGGGG#:   ..j#  ::   :::   .::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m   ...  ...   ...   ...   ..   ...  :DGGGGDGW:: ...  #:EGGGGGGD  ...   .:.  ...   ...   ...   .:   .  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  .::   :::   :::  ::.   :::   #GGGGLK;:  ::.   :;DGGGGG#  :::   :::  .:.   :::   .::  :::   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m   :::  :::   :::   :::  :::   :::   :#DD#.::#  :::   K,,;j##G   :::   :::  :::   :::   :::  ::.   :  \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   ::   :::   :::   ,,,,..::   ::: :;,,   :::   :::   ::   :::   :::   ::   :::   \e[0m\n\r");
terminal.printf ("\e[0;30;42m:::   ::   :::   :::   :.   :::   :::   .:###:.:   ::. ##K.   :::   :::   ::   :::   :::   :.   :::   \e[0m\n\r");

    wait(5);
}

/*-------------------------------------------------
---------------------------------------------------*/
void clear_screen() //esta funcion te limpia la pantalla
{
    terminal.printf("\x1B[2J");
    terminal.printf("\x1B[H");
}
/*-------------------------------------------------
---------------------------------------------------*/
void Reloj() // esta funcion te cuenta los minutoos al igual que te hace los cambios de hora
{
    Segundos++;   
    if(Segundos>=60)
    {
        Minutos++;
        Segundos= 0;
    }
    if(Minutos>=60)
    {
        Horas++;
        Minutos=0;
    }
     if(Horas>=24 && Bandera3==0)               //Formato de 24 hrs
    {
        Horas=1;
        Dia++;
        dia++;
        DiasT++;
        DiasF--;
        if(dia>=7)dia=0;
        if(Bandera2==1&& dia==0)SemanaN++;
        if(Bandera2==0&& dia==6)SemanaN++;
     }
             if(Horas>=13 && Bandera3==1)Horas=1;               //Formato de 12 hrs           //si la hora es mayor o igual a 13 y la bandera de formato de hora es 1 la variable horas la erestablecea a 1 
     if(Horas==12&& Minutos==0 && Segundos==0 && Bandera3==1)   // PM
      {
         Bandera4=!Bandera4;
         if(Bandera4==1)                                        // BANDERA4: 0=AM 1=PM
        {
         Dia++;
         dia++;
         DiasT++;
         DiasF--;
         if(dia>=7)dia=1;
         if(Bandera2==1&& Dia==0)SemanaN++;
         if(Bandera2==0&& Dia==6)SemanaN++;
        }  
      }
   
}
/*----------------------------------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------------------------------*/
void Horario_Invierno_Verano()// esta funcion se usa para el cambio de hora en la semana 14 y semana 44
{
    int opcion;
intento: 
    clear_screen();
    terminal.printf("\n\t 0.-ACTIVAR HORARIO DE INVIERNO\n\r");
    terminal.printf("\t   1.-ACTIVAR HORARIO DE VERANO\n\r");
    terminal.printf("\t   2.-SALIR\n\r");
    opcion=terminal.putc(terminal.getc())-48;
    
    if(opcion==0&&Bandera5==0)
    {
        clear_screen();
        terminal.printf("\n\tACTIVADO HORARIO DE INVIERNO");
        Bandera5=0;
        Horas--;
        wait(1.5);
        return;
    }
    if(opcion==1&&Bandera5==1)
    {
       clear_screen();
       terminal.printf("\n\tACTIVADO HORARIO DE VERANO");
       Bandera5=0;
       Horas++;
       wait(1.5);
       return;
    }
    if(opcion>2)
    {
        clear_screen();
        terminal.printf("\n\r\tintente de nuevo, valor ingresado incorrercto");
        wait(1.5);
        goto intento;
    }
    if(opcion==2)return;
}

/*----------------------------------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------------------------------*/

void Imprimir_reloj()
{
    if(Bandera3==0)terminal.printf               ("\r\n\t\t\e[31m  %i:%i:%i  hrs\e[0m\n\r",Horas,Minutos,Segundos);
    if(Bandera3==1 && Bandera4==1)terminal.printf("\r\n\t\t\e[31m  %i:%i:%i   AM \e[0m\n\r",Horas,Minutos,Segundos);
    if(Bandera3==1 && Bandera4==0)terminal.printf("\r\n\t\t\e[31m  %i:%i:%i   PM \e[0m\n\r",Horas,Minutos,Segundos);
}
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
void Imprimir_fecha(){
    
    terminal.printf("\n\r\tHOY ES  %s   %i/%s/%i    ",DIA[dia],Dia,MES[Mes-1],Anio);
    terminal.printf("\n\r\t\e[1;36m Semana en curso: %i , Los dias transcurridos son: %i , Los dias faltantes son: %i\e[42m" , SemanaN,DiasT,DiasF);
    if (Bandera1==1)terminal.printf("\n\r\t\e[1;31;40m Este anio es bisiesto\e[42m");
    if (Bandera1==0)terminal.printf("\n\r\t\e[1;34;40m Este anio no es bisiesto\e[42m");
    if (Bandera2==1)terminal.printf("\n\r\t\e[0;37;40m Calendario Juliano\e[42m");
    if (Bandera2==0)terminal.printf("\n\r\t\e[1;32;40m Calendario Gregoriano\e[42m");
    if (Bandera5==0)terminal.printf("\n\r\t\e[1;36;48m HORARIO DE Invierno:\e[0m \e[41mSI\e[0m\n\r");
    if (Bandera5==1)terminal.printf("\n\r\t\e[0;31;40m HORARIO DE Verano:\e[0m \e[42mSI\e[0m\n\r");
    }
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/

void Fecha(){
    
     if(Dia>=32 && Mes!=2 && Mes!=4 && Mes!=6 && Mes!=9 && Mes!=11)
    {
        Mes++;
        Dia=1;
    }
    if(Dia==31 && Mes!=1 && Mes!=2 && Mes!=3 && Mes!=5 && Mes!=7 && Mes!=8 && Mes!=10 && Mes!=12) //si el dia es igu
    {
        Dia=1;
        Mes++;
        
    }
   if(Dia==30 && Mes==2 && Bandera1==1) //si el dia es igual a 30 y la variable mes es igual al mes 2 y la bandera de año bisiesto es igual a 1 entra
    {
        Dia=1;      //restablece la variable dia a 1
        Mes++;      //incrementa una unidad la Variable mes
    }
    if(Dia==29 && Mes==2 && Bandera1==0) //si el dia es igual a 29 y la variable mes es igual al mes 2 y la bandera de año bisiesto es igual a 0 entra
    {
        Dia=1;        //restablece la variable dia a 1
        Mes++;        //incrementa una unidad la Variable mes
    }
    if(Mes>=13)             //si la Variable mes es mayor igual a 13 entra
    {
        Mes=1;                  //restablece la variable mes a 1
        Anio++;                  //incrementa la variable año una unidad
        SemanaN=1;               //restablece la variable semana a 1
       if(Anio%4==0||Anio%400==0)Bandera1=1;                    //si el residuo del año dividido entre 4 es 0 o el residuo de ano dividido entre 400 es 0 es un año bisiesto
        if(Anio%4!=0||(Anio%100==0&&Anio%400!=0))Bandera1=0;
        DiasT=0;                   //restablece la variable DIAS TRANSCURRIDOS A 0
        if(Bandera3==0)DiasT=364;    //si el año no es bisiesto la variable Dias Por Transcurrir la iguala a 364
        if(Bandera3==1)DiasT=365;    //si el año es bisiesto la variable Dias Por Transcurrir la iguala a 365
    }   
}

/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/


void Config_Hora()  // configura la hora tanto en formato de 24hrs y 12hrs am/pm
{
    int op;                         //variable para guardar la opcion qe eligamos
    uint8_t Thora;                  //variable temporal cdonde se guardara la hora para despues asignarla a nnuestra varaiable Horas
    uint8_t Tminutos;
    uint8_t Tsegundos;
    bool TBandera3;                 //Configuracion de Formato 12hrs y 24hrs
    bool TBandera4;                 //Configuracion de Meridiano (PM/AM)
    
    inicio_configuracion:
    clear_screen();
    
    terminal.printf("\n\r\e[33mFormato\e[0m");
    terminal.printf("\n\r\e[31m 1)24hrs\e[0m");
    terminal.printf("\n\r\e[31m 2)12hrs\e[0m");
    terminal.printf("\n\r\e[33m 3)Regresar\e[0m");
    op = terminal.getc();
    if(op=='1')
    {
        intento:
        clear_screen();
        TBandera3=0;
        terminal.printf("\n\r\tDigite la hora para el formato de  24hrs: HH:MM:SS\n");
        Thora = (terminal.putc(terminal.getc())-48)*10;      
        Thora = terminal.putc(terminal.getc())-48+Thora;
        terminal.printf(":");
        Tminutos = (terminal.putc(terminal.getc())-48)*10;
        Tminutos = terminal.putc(terminal.getc())-48+Tminutos;
        terminal.printf(":");
        Tsegundos = (terminal.putc(terminal.getc())-48)*10;
        Tsegundos = terminal.putc(terminal.getc())-48+Tsegundos;
        Horas= Thora;
        Minutos= Tminutos;
        Segundos= Tsegundos;
        wait(.5);
       
        if(Thora>=24||Tminutos>=60||Tsegundos>=60)
        {
        clear_screen();
        terminal.printf("\n\r\t ERROR , TRY AGAIN");
        wait(2);
        goto intento;
        }  
        Bandera3=TBandera3;  
    }
      
    if(op=='2')
    {
        intento2:
        clear_screen();
        
        TBandera3=1;
        terminal.printf("\n\r\tDigite la hora en formato de 12hrs: HH:MM:SS AM/PM\n");
        Thora = (terminal.putc(terminal.getc())-48)*10;      
        Thora = terminal.putc(terminal.getc())-48+Thora;
        terminal.printf(":");
        Tminutos = (terminal.putc(terminal.getc())-48)*10;
        Tminutos = terminal.putc(terminal.getc())-48+Tminutos;
        terminal.printf(":");
        Tsegundos = (terminal.putc(terminal.getc())-48)*10;
        Tsegundos = terminal.putc(terminal.getc())-48+Tsegundos;
        Segundos= Tsegundos;
        Horas= Thora;
        Minutos= Tminutos;
         wait(.5);
         if(Thora<1||Thora>=13||Tminutos>=60||Tsegundos>=60)
        {
            clear_screen();
            terminal.printf("\n\r\ERROR , TRY AGAIN");
            wait(.5);
            goto intento2;
        }
        
        AMPM1:
        clear_screen();
        terminal.printf("\n\r0)PM");
        terminal.printf("\n\r1)AM");
        terminal.printf("\n\r2)SALIR");
        TBandera4=terminal.putc(terminal.getc())-48;
        if(TBandera4>=3)
        {
            clear_screen();
            terminal.printf("\n\r\tERROR , TRY AGAIN");
            wait(2);
            goto AMPM1;
        }  
        Bandera3= TBandera3;
        Bandera4= TBandera4;
    }  
    if(op>'4')
    {
        clear_screen();
        terminal.printf("\n\r\tERROR , TRY AGAIN");
        wait(2);
        goto inicio_configuracion;
    }
}



/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/

void Cont()
{
     Dia++;
     dia++;
     DiasT++;
     DiasF--;
     if(dia>=7)dia=0;
     if(Bandera2==1&& dia==0)SemanaN++;
     if(Bandera2==0&& dia==6)SemanaN++;
    
    if(Dia>31&& (Mes==1||Mes==3||Mes==5||Mes==7||Mes==8||Mes==10||Mes==12))
    {
        Mes++;
        Dia=1;
    }
    if(Dia>=31 && Mes!=1&&Mes!=2&&Mes!=3&& Mes!=5&&Mes!=7&&Mes!=8&&Mes!=10&& Mes!=12)
    {
        Dia=1;
        Mes++;
        
    }
    if(Dia>28 && Mes==2 && Bandera1==0)
    {
        Dia=1;
        Mes++;
        
    }
    if(Dia>29 && Mes==2 && Bandera1==1)
    {
        Dia=1;
        Mes++;
        
    }
    if(Mes>12)
    {
        Anio++;
        SemanaN=1;
        Mes=1;
        
        if(Anio%4==0||Anio%400==0)Bandera1=1;
        if(Anio%4!=0||(Anio%100==0&&Anio%400!=0))Bandera1=0;
        
        if(Bandera1==1) DiasF=365;
        if(Bandera1==0) DiasF=364;
        DiasT=0;
    }
   
}
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/

void reg()
{
     Dia--;
     dia--;
     DiasT--;
     DiasF++;
     if(dia<0)dia=6;
     if(Bandera2==1&& dia==6)SemanaN--;
     if(Bandera2==0&& dia==5)SemanaN--;
    
    if(Dia<=0&& (Mes==2||Mes==4||Mes==6||Mes==8||Mes==9||Mes==11||Mes==1))
    {
        Mes--;
        Dia=31;
    }
    if(Dia<=0 && Mes!=2&&Mes!=3&&Mes!=4&&Mes!=6&& Mes!=8&&Mes!=9&&Mes!=11&&Mes!=1)
    {
        Dia=30;
        Mes--;
        
    }
    if(Dia<=0 && Mes==3 && Bandera1==0)
    {
        Dia=28;
        Mes--;
        
    }
    if(Dia<=0 && Mes==3 && Bandera1==1)
    {
        Dia=29;
        Mes--;
        
    }
    if(Mes<=0)
    {
        Anio--;
        SemanaN=53;
        Mes=12;
         if(Anio%4==0||Anio%400==0)Bandera1=1;
         if(Anio%4!=0||(Anio%100==0&&Anio%400!=0))Bandera1=0;
        
        if(Bandera1==1) DiasT=365;
        if(Bandera1==0) DiasT=364;
        DiasF=0;
    }
}

/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/
void Config_Fecha()//configura la fecha tanto el dia mes y año con el calendario  gregoriano y juliano
{
    int op2,op3;
    uint8_t TDia;
    uint8_t TMes;                                   
    uint16_t TAnio;
    bool TBandera1;                                 //Configuracion del año Bisiesto 
    bool TBandera2;                                 //Configuracion de Calendario 0)Gregoriano o 1)juliano 
    
    inicio_configuracion:
    clear_screen();
    
    terminal.printf("\n\rIngresa la Fecha:");
    terminal.printf("\n\r1)Cambiar" );
    terminal.printf("\n\r2)Regresar");
    
    op2 = terminal.getc();
    if(op2=='1')
    {
        
        clear_screen();
        TBandera1=1;
        TBandera2=1;
        terminal.printf("\n\rTipo de Calendario:");
        terminal.printf("\n\r0)Gregoriano");
        terminal.printf("\n\r1)Juliano");
        terminal.printf("\n\r2)Regresar");
        op3 = terminal.getc();
        
        if(op3=='1')
        {
        TBandera2=1;
        Inicio:
        clear_screen();
        terminal.printf("\n\r\tDame tu fecha en formato de DD/MM/AAAA");
        terminal.printf("\n\r\tDame la Fecha: ");
        TDia = (terminal.putc(terminal.getc())-48)*10;       ///////////////
        TDia = terminal.putc(terminal.getc())-48+TDia;
        terminal.printf("/");
        TMes = (terminal.putc(terminal.getc())-48)*10;
        TMes = terminal.putc(terminal.getc())-48+TMes;
        terminal.printf("/");
        TAnio = (terminal.putc(terminal.getc())-48)*1000;
        TAnio = (terminal.putc(terminal.getc())-48)*100+TAnio;
        TAnio = (terminal.putc(terminal.getc())-48)*10+TAnio;
        TAnio = (terminal.putc(terminal.getc())-48)+TAnio;
        
        if(TAnio%4==0||TAnio%400==0)TBandera1=1;
        if(TAnio%4!=0||(TAnio%100==0&&TAnio%400!=0))TBandera1=0;
        
    
        if((TDia>31&& (TMes==1||TMes==3||TMes==5||TMes==7||TMes==8||TMes==10||TMes==12))||
          (TDia>=31 && TMes!=1&&TMes!=2&&TMes!=3&& TMes!=5&&TMes!=7&&TMes!=8&&TMes!=10&&TMes!=12)||
          (TDia>28 && TMes==2 && TBandera1==0)||
          (TDia>29 && TMes==2 && TBandera1==1)||
          (TMes>=13||TMes<=0))
          {
          terminal.printf("\n\r\tERROR , TRY AGAIN");
          terminal.getc();
          goto Inicio;
          }
        if((TAnio>Anio)||(TAnio==Anio && TMes>Mes)||(TAnio==Anio && TMes==Mes && TDia>Dia))
        while(Anio!=TAnio||Mes!=TMes||Dia!=TDia)Cont();
        if((TAnio<Anio)||(TAnio==Anio && TMes<Mes)||(TAnio==Anio && TMes==Mes && TDia<Dia))
        while(Anio!=TAnio||Mes!=TMes||Dia!=TDia)reg();   
        }
        
        if(op3=='0')                //Calendario Gregoriano
        {   
        TBandera2=0;
        Bandera2=TBandera2;
        Inicio2:
        clear_screen();
        terminal.printf("\n\r\tDame la fecha en formato de DD/MM/AAAA");
        terminal.printf("\n\r\tDame la Fecha: ");
        TDia = (terminal.putc(terminal.getc())-48)*10;    
        TDia = terminal.putc(terminal.getc())-48+TDia;
        terminal.printf("/");
        TMes = (terminal.putc(terminal.getc())-48)*10;
        TMes = terminal.putc(terminal.getc())-48+TMes;
        terminal.printf("/");
        TAnio = (terminal.putc(terminal.getc())-48)*1000;
        TAnio = (terminal.putc(terminal.getc())-48)*100+TAnio;
        TAnio = (terminal.putc(terminal.getc())-48)*10+TAnio;
        TAnio = (terminal.putc(terminal.getc())-48)+TAnio;  
                 
        if(TAnio%4==0||TAnio%400==0)TBandera1=1;
        if(TAnio%4!=0||(TAnio%100==0&&TAnio%400!=0))TBandera1=0;
        
    
        if((TDia>31&& (TMes==1||TMes==3||TMes==5||TMes==7||TMes==8||TMes==10||TMes==12))||
          (TDia>=31 && TMes!=1&&TMes!=2&&TMes!=3&& TMes!=5&&TMes!=7&&TMes!=8&&TMes!=10&&TMes!=12)||
          (TDia>28 && TMes==2 && TBandera1==0)||
          (TDia>29 && TMes==2 && TBandera1==1)||
          (TMes>=13||TMes<=0))
          {
          terminal.printf("\n\r\tERROR , TRY AGAIN");
          terminal.getc();
          goto Inicio2;
          }
        if((TAnio>Anio)||(TAnio==Anio && TMes>Mes)||(TAnio==Anio && TMes==Mes && TDia>Dia))
        while(Anio!=TAnio||Mes!=TMes||Dia!=TDia)Cont();
        if((TAnio<Anio)||(TAnio==Anio && TMes<Mes)||(TAnio==Anio && TMes==Mes && TDia<Dia))
        while(Anio!=TAnio||Mes!=TMes||Dia!=TDia)reg();                                      
        }
        if(op3=='2')return;    
    } 
    if(op2=='2')return;
    if(op2>'3')
    {
        clear_screen();
        terminal.printf("\n\r\tERROR , TRY AGAIN");
        wait(2);
        goto inicio_configuracion;
    }
}

/*----------------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------------*/

/* END Mbed */ 