//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#include "mbed.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>
#include "GPS.h"
#include "MDM.h"
#include "main.h"
#include "coap_msg.h"
#include "coap_client.h"
#include "drv_C027_GNSS.h"
#include "C027_api.h"

extern "C" {
#include "rtc_api.h"
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#define     APN                     "giffgaff.com"
#define     USERNAME                "giffgaff"
#define     PASSWORD                NULL

//#define     APN                     "jtm2m"
//#define     USERNAME                NULL
//#define     PASSWORD                NULL
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#define     SIMPIN                  ""
#define     SIZE_BUFF_RX_GPS        128
#define     SIZE_BUFF_TX_ASSETS     256
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
char                    ucReturnCode[10], caLssFinalAssetMsg[SIZE_BUFF_TX_ASSETS], buffer[SIZE_BUFF_RX_GPS], bytRxGps0=0, bytRxGps1=0, bytRxGps2=0;
unsigned long           ulGPSRxCntr=0, ulGPSTxCntr=0, ulGSMRxCntr=0, ulGSMTxCntr=0, ulTotalRxCntr=0, ulTotalTxCntr=0;
double                  dLatitude=0.0, dLongitude=0.0, dBtteryLevel=0.0;

Serial                  prtGps( GPSTXD,GPSRXD );
MDMSerial               mdm;
MDMSerial*              gmdm=&mdm;

int                     ssocket;
MDMParser::IP           ipp;
DigitalOut              myled( LED );
AnalogIn                ain( A0 );
static unsigned int     uiWakeupCounter=0,uiWatchdogCounter=0;
Ethernet                eth;
DigitalIn               PinDriftLoc(P1_20);
DigitalIn               PinWakeupCntr(P1_23);
DigitalIn               PinNoTransmission(P2_11);

MDMParser::DevStatus    devStatus= {};
bool                    bSleepModeFlag=true, bSendingDataFlag=true, extintrupt=false;
int                     pport = 5685, alarmtime = 1495698480;//2017-3-29-11:56:7
const char*             host = "coap.me";
unsigned int            uiNormalSleepTime = 60, uiHeartBeatSleepTime = 3600;

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
int main( void ){
    //--   
    us_ticker_init();
    c027_gps_powerOn();
    //--
    while( true ){
        wait( 5 );
        if( initialize_modem() ){
            if( bSendingDataFlag ){
                CollectNmeaMessagesProcess();
                dBtteryLevel = ain.read() * 4.030 * 3.3;                                    //-- ASSET
                //--
                //-- Ethernet Interface
                if( eth.link() ){
                    printf("INFO> Ethernet attached\r\n");
                    ulGSMTxCntr += 1000; 
                }
                else{
                    printf("INFO> Ethernet de-ttached\r\n");
                }
                //--
                if( PinWakeupCntr ){
                    printf("INFO> PinWakeupCntr\r\n");    
                    uiWakeupCounter += 10;
                }
                else{
                }
                //--
                CreateFinalAssetMessage();
            } 
            else{
                sprintf( caLssFinalAssetMsg, "$AQLSS,02,%s,%s*xx\r\n",devStatus.imei,devStatus.imsi);
                printf( "MCU> HeartBeat: %s\r\n", caLssFinalAssetMsg );
            }
            //--     
            if( PinNoTransmission ){
                printf("INFO> PinNoTransmission\r\n");
            }
            else{
                SendViaModuleSocket();
            }
            //--
            if( bSleepModeFlag )
                LssSleepMode();
        }
    }
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void rtc_setup( time_t t, unsigned int sec ){
    struct tm *timeinfo = localtime( &t );
    rtc_init();
    rtc_write( alarmtime );//2017-3-29-11:56:7

    LPC_RTC->ALSEC = timeinfo->tm_sec + sec;            //-- Set alarm time

    LPC_RTC->AMR &= (~(1 << 0)) & 0xFF;
    LPC_RTC->ILR = (1 << 0) | (1 << 1);
    NVIC_EnableIRQ( RTC_IRQn );
    do{
        LPC_RTC->CCR |= (1 << 0);
    } while( (LPC_RTC->CCR&(1<<0))==0 );
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
extern "C" void RTC_IRQHandler( void ){
    if( LPC_RTC->ILR & (1<<1) ) 
        LPC_RTC->ILR = (1<<1);
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void LssSleepMode( void ){
    /*
    unsigned int sleeptime = 0;
    if( bSendingDataFlag )      sleeptime = uiNormalSleepTime;
    else                        sleeptime = uiHeartBeatSleepTime;

    sleeptime = sleeptime/50;

    printf("MCU> Entering Sleep Mode\r\n");
    int i=0;
    for( i=0;i<sleeptime;i++ ){
        rtc_setup(alarmtime,50);
        hal_sleep();
        if( extintrupt )
            break;
    }
    extintrupt = false;
    printf( "MCU> Exit Sleep Mode after %d seconds\r\n", i*50 );
    myled = !myled;
    uiWakeupCounter++;
    */
    
    //unsigned int sleeptime = 0;
    //if( bSendingDataFlag )      sleeptime = uiNormalSleepTime;
    //else                        sleeptime = uiHeartBeatSleepTime;

    //sleeptime = sleeptime/50;

    printf("MCU> Entering Sleep Mode\r\n");
    //int i=0;
    //for( i=0;i<sleeptime;i++ ){
        rtc_setup( alarmtime,30 );
        hal_sleep();
        //if( extintrupt )
        //    break;
    //}
    //extintrupt = false;
    printf( "MCU> Exit Sleep Mode after %d seconds\r\n", 30 );
    myled = !myled;
    uiWakeupCounter++;
    
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void CollectNmeaMessagesProcess( void ){
    //--
    int bufferIndex = 0;
    bool bIsStartCollecting=false, bIsPktRxDone=false;
    while( bufferIndex<SIZE_BUFF_RX_GPS && !bIsPktRxDone ) {
        if( prtGps.readable() ) {
            bytRxGps0 = bytRxGps1;
            bytRxGps1 = bytRxGps2;
            bytRxGps2 = prtGps.getc();

            if( bytRxGps0=='*' && bIsStartCollecting ) {
                bIsStartCollecting = false;
                bIsPktRxDone = true;
                ulGPSRxCntr += bufferIndex;
                break;
            } else if( bIsStartCollecting ){
                buffer[bufferIndex++] = bytRxGps2;
            }
            else if( bytRxGps0=='G' && bytRxGps1=='L' && bytRxGps2=='L' ) {
                bIsStartCollecting = true;
                bufferIndex = 0;
                ulGPSRxCntr += 3;    //-- iazi UK
            }
        }
    }
    //--
    if( getNmeaAngle( 1,buffer,SIZE_BUFF_RX_GPS,dLatitude ) && getNmeaAngle( 3,buffer,SIZE_BUFF_RX_GPS,dLongitude ) ){
        printf( "NMEA> %.5f %.5f\r\n", dLatitude, dLongitude );
        //--
        if( PinDriftLoc ){
            printf("INFO> PinDriftLoc=1 / Tempering Lat/Long Values\r\n");
            dLatitude  = 52.2120475;
            dLongitude = -0.0728461;
        }
        else{
            printf("INFO> PinDriftLoc=0\r\n");
        }
    }
    for( int i=0; i<SIZE_BUFF_RX_GPS; i++ )                         //-- EMPTY BUFFER
        buffer[i] = 0x00;
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void CreateFinalAssetMessage( void ){
    //--
    ulTotalRxCntr = ulGPSRxCntr + ulGSMRxCntr;                                  //-- ASSET
    ulTotalTxCntr = ulGPSTxCntr + ulGSMTxCntr;                                  //-- ASSET
    //--
    printf( "INFO> ulGPSRxCntr:%d\r\n", ulGPSRxCntr );
    printf( "INFO> ulGSMRxCntr:%d\r\n", ulGSMRxCntr );
    printf( "INFO> ulGPSTxCntr:%d\r\n", ulGPSTxCntr );
    printf( "INFO> ulGSMTxCntr:%d\r\n", ulGSMTxCntr );
    //--
    memset(caLssFinalAssetMsg, '\0', sizeof(caLssFinalAssetMsg));
    sprintf( caLssFinalAssetMsg, "$AQLSS,01,%s,%s,%.5f,%.5f,%lu,%lu,%d,%d,%.1f*xx\r\n", devStatus.imei,devStatus.imsi, dLatitude,dLongitude,ulTotalRxCntr,ulTotalTxCntr,uiWakeupCounter,uiWatchdogCounter,dBtteryLevel);
    printf( "LSS> %s\r\n", caLssFinalAssetMsg );
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void SendViaModuleSocket( void ){
    ssocket = mdm.socketSocket(MDMParser::IPPROTO_UDP, pport);
    if( ssocket >= 0 ) {
        mdm.socketSetBlocking(ssocket, 10);
        ipp = 0x97092263;//0x052753CE;
        if (PASS == test_exchange_func(caLssFinalAssetMsg,strlen(caLssFinalAssetMsg),ucReturnCode))
            printf("RESULT> -----------------< PASS >-----------------\r\n");
        else
            printf("RESULT> -----------------< FAIL >-----------------\r\n");

        mdm.socketFree(ssocket);
        responce_checker();
    }
    mdm.disconnect();
    //-- mdm.powerOff();

}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
int initialize_modem( void ){
    //--
    //mdm.setDebug(4);
    MDMParser::NetStatus netStatus = {};

    bool mdmOk = gmdm->init(SIMPIN, &devStatus);
    gmdm->dumpDevStatus( &devStatus );
    
    if (mdmOk) {
        mdmOk = mdm.registerNet(&netStatus);
        mdm.dumpNetStatus(&netStatus);
    }    
    
    if( mdmOk ) {
        MDMParser::IP ipp = gmdm->join( APN,USERNAME,PASSWORD );  // join the internet connection
        if( ipp==NOIP ) {
            printf( "LSS> Modem NOT Initialized\r\n" );
            gmdm->powerOff();
            return 0;
        } else {
            printf( "LSS> Modem Initialized\r\n" );
            //ussd_send();
            return 1;
        }
    } else {
        return 0;
    }
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
int recv( int socket_d, char *buf, int len )
{
    int ret = gmdm->socketRecvFrom(ssocket, &ipp, &pport, buf, len);
    //ulGSMRxCntr += len;               //-- iazi UK increasing very fast sometimes.
    return ret;
}

int send(int socket_d, char *buf, int len)
{
    ipp = gmdm->gethostbyname(host);
    ipp = 0x97092263;//0x052753CE;
    int ret = gmdm->socketSendTo(ssocket, ipp, pport, (char*)buf, len);
    ulGSMTxCntr += len;
    return ret;
}

int readseconds(void)
{
    unsigned int seconds = us_ticker_read()/1000000;
    return seconds;
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void responce_checker( void ){
    if(!strcmp((const char*)ucReturnCode,"RC 000"))
        printf("COAP> Acknowledged RC 000\r\n");
    else if(!strcmp((const char*)ucReturnCode,"RC 001"))
        printf("COAP> Acknowledged with Data RC 001\r\n");
    else if(!strcmp((const char*)ucReturnCode,"RC 002")) {
        printf("COAP> Start Sending Data RC 002\r\n");
        bSendingDataFlag = true;
    } else if(!strcmp((const char*)ucReturnCode,"RC 003")) {
        printf("COAP> Stop Sending Data RC 003\r\n");
        bSendingDataFlag = false;
    } else if(!strcmp((const char*)ucReturnCode,"RC 004")) {
        printf("COAP> Enable Sleep mode RC 004\r\n");
        bSleepModeFlag = true;
    } else if(!strcmp((const char*)ucReturnCode,"RC 005")) {
        printf("COAP> Disable Sleep mode RC 005\r\n");
        bSleepModeFlag = false;
    } else if(!strcmp((const char*)ucReturnCode,"RC 006")) {
        printf("COAP> Reboot Client Return Code 006\r\n");
        NVIC_SystemReset();
    } else if(!strcmp((const char*)ucReturnCode,"EC 000"))
        printf("COAP> Error Code 000 Received Connection with web server failed\r\n");
    else if(!strcmp((const char*)ucReturnCode,"EC 001"))
        printf("COAP> Error Code 001 Received Node IMEI is not registered on Server\r\n");
    else if(!strcmp((const char*)ucReturnCode,"EC 002"))
        printf("COAP> Error Code 002 Received Payload is corrupted\r\n");
}
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
