#include "drv_C027_GNSS.h"
#include "MDM.h"
#include "C027_api.h"
#include <ctype.h>

const char* findNmeaItemPos(int ix, const char* start, const char* end)
{
    // find the start
    for (; (start < end) && (ix > 0); start ++)
    {
        if (*start == ',')
            ix --;
    }
    // found and check bounds
    if ((ix == 0) && (start < end) && 
        (*start != ',') && (*start != '*') && (*start != '\r') && (*start != '\n'))
        return start;
    else 
        return NULL;
}

void setNmeaSentenses( void ){
    /*
    prtNmea.printf("$PUBX,40,RMC,0,0,0,0,0,0*47\r\n");      //Turn OFF GPRMC string
    wait(1);
    prtNmea.printf("$PUBX,40,RMC,0,0,0,0,0,0*47\r\n");      //Turn OFF GPRMC string
    wait(1);
    prtNmea.printf("$PUBX,40,GSV,0,0,0,0,0,0*59\r\n");      //Turn OFF GPGSV string
    wait(1);
    prtNmea.printf("$PUBX,40,GSA,0,0,0,0,0,0*4E\r\n");      //Turn OFF GPGSA string
    wait(1);
    prtNmea.printf("$PUBX,40,VTG,0,0,0,0,0,0*5E\r\n");      //Turn OFF GPVTG string
    wait(1);
    prtNmea.printf("$PUBX,40,GGA,0,0,0,0,0,0*5A\r\n");      //Turn OFF GPVTG string
    wait(1);
    */
}

bool getNmeaItem(int ix, char* buf, int len, double& val){
    char* end = &buf[len];
    const char* pos = findNmeaItemPos(ix, buf, end);
    // find the start
    if (!pos)
        return false;
    val = strtod(pos, &end);
    // restore the last character
    return (end > pos);
}

bool getNmeaItem(int ix, char* buf, int len, int& val, int base /*=10*/){
    char* end = &buf[len];
    const char* pos = findNmeaItemPos(ix, buf, end);
    // find the start
    if (!pos)
        return false;
    val = (int)strtol(pos, &end, base);
    return (end > pos);
}

bool getNmeaItem(int ix, char* buf, int len, char& val)
{
    const char* end = &buf[len];
    const char* pos = findNmeaItemPos(ix, buf, end);
    // find the start
    if (!pos)
        return false;
    // skip leading spaces
    while ((pos < end) && isspace(*pos))
        pos++;
    // check bound
    if ((pos < end) && 
        (*pos != ',') && (*pos != '*') && (*pos != '\r') && (*pos != '\n'))
    {
        val = *pos;
        return true;
    }
    return false;
}

bool getNmeaAngle(int ix, char* buf, int len, double& val)
{
    char ch;
    if (getNmeaItem(ix,buf,len,val) && getNmeaItem(ix+1,buf,len,ch) && 
        ((ch == 'S') || (ch == 'N') || (ch == 'E') || (ch == 'W')))
    {
        val *= 0.01;
        int i = (int)val;
        val = (val - i) / 0.6 + i;
        if (ch == 'S' || ch == 'W')
            val = -val;
        return true;
    }
    return false;
}

void arrayInit2Zero(char* buffer,int length)
{
    for(int i= 0;i<length;i++)
        buffer[i] = 0;
}

