#include "mbed.h"
#include "nRF24L01.h"
#include "RF24.h"

//Serial pc(USBTX, USBRX); // tx, rx
Serial pc(PA_9, PA_10);

RF24 radio(PB_5, PB_4, PB_3, PB_7, PB_6); // mosi, miso, sck, csn, ce

struct MyData {
  float voltage;
  float current;
};

MyData data;

void resetData() 
{
  data.voltage = 12;
  data.current = 34;
}

const uint64_t pipeOut =  0xE8E8F0F0E1LL;

int main() {
    
    resetData();  
    
    radio.begin();
    radio.setAutoAck(false);
    radio.setDataRate(RF24_250KBPS);
    radio.openWritingPipe(pipeOut);

    radio.printDetails(pc);

    while (1) {
    
        radio.write( (char*)&data, sizeof(data) );
        
        //wait( 0.01 );
    }
}
