#include "mbed.h"
#include "PPM.h"
 
PPM::PPM(PinName pin): ppm(pin)
{
    for (int i = 0; i < NUM_CHANNELS; i++)
        channels[i] = 1500;
    currentChannel = 0;    
    timer.start();
    ppm.rise( callback(this, &PPM::rise) );
}
            
void PPM::rise()
{
    uint16_t time = timer.read_us();
    timer.reset();
    
    if ( time > 2500 )
    {
       currentChannel = 0;
    }
    else if ( currentChannel < NUM_CHANNELS )
    {
        channels[currentChannel] = time;
        currentChannel++;
    }
}