/* ---------------------------------------
   ---------------------------------------
   Author: Joel Holland
   Purpose: To have mbed send bytes of 
            data to a TCP server.
   Note: Do not update ethernetinterface.h
         new repositories are broken.
    --------------------------------------
    -------------------------------------- */
    
#include "mbed.h"
#include "EthernetInterface.h"

EthernetInterface eth;    //ethernet object
TCPSocketConnection socket;  //socket object
Serial pc(USBTX,USBRX);      //interface with TeraTerm
DigitalOut P17(p17);
AnalogIn LM35(p15);
DigitalOut P16(p16);
DigitalOut P18(p18);
DigitalOut P19(p19);
DigitalOut P20(p20);

static const char* ip = "10.58.92.178";
static const char* mask = "255.255.192.0";
static const char* gateway = "10.58.64.1";

// A data structure of the data to send
// In this case it's fairly pointless, you may as well just use a uint16_t[] directly in place of this
// But if you package what you want into a structure then you don't need to change the 
// transmission code if you change what is being sent, you just change the structure definition.
typedef struct packetToSent_s {   
uint8_t data[1];   //specify data types within the struct, in this case an 80 element array of 8-bit unsigned int
} packetToSend_t;

packetToSend_t dataOut;  //an instance of the packet to send

int main()
{    
    pc.printf("This program constantly polls the temperature sensor\n\n");
    pc.printf("and sends the data packets out through both USB and TCP.\n\n");
    eth.init(ip,mask,gateway);  //static
    wait(5);
    eth.connect();
    wait(5);    //allow the mbed time to be dynamically assigned an IP and to connect before printing IP address
    pc.printf("IP address is %s\n\n", eth.getIPAddress()); //function in ethernet library to return string containing IP
    pc.printf("Mask is is %s\n\n", eth.getNetworkMask());
    pc.printf("Gateway is %s\n\n", eth.getGateway());
    
    socket.connect("10.58.74.19", 23);  //ip address of PC, and port to be listened to by the HOST     
    wait(1);
   
    while(1) {
            float tempC,mv,avgtemp;
            //specify data to be sent. Here we would desire the output from the multiplexer.
            for(int i=0;i<1;i++) {
                float avg=0;
                    for(int j=0;j<100;j++) {
                         mv = ((LM35.read()-0.02)*3300);    //calibrate the analogue pin, multiply by reference voltage, convert to mv.
                 //      pc.printf("voltage of sensor is %.2f",mv);
                //       wait(1);
                         tempC = mv/10;              //LM35 device has a 1 degree change for every 10mv, therefore divide by this to get temp in C.
               //        pc.printf("temperature sample is %.2f C\t",tempC);  
               //        wait(1);                                            
                         avg=avg+tempC;
                         wait(0.01); //take 100 samples at a rate of 1ms
                    }
            avgtemp=avg/100;
            pc.printf("Temperature is %2.2f C\t\t\t", avgtemp);  
            uint8_t b;
            b=avgtemp; //remove offset from analogue pin, then convert to unsigned integer 8 bit (2 bytes). 
            dataOut.data[i]=b;  //populate array with analogue readings from pin 17. Remove offset.
            }

    //send the data packet by passing a pointer to the start of the data, and specifying its size. 
    
    socket.send_all((char*)&dataOut,sizeof(packetToSend_t));
    //socket.send_all((char*)&dataOut2,sizeof(packetToSend_t));  here we could send packets corresponding to different data types
    }
//ideally should check return value from send_all to verify no errors have occured.


}


