#ifndef LWIP_UTILS_H
#define LWIP_UTILS_H

#include "ipv4/lwip/ip_addr.h"
#include "netif/etharp.h"
#include "mbed.h"

/**
 * This method converts 4 given IPv4 tuples to struct ip_addr classes.
 * The Byte are seperated by ,
 * Does only work with seperated 4 Byte tuple.
 */
inline struct ip_addr ipv4addr(u8_t ip0, u8_t ip1, u8_t ip2, u8_t ip3) {
  struct ip_addr addr;
  IP4_ADDR(&addr, ip0, ip1, ip2, ip3);
  return addr;
}

/**
 * This method converts 6 given ethernet addresses tuples to struct eth_addr classes.
 * The Byte are seperated by ,
 */
inline struct eth_addr ethaddr(u8_t ip0, u8_t ip1, u8_t ip2, u8_t ip3, u8_t ip4, u8_t ip5) {
  struct eth_addr addr;
  addr.addr[0] = ip0;
  addr.addr[1] = ip1;
  addr.addr[2] = ip2;
  addr.addr[3] = ip3;
  addr.addr[4] = ip4;
  addr.addr[5] = ip5;
  return addr;
}

unsigned int base64enc_len(const char *str);

void base64enc(const char *input, unsigned int length, char *output);

#endif /* LWIP_UTILS_H */
