#include "lwip/opt.h"
#include "lwip/stats.h"
#include "lwip/sys.h"
#include "lwip/pbuf.h"
#include "lwip/udp.h"
#include "lwip/tcp.h"
#include "lwip/dns.h"
#include "lwip/dhcp.h"
#include "lwip/init.h"
#include "lwip/netif.h"
#include "netif/etharp.h"
#include "netif/loopif.h"
#include "device.h"

#include "mbed.h"

DigitalOut led(LED1);

/* Struct with hold the Ethernet Data */
struct netif    netif_data;

/* Every time called if a packet is received for a */
/* TCPConnection which registerd this Callback. */
err_t recv_callback(void *arg, struct tcp_pcb *pcb, struct pbuf *p, err_t err) {
    printf("recv_callback\n");
    if (p==NULL) {
        printf("Connection closed by server!\n");
        return ERR_OK;
    }

    while (p) {
        char * ch = (char*)p->payload;
        printf("\n>>>>>>>>>>>>\n");
        for (int i=0; i < p->len; i++) {
            printf("%c", ch[i]);
        }
        printf("\n<<<<<<<<<<<<\n");
        p = p->next;
    }
    tcp_recved(pcb, p->tot_len);
    pbuf_free(p);
    return ERR_OK;
}

/* Connection etablished, lets try to get a http page */
err_t connected_callback(void *arg, struct tcp_pcb *pcb, err_t err) {
    tcp_recv(pcb, &recv_callback);
    printf("Connected Callback!\n");
    char msg[] = "GET / HTTP/1.1\r\nHost: www.google.co.uk\r\n\r\n";
    if (tcp_write(pcb, msg, strlen(msg), 1) != ERR_OK) {
        error("Could not write", 0);
    }
    return ERR_OK;
}

int main(void) {
    /* Create and initialise variables */
    struct netif   *netif = &netif_data;
    struct ip_addr  ipaddr;
    struct ip_addr  target;
    struct ip_addr  netmask;
    struct ip_addr  gateway;

    Ticker tickFast, tickSlow, tickARP, eth_tick, dns_tick, dhcp_coarse, dhcp_fine;
    char *hostname = "mbed-c3p0";

    /* Start Network with DHCP */
    IP4_ADDR(&netmask, 255,255,255,255);
    IP4_ADDR(&gateway, 0,0,0,0);
    IP4_ADDR(&ipaddr, 0,0,0,0);
    IP4_ADDR(&target, 209,85,229,147); // www.google.co.uk

    /* Initialise after configuration */
    lwip_init();

    netif->hwaddr_len = ETHARP_HWADDR_LEN;
    device_address((char *)netif->hwaddr);

    netif = netif_add(netif, &ipaddr, &netmask, &gateway, NULL, device_init, ip_input);
    netif->hostname = hostname;
    netif_set_default(netif);
    dhcp_start(netif); // <-- Use DHCP

    /* Initialise all needed timers */
    tickARP.attach_us( &etharp_tmr,  ARP_TMR_INTERVAL  * 1000);
    tickFast.attach_us(&tcp_fasttmr, TCP_FAST_INTERVAL * 1000);
    tickSlow.attach_us(&tcp_slowtmr, TCP_SLOW_INTERVAL * 1000);
    dns_tick.attach_us(&dns_tmr, DNS_TMR_INTERVAL * 1000);
    dhcp_coarse.attach_us(&dhcp_coarse_tmr, DHCP_COARSE_TIMER_MSECS * 1000);
    dhcp_fine.attach_us(&dhcp_fine_tmr, DHCP_FINE_TIMER_MSECS * 1000);

    // Wait for an IP Address
    while (!netif_is_up(netif)) {
        device_poll();
    }

    /* Connect do google */
    struct tcp_pcb *pcb = tcp_new();
    tcp_connect(pcb, &target, 80, &connected_callback);

    /* Give the signal that we are ready */
    printf("entering while loop\n");
    while (1) {
        led = !led;
        wait(0.1);
        device_poll();
    }
}

