#include "mbed.h"
#include "Receiver.h"
#include "rplidar.h"
RPLidar lidar1;

DigitalOut rs485_dirc(RS485_DIRC);

Bear_Receiver::Bear_Receiver(PinName tx,PinName rx,int baudrate)
{
    com = new COMMUNICATION(tx,rx,baudrate);
}

uint8_t Bear_Receiver::ReceiveCommand(uint8_t *id,uint8_t *data_array,uint8_t *ins)
{
    ANDANTE_PROTOCOL_PACKET package;

    rs485_dirc=0;
    wait_us(RS485_DELAY);
    uint8_t status = com->receiveCommunicatePacket(&package);

    if(status == ANDANTE_ERRBIT_NONE) {

        *id = package.robotId;
        for(int i=0; i<30; i++) {
            data_array[i] = package.parameter[i];
        }
        *ins=package.instructionErrorId;

    }
    return status;
}

void Bear_Receiver::FloatSep(float input_float,uint8_t *int_data_array,uint8_t *float_data_array)
{
    float float_buffer;
    float int_buffer;
    int16_t integer;
    int16_t floating_point;

    float_buffer=modf(input_float,&int_buffer);
    float_buffer*=FLOAT_CONVERTER;
    integer=(int16_t)int_buffer;
    floating_point=(int16_t)float_buffer;
    Utilities::ConvertInt16ToUInt8Array(integer,int_data_array);
    Utilities::ConvertInt16ToUInt8Array(floating_point,float_data_array);
}

uint8_t Bear_Receiver::sendKpKiKdLeft(float Kp,float Ki,float Kd)
{
    uint8_t IntKp[2],FloatKp[2];
    uint8_t IntKi[2],FloatKi[2];
    uint8_t IntKd[2],FloatKd[2];

    FloatSep(Kp,IntKp,FloatKp);
    FloatSep(Ki,IntKi,FloatKi);
    FloatSep(Kd,IntKd,FloatKd);


    ANDANTE_PROTOCOL_PACKET package;

    package.robotId = ID;
    package.length = 14;
    package.instructionErrorId = WRITE_DATA;
    package.parameter[0]=IntKp[0];
    package.parameter[1]=IntKp[1];
    package.parameter[2]=FloatKp[0];
    package.parameter[3]=FloatKp[1];
    package.parameter[4]=IntKi[0];
    package.parameter[5]=IntKi[1];
    package.parameter[6]=FloatKi[0];
    package.parameter[7]=FloatKi[1];
    package.parameter[8]=IntKd[0];
    package.parameter[9]=IntKd[1];
    package.parameter[10]=FloatKd[0];
    package.parameter[11]=FloatKd[1];

    wait_us(RS485_DELAY);
    return com->sendCommunicatePacket(&package);
}

uint8_t Bear_Receiver::sendKpKiKdRight(float Kp,float Ki,float Kd)
{
    uint8_t IntKp[2],FloatKp[2];
    uint8_t IntKi[2],FloatKi[2];
    uint8_t IntKd[2],FloatKd[2];

    FloatSep(Kp,IntKp,FloatKp);
    FloatSep(Ki,IntKi,FloatKi);
    FloatSep(Kd,IntKd,FloatKd);


    ANDANTE_PROTOCOL_PACKET package;

    package.robotId = ID;
    package.length = 14;
    package.instructionErrorId = WRITE_DATA;
    package.parameter[0]=IntKp[0];
    package.parameter[1]=IntKp[1];
    package.parameter[2]=FloatKp[0];
    package.parameter[3]=FloatKp[1];
    package.parameter[4]=IntKi[0];
    package.parameter[5]=IntKi[1];
    package.parameter[6]=FloatKi[0];
    package.parameter[7]=FloatKi[1];
    package.parameter[8]=IntKd[0];
    package.parameter[9]=IntKd[1];
    package.parameter[10]=FloatKd[0];
    package.parameter[11]=FloatKd[1];

    rs485_dirc=1;
    wait_us(RS485_DELAY);
    return com->sendCommunicatePacket(&package);
}

uint8_t Bear_Receiver::sendMaxMinLidarDegree(float Kp,float Ki)
{
    uint8_t IntKp[2],FloatKp[2];
    uint8_t IntKi[2],FloatKi[2];

    FloatSep(Kp,IntKp,FloatKp);
    FloatSep(Ki,IntKi,FloatKi);


    ANDANTE_PROTOCOL_PACKET package;

    package.robotId = ID;
    package.length = 10;
    package.instructionErrorId = WRITE_DATA;
    package.parameter[0]=IntKp[0];
    package.parameter[1]=IntKp[1];
    package.parameter[2]=FloatKp[0];
    package.parameter[3]=FloatKp[1];
    package.parameter[4]=IntKi[0];
    package.parameter[5]=IntKi[1];
    package.parameter[6]=FloatKi[0];
    package.parameter[7]=FloatKi[1];

    rs485_dirc=1;
    wait_us(RS485_DELAY);
    return com->sendCommunicatePacket(&package);
}

uint8_t Bear_Receiver::sendSensorDataAll1(float *data)
{
    uint8_t IntArray[2],FloatArray[2];

    ANDANTE_PROTOCOL_PACKET package;

    package.robotId = ID;
    package.length = 42;
    package.instructionErrorId = WRITE_DATA;
    int k=0;
    for(int i=0; i<40; i++) {
        if(i%2==0)
        {
            FloatSep(data[k],IntArray,FloatArray);
            package.parameter[i-2]=IntArray[0];
            package.parameter[i-1]=IntArray[1];
            k++;
        }
        if(i==39)
        {
            FloatSep(data[k],IntArray,FloatArray);
            package.parameter[i-2]=IntArray[0];
            package.parameter[i-1]=IntArray[1];
        }
    }

    uint8_t status = com->sendCommunicatePacket(&package);
    wait_us(RS485_DELAY);
    return status;

    //xxxxxxxx
    /*uint8_t IntKp[2],FloatKp[2];
    uint8_t IntKi[2],FloatKi[2];

    FloatSep(Kp,IntKp,FloatKp);
    FloatSep(Ki,IntKi,FloatKi);


    ANDANTE_PROTOCOL_PACKET package;

    package.robotId = ID;
    package.length = 10;
    package.instructionErrorId = WRITE_DATA;
    package.parameter[0]=IntKp[0];
    package.parameter[1]=IntKp[1];
    package.parameter[2]=FloatKp[0];
    package.parameter[3]=FloatKp[1];
    package.parameter[4]=IntKi[0];
    package.parameter[5]=IntKi[1];
    package.parameter[6]=FloatKi[0];
    package.parameter[7]=FloatKi[1];

    rs485_dirc=1;
    wait_us(RS485_DELAY);
    return com->sendCommunicatePacket(&package);*/
}