/** 05_comparator_demo
 *  Simple program to demonstrate the basic functions
 *  of the analog comparator of the FRDM-KL25Z board.
 *
 *  Used library:
 *   - ComparatorIn //https://developer.mbed.org/users/frankvnk/code/ComparatorIn/
 *     written by Frank Vannieuwkerke
 *
 *  Hardware requirements:
 *   - FRDM-KL25 board
 *   - CdS photoresistor pulled up by 10 k
 *   - Connecect the midpoint of the divider to PTE29
 *
 *            10k          CdS photoresistor
 *   +3.3V --/\/\/\---+---/\/\/\---- GND
 *                    |
 *                  PTE29
 *
 */

#include "mbed.h"
#include "ComparatorIn.h"
 
DigitalOut blinker (LED_BLUE);      // blinking LED
DigitalOut cmpled (LED_GREEN);      // signing comparator status
AnalogIn cmp_lvl (PTE29);           // ADC input to check comparator input
ComparatorIn compi(PTE29, PTE30);   // in+ = PTE29, in- = 12-bit DAC 
 
// Comparator interrupt callback functions
void cmp_rise_ISR(void)
{
    cmpled = 0;                     // LED ON at rising edge
}
 
void cmp_fall_ISR(void)
{
    cmpled = 1;                     // LED OFF at falling edge
}
 
 
 
int main()
{
    cmpled = 1;                     // LED OFF at the beginning
 
    compi.rising(&cmp_rise_ISR);    // Set pointer to rising interrupt function
    compi.falling(&cmp_fall_ISR);   // Set pointer to falling interrupt function
    compi.treshold(0.3);            // Set comparator threshold to 1V = 0.3 * 3.3V
 
    while(1)
    {
        printf("Light sensor : %7.5f Volt\n",cmp_lvl*3.3);
        blinker = 1;                // binking LED OFF
        wait(2);                    // wait for 2 sec
        blinker = 0;                // blinking LED ON
        wait(0.2);
        if (compi.status() == 0x01) // poll comparator status
        {
            printf("*** Treshold reached : %7.5f\n",cmp_lvl*3.3);
        }
    }
}
 
 
