/** 05_analog_thermometer
 * Measeures the temperature by using a Microchip MCP9700A
 * analog thermometer (parameteres: 10 mV/C, 500 mV offset, VCC= 2.3-5.5V)
 * Result is printed to standard output.
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - MCP9700A analog thermometer connected to A0 (PTB0)
 */

#include "mbed.h"

AnalogIn ain(A0);                           // Analog input at PTB0

int main()
{
    printf("\r\n05_analog_thermometer program\r\n");
    while(1) {
        uint16_t raw = ain.read_u16();      // read raw 16-bit data
        float voltage = ain.read()*3300;    // read voltage in millivolts
        float tempC = (voltage -500)/10;    // tempereature in Celsius
        printf("ADC: 0x%04X voltage: %5.0f temp: %5.1f C\r\n",raw,voltage,tempC);
        wait(2);
    }
}
