/** TSISensor example program
 *  Read the capacitive touch slider of the FRDM-KL25Z board
 *  and control the power of the blue LED accordingly.
 *
 *  Hardware requirements:
 *   - Freescale FRDM-KL25Z board
 */

#include "mbed.h"
#include "TSISensor.h"
 
int main(void) {
    PwmOut led(LED_BLUE);               //Configure a PWM output for the blue LED
    TSISensor tsi;                      //Configure the touch sensing module
    led = 1.0;                          //LED off at the beginning 
    while (true) {
        float s = tsi.readPercentage(); //Read slider status
        if (s > 0.01) led = 1.0 - s;    //Control LED power if touch occurred
        wait(0.1);                      //wait a little...
    }
}