/** 03_pwm_servo
 * This program moves the servo back and forth
 * within the full range of pulse width = 1.0 - 2.0 ms. 
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - Servo connected to D3, +5V and GND
 */ 

#include "mbed.h"
PwmOut servo(D3);

int main() {
    servo.period_ms(20);            //Period = 20 ms (f=50 Hz)
    while(true) {    
        for(int pw=1000; pw <= 2000; pw=pw+20) {
            servo.pulsewidth_us(pw);    //Set new servo position
            wait_ms(200);
        }
        wait_ms(1000);                  //Wait before reverse direction
        for(int pw=2000; pw >= 1000; pw=pw-20) {
            servo.pulsewidth_us(pw);    //Set new servo position
            wait_ms(200);
        }
        wait_ms(1000);
    }
}