/** 03_pwm_music
 * This program plays the Oranges and Lemons music
 * on a piezo buzzer tied between D3 (PTA12) pin and GND
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - Piezo buzzer tied between D3 (PTA12) pin and GND
 * Note: The + pin of the buzzer connects to D3, of course...
 *
 * This is an example program borrowed from the
 * Pulse Width Modulation section of ARM mbed Course Material
 * Authors: Rob Toulson and Tim Wilmshurst
 * Link: https://developer.mbed.org/cookbook/Course-Notes
 */ 
#include "mbed.h"
PwmOut buzzer(D3);
float frequency[]={659,554,659,554,550,494,554,587,494,659,554,440}; //frequency array
float beat[]={1,1,1,1,1,0.5,0.5,1,1,1,1,2};     //beat array

int main() {
    while (1) {
        for (int i=0; i<=11; i++) {
            buzzer.period(1/(frequency[i]));    // set PWM period
            buzzer=0.5;                         // set duty cycle
            wait(0.5*beat[i]);                  // hold for beat period
        }
    }
}