/** 03_pwm_led
 * This program controls the duty cycle of 
 * a PWM output connected to LED1 (LED_RED)
 * through the serial connection.
 *
 * Valid commands: '1', '5', '9'
 * Corresponding duty cycle: 10%, 50%, 90% 
 * Period: 2000 ms
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 */ 

#include "mbed.h"

PwmOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    myled.period_ms(20);    //Period = 20 ms
    myled.write(1.0);       //Led off at start
    pc.printf("\r\n03_pwm_led: this program controls the duty cycle of a \r\nPWM output connected to LED1 (LED_RED) through the serial connection.\r\n");
    pc.printf("Period: 20 ms, Valid commands are: '1', '5', '9'\r\nThe corresponding duty cycle are: 1%, 50%, 99%\r\n");

    while(1) {
        char c = pc.getc(); //read next character
        if(c=='1') {
            myled = 0.99f;   //LED has negative logic!
            pc.printf("Duty cycle = 0.01\r\n");
        }
        else if(c=='5') {
            myled = 0.5f;
            pc.printf("Duty cycle = 0.5\r\n");        
        }
        else if(c=='9') {
            myled = 0.01f;   //LED has negative logic!
            pc.printf("Duty cycle = 0.99\r\n");            
        }        
        wait(0.2);
    }
}
