#if !defined(MQTTSOCKET_H)
#define MQTTSOCKET_H

#include "MQTTmbed.h"
#include "UDPSocket.h"

class MQTTSNUDP
{
public:    
    int connect(char* hostname, int port, int timeout=1000)
    {
        mysock.init();
        //mysock.set_blocking(false, timeout);    // 1 second Timeout 
        return remote.set_address((const char *)hostname, port);
    }

    int read(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_blocking(false, timeout);  
        return mysock.receiveFrom(remote, (char *)buffer, len);
    }
    
    int write(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_blocking(false, timeout);  
        return mysock.sendTo(remote, (char*)buffer, len);
    }
    
    int disconnect()
    {
        return mysock.close();
    }
    
private:

    UDPSocket mysock;
    Endpoint remote;
    
};



#endif
