#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);
Serial gps(PB_10, PC_5);

int main()
{
    uint8_t c;
    
    pc.baud(4800);
    gps.baud(4800);
    
    pc.printf("*** GPS ***\n");
    while(1) {
        if (gps.readable()) {
            c = gps.getc();
            pc.putc(c);
        }
        if (pc.readable()) {
            c = pc.getc();
            gps.putc(c);
        }
    }
}
