#include "mbed.h"
#include <stdio.h>
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "LCD_LOG_DISCO.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
LCDLog lcdlog("lcdlog");

extern "C" {
    int LCD_LOG_write(uint8_t* text);
}

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x = 0, y = 0;

    lcdlog.Init(stdout, "TOUCHSCREEN DEMO");

    if (ts.Init(lcd.GetXSize(), lcd.GetYSize()) != TS_OK)
    {
        lcdlog.Footer("INIT FAIL\n");
    } else {
        lcdlog.Footer("INIT OK");
    }

    printf("** Start **\n");
    while(1)
    {
        ts.GetState(&TS_State);
        if (TS_State.TouchDetected)
        {
            if (x != TS_State.X || y != TS_State.Y) {
                x = TS_State.X;
                y = TS_State.Y;
                printf("x=%03d y=%03d\n", x, y);
            }
        }
        wait_ms(5);
    }
}
