#include "mbed.h"
#include "math.h"               // include math.h to get sin function

PwmOut r (LED_RED);
PwmOut g (LED_GREEN);
PwmOut b (LED_BLUE);

float lr, lg, lb;               // temp variables for printing current values
const float pi = 3.1415927;     // create a constant to use for value of pi

Serial PC(USBTX,USBRX);         // define serial port for outputting RGB values

int main() {

    PC.baud(115200);            // set baud rate for serial port

    r.period(0.001);
    g.period(0.001);
    b.period(0.001);

    while (true) {
        for (float i = 0.0; i < 60*pi ; i += 0.001) {

            lr = (1+sin(2*i))/2;    // calculate values for RGB based on different
            lg = (1+sin(3*i))/2;    // frequency sin waves. This should give a nice
            lb = (1+sin(5*i))/2;    // smooth transistion between colors and a 
                                    // somewhat non repeating color sequence 

            r = lr;                 // send RGB values to LED PWMs
            g = lg;
            b = lb;
            
            PC.printf("%f  %f  %f  %f\r\n", i, lr, lg, lb);    // output to console

            wait (0.0025);          // some delay so we can see the changes
        }
    }
}