/* Programa para utilização do sensor Ultrasom
*/
/*Interrupções de pinos,só são possíveis nas portas A e D*/

#include "mbed.h"

 Serial pc(USBTX,USBRX);  //Configuração da comunicação serial para enviar o valor do sensor
 DigitalOut trig(PTE5,0);  //Configuração do pino de Trigger
 InterruptIn echo(PTA16);   //Configuração da interrupção por pino de Echo 
 Timer tempo;
 float tdist=0, distcm=0, distin=0, dist0=0;

    void iniP(){            //Rotina para receber o pulso inicial do pino Echo
        tempo.start();      //Rotina para iniciar o contador
        return;
        }
        
    void finP(){ //Rotina para pegar o tempo final do pulso
    
        tdist = tempo.read_us();  //Leitura do tempo transcorrido
        distcm = tdist/58;         //Cálculo da distância detectada em "cm"
        distin = tdist/148;        //Cálculo da distância detectada em "in"
        
        tempo.stop();           //Páro o temporizador
        tempo.reset();          //Reset para o próximo ciclo
        return;
        }
        
        
        
    int main(){
        
        while(1){
            
            trig=1;             //Inicio do trigger
            wait_us(10);        // 10us de pulso
            trig=0;             //Fim do trigger
            
            echo.rise(&iniP);   //leitura do inicio do pulso de retorno
            echo.fall(&finP);   //Leitura do final do pulso de retorno
            
            if(distcm != dist0){ //rotina para evitar que se envie muitos valores
                dist0 = distcm;
                printf("Distancia detectada pelo sensor %.2f cm \n",distcm); 
            }
           wait_ms(60);     //rotina para evitar que o pulso de "trigger" seja confundido com o "echo"           
        }
             
         
    }