#include "mbed.h"
#include "MorseCode.h"

DigitalOut LED(LED1); // LED that blinks every .5 seconds
PwmOut Speaker(p21); // Speaker
Timer Time;
AnalogIn photocell(p15); //CdS Powercell

int main() {
    int up = 0;
    int read = 0;
    Speaker.period(1.0/800.0);  //initializes speaker tone
    Time.start();   //starts timer
    int value = 0;
    
    while(1) {
    
        //Timer
        if(Time.read_ms()%500<15) { 
            up = !up;
            read = 0;
            if((Time.read_ms() - 1740000) > 0) {
                Time.reset();
            }
            wait_ms(15);
        }
        
        //LED
        LED = (up)? 1 : 0;  //LED blinks every other .5 second
        
        //Reads in Morse Code  
        if(Time.read_ms()%500 > 250 && read == 0) { // .25 Second Has Passed
            read = 1;
            if (photocell.read() < 0.5) {  
                value = 0;      //if the light is not on
            } else {
                value = 1;      //if the light is on
            }
            MorseCode(value); //Translates the Morse code
        }
        
        //Speaker
        if(value) {
            Speaker = 0.1;  //Plays tone if light is on
            wait_ms(15);
        }
        else {
            Speaker = 0.0; //Mutes tone if light is off
            wait_ms(15);
        }
        
    }
}
